/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.Activator;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IProductPreferencesService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DefaultPreferences
extends EclipsePreferences {
    private static Set loadedNodes = new HashSet();
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final IPath NL_DIR = new Path("$nl$");
    private static final String PROPERTIES_FILE_EXTENSION = "properties";
    private static Properties productCustomization;
    private static Properties productTranslation;
    private static Properties commandLineCustomization;
    private EclipsePreferences loadLevel;
    private String qualifier;
    private int segmentCount;
    private WeakReference pluginReference;
    public static String pluginCustomizationFile;
    static /* synthetic */ Class class$0;

    static {
        pluginCustomizationFile = null;
    }

    public DefaultPreferences() {
        this(null, null);
    }

    private DefaultPreferences(EclipsePreferences parent, String name, Object context) {
        this(parent, name);
        this.pluginReference = new WeakReference<Object>(context);
    }

    private DefaultPreferences(EclipsePreferences parent, String name) {
        super(parent, name);
        if (parent instanceof DefaultPreferences) {
            this.pluginReference = ((DefaultPreferences)parent).pluginReference;
        }
        String path = this.absolutePath();
        this.segmentCount = DefaultPreferences.getSegmentCount(path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = DefaultPreferences.getSegment(path, 1);
    }

    private void applyBundleDefaults() {
        Bundle bundle = PreferencesOSGiUtils.getDefault().getBundle(this.name());
        if (bundle == null) {
            return;
        }
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("preferences.ini"), null);
        if (url == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Preference default override file not found for bundle: " + bundle.getSymbolicName());
            }
            return;
        }
        URL transURL = FileLocator.find((Bundle)bundle, (IPath)NL_DIR.append("preferences").addFileExtension(PROPERTIES_FILE_EXTENSION), null);
        if (transURL == null && EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Preference translation file not found for bundle: " + bundle.getSymbolicName());
        }
        this.applyDefaults(this.name(), this.loadProperties(url), this.loadProperties(transURL));
    }

    private void applyCommandLineDefaults() {
        if (commandLineCustomization == null) {
            String filename = pluginCustomizationFile;
            if (filename == null) {
                if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                    PrefsMessages.message("Command-line preferences customization file not specified.");
                }
                return;
            }
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Using command-line preference customization file: " + filename);
            }
            commandLineCustomization = this.loadProperties(filename);
        }
        this.applyDefaults(null, commandLineCustomization, null);
    }

    private void applyDefaults(String id, Properties defaultValues, Properties translations) {
        Enumeration<Object> e = defaultValues.keys();
        while (e.hasMoreElements()) {
            String fullKey = (String)e.nextElement();
            String value = defaultValues.getProperty(fullKey);
            if (value == null) continue;
            Path childPath = new Path(fullKey);
            String key = childPath.lastSegment();
            childPath = childPath.removeLastSegments(1);
            String localQualifier = id;
            if (id == null) {
                localQualifier = childPath.segment(0);
                childPath = childPath.removeFirstSegments(1);
            }
            if (!this.name().equals(localQualifier)) continue;
            value = this.translatePreference(value, translations);
            if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                PrefsMessages.message("Setting default preference: " + new Path(this.absolutePath()).append((IPath)childPath).append(key) + '=' + value);
            }
            ((EclipsePreferences)this.internalNode(childPath.toString(), false, null)).internalPut(key, value);
        }
    }

    public IEclipsePreferences node(String childName, Object context) {
        return this.internalNode(childName, true, context);
    }

    private void applyRuntimeDefaults() {
        WeakReference ref = PreferencesService.getDefault().applyRuntimeDefaults(this.name(), this.pluginReference);
        if (ref != null) {
            this.pluginReference = ref;
        }
    }

    private void applyProductDefaults() {
        if (productCustomization == null) {
            BundleContext context = Activator.getContext();
            if (context != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.preferences.IProductPreferencesService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ServiceTracker productTracker = new ServiceTracker(context, clazz.getName(), null);
                productTracker.open();
                IProductPreferencesService productSpecials = (IProductPreferencesService)productTracker.getService();
                if (productSpecials != null) {
                    productCustomization = productSpecials.getProductCustomization();
                    productTranslation = productSpecials.getProductTranslation();
                }
                productTracker.close();
            } else {
                PrefsMessages.message("Product-specified preferences called before plugin is started");
            }
        }
        this.applyDefaults(null, productCustomization, productTranslation);
    }

    public void flush() {
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        return new DefaultPreferences(nodeParent, nodeName, context);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void load() {
        this.loadDefaults();
    }

    private void loadDefaults() {
        this.applyRuntimeDefaults();
        this.applyBundleDefaults();
        this.applyProductDefaults();
        this.applyCommandLineDefaults();
    }

    /*
     * Exception decompiling
     */
    private Properties loadProperties(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 89->92)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Properties loadProperties(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 125->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    public void sync() {
    }

    private String translatePreference(String value, Properties props) {
        value = value.trim();
        if (props == null || value.startsWith(KEY_DOUBLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(KEY_PREFIX)) {
            int ix = value.indexOf(" ");
            String key = ix == -1 ? value.substring(1) : value.substring(1, ix);
            String dflt = ix == -1 ? value : value.substring(ix + 1);
            return props.getProperty(key, dflt);
        }
        return value;
    }
}

