/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;

public class OSGiPreferencesServiceImpl
implements PreferencesService {
    private File systemPrefsDir;
    private File userPrefsDir;
    Preferences systemPreferences;
    Map userPreferences;

    OSGiPreferencesServiceImpl(File prefsLocation) {
        this.systemPrefsDir = new File(prefsLocation, "system");
        this.userPrefsDir = new File(prefsLocation, "user");
        this.userPreferences = new TreeMap();
    }

    public Preferences getSystemPreferences() {
        if (this.systemPreferences == null) {
            this.systemPreferences = new OSGiPreferences(this.systemPrefsDir, this);
            try {
                this.systemPreferences.sync();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        return this.systemPreferences;
    }

    public Preferences getUserPreferences(String name) {
        Preferences userPref = (Preferences)this.userPreferences.get(name);
        if (userPref == null) {
            userPref = new OSGiPreferences(new File(this.userPrefsDir, name), this);
            try {
                userPref.sync();
            }
            catch (BackingStoreException backingStoreException) {}
            this.userPreferences.put(name, userPref);
        }
        return userPref;
    }

    public String[] getUsers() {
        return this.userPrefsDir.list();
    }

    void destroy() {
        try {
            if (this.systemPreferences != null && this.systemPreferences.nodeExists("")) {
                this.systemPreferences.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {}
        Iterator it = this.userPreferences.values().iterator();
        while (it.hasNext()) {
            Preferences userPreference = (Preferences)it.next();
            try {
                if (!userPreference.nodeExists("")) continue;
                userPreference.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private static final class OSGiPreferences
    extends EclipsePreferences
    implements Preferences {
        private IPath location;
        private IEclipsePreferences loadLevel;
        private OSGiPreferencesServiceImpl prefsServiceImpl;

        OSGiPreferences(File prefsDir, OSGiPreferencesServiceImpl prefsServiceImpl) {
            super(null, "");
            this.prefsServiceImpl = prefsServiceImpl;
            this.location = new Path(prefsDir.getPath());
            this.loadLevel = this;
        }

        OSGiPreferences(EclipsePreferences nodeParent, String nodeName, OSGiPreferencesServiceImpl prefsServiceImpl) {
            super(nodeParent, nodeName);
            this.loadLevel = nodeParent.getLoadLevel();
            this.prefsServiceImpl = prefsServiceImpl;
        }

        protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
            return new OSGiPreferences(nodeParent, nodeName, this.prefsServiceImpl);
        }

        protected IPath getLocation() {
            return this.location;
        }

        protected IEclipsePreferences getLoadLevel() {
            return this.loadLevel;
        }

        public Preferences node(String pathName) {
            if (pathName.length() > 1 && pathName.endsWith("/") || pathName.indexOf("//") != -1) {
                throw new IllegalArgumentException();
            }
            return super.node(pathName);
        }

        public void removeNode() throws BackingStoreException {
            if (this.parent() == null) {
                this.flush();
                if (this == this.prefsServiceImpl.systemPreferences) {
                    this.prefsServiceImpl.systemPreferences = null;
                } else {
                    this.prefsServiceImpl.userPreferences.values().remove(this);
                }
            }
            super.removeNode();
            this.removed = true;
        }

        public byte[] getByteArray(String key, byte[] defaultValue) {
            byte[] encodedBytes;
            String value = this.internalGet(key);
            byte[] byteArray = null;
            if (value != null && (encodedBytes = value.getBytes()).length % 4 == 0) {
                try {
                    byteArray = Base64.decode(encodedBytes);
                }
                catch (Exception exception) {}
            }
            return byteArray == null ? defaultValue : byteArray;
        }
    }
}

