/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.help.IIndex;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.internal.index.IndexEntry;

public class Index
implements IIndex {
    protected Map entries = new TreeMap(new IgnoreCaseComparator());

    public Index() {
    }

    public Index(List entries) {
        this();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            IndexEntry entry = (IndexEntry)i.next();
            this.entries.put(entry.getKeyword(), entry);
        }
    }

    protected IndexEntry addEntry(String keyword) {
        IndexEntry oldEntry = (IndexEntry)this.entries.get(keyword);
        if (oldEntry == null) {
            oldEntry = new IndexEntry(keyword);
            this.entries.put(keyword, oldEntry);
        }
        return oldEntry;
    }

    public Map getEntryMap() {
        return this.entries;
    }

    public IIndexEntry[] getEntries() {
        if (this.entries == null) {
            return new IIndexEntry[0];
        }
        Collection entryCollection = this.entries.values();
        IIndexEntry[] entryArray = new IIndexEntry[entryCollection.size()];
        entryCollection.toArray(entryArray);
        return entryArray;
    }

    public static final class IgnoreCaseComparator
    implements Comparator {
        public int compare(Object left, Object right) {
            return ((String)left).compareToIgnoreCase((String)right);
        }
    }
}

