/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.FilterableUAElement;
import org.eclipse.help.internal.xhtml.DOMUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UAContentFilterProcessor {
    public Document applyFilters(Document dom) {
        Element body = DOMUtil.getBodyElement(dom);
        NodeList allChildElements = body.getChildNodes();
        int i = 0;
        while (i < allChildElements.getLength()) {
            Node node = allChildElements.item(i);
            if (node instanceof Element) {
                this.applyFilters((Element)node);
            }
            ++i;
        }
        return dom;
    }

    public void applyFilters(Element element) {
        Element[] filters;
        boolean filteredIn = false;
        if (UAContentFilterProcessor.hasFilterAttribute(element) ? !(filteredIn = this.processFilterAttribute(element)) : UAContentFilterProcessor.hasFiltersAsChildren(element) && !(filteredIn = this.processFilterChildren(element, filters = DOMUtil.getElementsByTagName(element, "filter")))) {
            return;
        }
        NodeList allChildElements = element.getChildNodes();
        int i = 0;
        while (i < allChildElements.getLength()) {
            Node node = allChildElements.item(i);
            if (node instanceof Element) {
                Element childElement = (Element)node;
                this.applyFilters(childElement);
            }
            ++i;
        }
    }

    public String getCurrentValue(String filterName) {
        IProduct product;
        if (filterName.equals("ws")) {
            return Platform.getWS();
        }
        if (filterName.equals("os")) {
            return Platform.getOS();
        }
        if (filterName.equals("arch")) {
            return Platform.getOSArch();
        }
        if (filterName.equals("product") && (product = Platform.getProduct()) != null) {
            return product.getId();
        }
        return null;
    }

    private static boolean hasFilterAttribute(Element element) {
        return !element.getAttribute(DOMUtil.ATT_FILTER).equals("");
    }

    private static boolean hasFiltersAsChildren(Element element) {
        Element[] filters = DOMUtil.getElementsByTagName(element, "filter");
        return filters != null && filters.length > 0;
    }

    private boolean processFilterAttribute(Element element) {
        String value;
        String filterString = element.getAttribute(DOMUtil.ATT_FILTER);
        String[] parsedFilterString = filterString.split("=");
        String filter = parsedFilterString[0];
        boolean filtered_in = this.isFilteredIn(filter, value = parsedFilterString[1]);
        if (!filtered_in) {
            element.getParentNode().removeChild(element);
        }
        return filtered_in;
    }

    private boolean processFilterChildren(Element parent, Element[] filters) {
        boolean filtered_in = false;
        int i = 0;
        while (i < filters.length) {
            String value;
            String filter = filters[i].getAttribute("name");
            filtered_in = this.isFilteredIn(filter, value = filters[i].getAttribute("value"));
            if (!filtered_in) {
                parent.getParentNode().removeChild(parent);
                break;
            }
            ++i;
        }
        return filtered_in;
    }

    public boolean isFilteredIn(String filter, String value) {
        boolean filtered_in = false;
        filtered_in = filter.equals("ws") ? UAContentFilterProcessor.filterByWS(value) : (filter.equals("os") ? UAContentFilterProcessor.filterByOS(value) : (filter.equals("arch") ? UAContentFilterProcessor.filterByARCH(value) : (filter.equals("product") ? UAContentFilterProcessor.filterByProduct(value) : (filter.equals("plugin") ? UAContentFilterProcessor.filterByPlugin(value) : UAContentFilterProcessor.filterBySystemProperty(filter, value)))));
        return filtered_in;
    }

    public boolean isFilteredIn(FilterableUAElement element) {
        Map filters;
        if (element != null && (filters = element.getFilters()) != null) {
            Iterator iter = filters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (this.isFilteredIn((String)entry.getKey(), (String)entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMultiValue(String filterName) {
        return !filterName.equals("os") && !filterName.equals("ws") && !filterName.equals("arch") && !filterName.equals("product");
    }

    private static boolean filterByWS(String ws) {
        String currentWS = Platform.getWS();
        return currentWS.equals(ws);
    }

    private static boolean filterByOS(String os) {
        String currentOS = Platform.getOS();
        return currentOS.equals(os);
    }

    private static boolean filterByARCH(String arch) {
        String currentArch = Platform.getOSArch();
        return currentArch.equals(arch);
    }

    private static boolean filterByProduct(String productId) {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return false;
        }
        String currentProductId = product.getId();
        return currentProductId.equals(productId);
    }

    private static boolean filterByPlugin(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        boolean bundleIsOK = UAContentFilterProcessor.checkBundleState(bundle);
        return bundleIsOK;
    }

    public static boolean checkBundleState(Bundle bundle) {
        return bundle != null && bundle.getState() != 1 && bundle.getState() != 2;
    }

    private static boolean filterBySystemProperty(String property, String value) {
        String currentValue = System.getProperty(property);
        return currentValue != null && currentValue.equals(value);
    }
}

