/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntWorkingDirectoryBlock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.jres.JREDescriptor;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;

public class AntJRETab
extends JavaJRETab {
    private static final String MAIN_TYPE_NAME = "org.eclipse.ant.internal.ui.antsupport.InternalAntRunner";
    private VMArgumentsBlock fVMArgumentsBlock = new VMArgumentsBlock();
    private AntWorkingDirectoryBlock fWorkingDirectoryBlock = new AntWorkingDirectoryBlock();

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "ant_jre_tab_context");
        Composite comp = (Composite)this.fJREBlock.getControl();
        ((GridData)comp.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)comp.getLayoutData()).verticalAlignment = 4;
        this.fVMArgumentsBlock.createControl(comp);
        ((GridData)this.fVMArgumentsBlock.getControl().getLayoutData()).horizontalSpan = 2;
        this.fWorkingDirectoryBlock.createControl(comp);
        ((GridData)this.fWorkingDirectoryBlock.getControl().getLayoutData()).horizontalSpan = 2;
    }

    protected JREDescriptor getDefaultJREDescriptor() {
        return new JREDescriptor(){

            public String getDescription() {
                return AntLaunchConfigurationMessages.AntJRETab_2;
            }
        };
    }

    protected JREDescriptor getSpecificJREDescriptor() {
        return new JREDescriptor(){

            public String getDescription() {
                return AntLaunchConfigurationMessages.AntJRETab_3;
            }
        };
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fWorkingDirectoryBlock.setEnabled(!this.fJREBlock.isDefaultJRE());
        this.fVMArgumentsBlock.setEnabled(!this.fJREBlock.isDefaultJRE());
        if (this.fJREBlock.isDefaultJRE()) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
            configuration.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false);
        } else {
            super.performApply(configuration);
            if (this.useDefaultSeparateJRE(configuration)) {
                configuration.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", true);
            } else {
                configuration.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false);
            }
            this.applySeparateVMAttributes(configuration);
            this.fVMArgumentsBlock.performApply(configuration);
            this.fWorkingDirectoryBlock.performApply(configuration);
        }
        this.setLaunchConfigurationWorkingCopy(configuration);
    }

    private boolean useDefaultSeparateJRE(ILaunchConfigurationWorkingCopy configuration) {
        IVMInstall defaultVMInstall;
        boolean deflt = false;
        String vmInstallType = null;
        try {
            vmInstallType = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
        }
        catch (CoreException coreException) {}
        if (vmInstallType != null) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
        }
        if ((defaultVMInstall = this.getDefaultVMInstall((ILaunchConfiguration)configuration)) != null) {
            IVMInstall vm = this.fJREBlock.getJRE();
            deflt = defaultVMInstall.equals(vm);
        }
        if (vmInstallType != null) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmInstallType);
        }
        return deflt;
    }

    private void applySeparateVMAttributes(ILaunchConfigurationWorkingCopy configuration) {
        boolean userLogger;
        block6: {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, MAIN_TYPE_NAME);
            userLogger = false;
            try {
                String[] arguments = ExternalToolsUtil.getArguments((ILaunchConfiguration)configuration);
                if (arguments == null) break block6;
                int i = 0;
                while (i < arguments.length) {
                    String arg = arguments[i];
                    if (arg.equals("-logger")) {
                        userLogger = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        if (userLogger) {
            configuration.setAttribute("process_factory_id", null);
        } else {
            configuration.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean isDefaultVMInstall = configuration.getAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false);
            if (isDefaultVMInstall) {
                ILaunchConfigurationWorkingCopy copy;
                boolean needsSaving = false;
                if (configuration instanceof ILaunchConfigurationWorkingCopy) {
                    copy = (ILaunchConfigurationWorkingCopy)configuration;
                } else {
                    copy = configuration.getWorkingCopy();
                    needsSaving = true;
                }
                copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
                IVMInstall defaultVMInstall = this.getDefaultVMInstall((ILaunchConfiguration)copy);
                if (defaultVMInstall != null) {
                    this.setDefaultVMInstallAttributes(defaultVMInstall, copy);
                }
                if (needsSaving) {
                    configuration = copy.doSave();
                }
            }
        }
        catch (CoreException ce) {
            AntUIPlugin.log(ce);
        }
        super.initializeFrom(configuration);
        this.fVMArgumentsBlock.initializeFrom(configuration);
        this.fWorkingDirectoryBlock.initializeFrom(configuration);
        boolean separateVM = !this.fJREBlock.isDefaultJRE();
        this.fWorkingDirectoryBlock.setEnabled(separateVM);
        this.fVMArgumentsBlock.setEnabled(separateVM);
    }

    public boolean isValid(ILaunchConfiguration config) {
        return super.isValid(config) && this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
        this.fVMArgumentsBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.setLaunchConfigurationWorkingCopy(workingCopy);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        IVMInstall defaultVMInstall = this.getDefaultVMInstall((ILaunchConfiguration)config);
        if (defaultVMInstall != null) {
            config.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", true);
            this.setDefaultVMInstallAttributes(defaultVMInstall, config);
            this.applySeparateVMAttributes(config);
        }
    }

    private IVMInstall getDefaultVMInstall(ILaunchConfiguration config) {
        IVMInstall defaultVMInstall;
        try {
            defaultVMInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
        }
        catch (CoreException coreException) {
            defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        }
        return defaultVMInstall;
    }

    private void setDefaultVMInstallAttributes(IVMInstall defaultVMInstall, ILaunchConfigurationWorkingCopy config) {
        String vmName = defaultVMInstall.getName();
        String vmTypeID = defaultVMInstall.getVMInstallType().getId();
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmName);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmTypeID);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

