/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.IHeader;
import org.eclipse.pde.internal.core.builders.JarManifestErrorReporter;
import org.eclipse.pde.internal.core.search.PluginJavaSearchUtil;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class BundleErrorReporter
extends JarManifestErrorReporter {
    IPluginModelBase fModel;
    private static final String COMPATIBILITY_PLUGIN = "org.eclipse.core.runtime.compatibility";
    private static final String COMPATIBILITY_ACTIVATOR = "org.eclipse.core.internal.compatibility.PluginActivator";
    private boolean fEclipse3_1;
    private boolean fHasExtensibleApi = false;
    private boolean fFragment;
    private Map fFragmentsPackagesMap = null;
    private Map fHostPackagesMap = null;
    private boolean fHasFragment_Xml;
    private boolean fHasExtensions;
    private String fHostBundleId;
    private String fPluginId = "";
    private Map fProjectPackagesMap = null;
    private boolean fCompatibility = false;
    private boolean fCompatibilityActivator = false;

    protected static IStatus validateVersionString(String versionString) {
        if (versionString == null) {
            return Status.OK_STATUS;
        }
        return PluginVersionIdentifier.validateVersion((String)versionString);
    }

    protected static IStatus validateVersionRange(String versionRangeString) {
        try {
            new VersionRange(versionRangeString);
        }
        catch (IllegalArgumentException e) {
            return new Status(4, "org.eclipse.pde.core", 4, PDECoreMessages.BundleErrorReporter_invalidVersionRangeFormat, (Throwable)e);
        }
        int comma = versionRangeString.indexOf(44);
        if (comma < 0) {
            return BundleErrorReporter.validateVersionString(versionRangeString);
        }
        IStatus status = BundleErrorReporter.validateVersionString(versionRangeString.substring(1, comma));
        if (!status.isOK()) {
            return status;
        }
        return BundleErrorReporter.validateVersionString(versionRangeString.substring(comma + 1, versionRangeString.length() - 1));
    }

    public BundleErrorReporter(IFile file) {
        super(file);
    }

    private void addProjectPackages(Map map, IProject proj) {
        try {
            if (!proj.hasNature("org.eclipse.jdt.core.javanature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            return;
        }
        IJavaProject jp = JavaCore.create((IProject)proj);
        try {
            IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1 || roots[i].getKind() == 2 && !roots[i].isExternal()) {
                    IJavaElement[] children = roots[i].getChildren();
                    int j = 0;
                    while (j < children.length) {
                        IPackageFragment f = (IPackageFragment)children[j];
                        String name = f.getElementName();
                        if (name.equals("")) {
                            name = ".";
                        }
                        if (f.hasChildren() || f.getNonJavaResources().length > 0) {
                            map.put(name, f);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private HashMap getAvailableBundles() {
        HashMap<String, IPluginModelBase> map = new HashMap<String, IPluginModelBase>();
        IPluginModelBase[] plugins = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < plugins.length) {
            IPluginBase element = plugins[i].getPluginBase();
            if (element.getId() != null && !element.getId().equals(this.fPluginId)) {
                map.put(element.getId(), plugins[i]);
            }
            ++i;
        }
        if (map.containsKey("org.eclipse.osgi")) {
            map.put("system.bundle", (IPluginModelBase)map.get("org.eclipse.osgi"));
        }
        return map;
    }

    private HashMap getAvailableExportedPackages() {
        IPluginModelBase[] plugins = PDECore.getDefault().getModelManager().getPlugins();
        HashMap<String, ExportPackageDescription> map = new HashMap<String, ExportPackageDescription>();
        int i = 0;
        while (i < plugins.length) {
            ExportPackageDescription[] elements;
            BundleDescription bd;
            if (plugins[i].getPluginBase().getId() != null && (bd = plugins[i].getBundleDescription()) != null && (elements = bd.getExportPackages()) != null) {
                int j = 0;
                while (j < elements.length) {
                    map.put(elements[j].getName(), elements[j]);
                    ++j;
                }
            }
            ++i;
        }
        return map;
    }

    private Map getFragmentsPackages() {
        if (this.fFragmentsPackagesMap == null) {
            HashMap map = new HashMap();
            IFragmentModel[] models = PDECore.getDefault().getModelManager().getFragments();
            int i = 0;
            while (i < models.length) {
                IResource resource;
                String hostId = models[i].getFragment().getPluginId();
                if (this.fPluginId.equals(hostId) && (resource = models[i].getUnderlyingResource()) != null) {
                    this.addProjectPackages(map, resource.getProject());
                }
                ++i;
            }
            this.fFragmentsPackagesMap = map;
        }
        return this.fFragmentsPackagesMap;
    }

    private Map getHostPackages() {
        if (this.fHostPackagesMap == null) {
            HashMap<String, IPackageFragment> map = new HashMap<String, IPackageFragment>();
            if (this.fHostBundleId != null) {
                IPluginModel model = PDECore.getDefault().getModelManager().findPluginModel(this.fHostBundleId);
                if (model == null) {
                    return map;
                }
                IResource resource = model.getUnderlyingResource();
                if (resource != null) {
                    this.addProjectPackages(map, resource.getProject());
                } else {
                    try {
                        if (this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                            IPackageFragment[] packages = PluginJavaSearchUtil.collectPackageFragments(new IPluginBase[]{model.getPluginBase()}, JavaCore.create((IProject)this.fProject), false);
                            int i = 0;
                            while (i < packages.length) {
                                map.put(packages[i].getElementName(), packages[i]);
                                ++i;
                            }
                        }
                    }
                    catch (JavaModelException jme) {
                        PDECore.log(jme);
                    }
                    catch (CoreException coreException) {}
                }
            }
            this.fHostPackagesMap = map;
        }
        return this.fHostPackagesMap;
    }

    private int getPackageLine(IHeader header, ManifestElement element) {
        String packageName = element.getValue();
        if (element.getDirectiveKeys() != null || element.getKeys() != null) {
            return this.getLine(header, String.valueOf(packageName) + ";");
        }
        try {
            IRegion lineRegion = this.fTextDocument.getLineInformation(header.getLineNumber() + header.getLinesSpan() - 1);
            String lineStr = this.fTextDocument.get(lineRegion.getOffset(), lineRegion.getLength());
            if (lineStr.endsWith(packageName)) {
                return header.getLineNumber() + header.getLinesSpan();
            }
        }
        catch (BadLocationException ble) {
            PDECore.logException(ble);
        }
        return this.getLine(header, String.valueOf(packageName) + ",");
    }

    private Map getProjectPackages() {
        if (this.fProjectPackagesMap == null) {
            HashMap map = new HashMap();
            this.addProjectPackages(map, this.fProject);
            this.fProjectPackagesMap = map;
        }
        return this.fProjectPackagesMap;
    }

    protected boolean isCheckDeprecated() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated") != 2;
    }

    protected boolean isCheckNoRequiredAttr() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.no-required-att") != 2;
    }

    protected boolean isCheckUnknownClass() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-class") != 2;
    }

    protected boolean isCheckUnresolvedImports() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.unresolved-import") != 2;
    }

    private void readBundleManifestVersion() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-ManifestVersion");
        if (header == null) {
            return;
        }
        try {
            Version v = new Version(header.getValue());
            if (v.getMajor() >= 2) {
                this.fEclipse3_1 = true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void validateBundleActivator() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-Activator");
        if (header == null) {
            return;
        }
        String activator = header.getValue();
        this.fCompatibilityActivator = COMPATIBILITY_ACTIVATOR.equals(activator);
        if (this.fFragment) {
            String message = PDECoreMessages.BundleErrorReporter_fragmentActivator;
            this.report(message, header.getLineNumber() + 1, 0);
            return;
        }
        if (this.isCheckUnknownClass()) {
            try {
                if (!this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                    return;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
            try {
                if (activator.indexOf(36) != -1) {
                    activator = activator.replace('$', '.');
                }
                IType type = javaProject.findType(activator);
                if (!this.fCompatibilityActivator) {
                    if (type == null || !type.exists()) {
                        String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NoExist, (Object)activator);
                        this.report(message, this.getLine(header, activator), "compilers.p.unknown-class");
                        return;
                    }
                    IPackageFragmentRoot pfroot = (IPackageFragmentRoot)type.getAncestor(3);
                    if (pfroot != null && pfroot.isExternal()) {
                        String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_externalClass, (Object)activator);
                        this.report(message, this.getLine(header, activator), "compilers.p.unknown-class");
                        return;
                    }
                } else if (!this.fCompatibility) {
                    String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_unresolvedCompatibilityActivator, (Object)activator);
                    this.report(message, this.getLine(header, activator), "compilers.p.unknown-class");
                    return;
                }
            }
            catch (JavaModelException e) {
                PDECore.logException(e);
            }
        }
    }

    private void validatePluginClass() {
        String message;
        IHeader header = (IHeader)this.fHeaders.get("Plugin-Class");
        if (header == null) {
            return;
        }
        String pluginClass = header.getValue();
        if (this.fFragment) {
            String message2 = PDECoreMessages.BundleErrorReporter_fragmentActivator;
            this.report(message2, header.getLineNumber() + 1, 0);
            return;
        }
        if (!this.fCompatibilityActivator && !this.fCompatibility) {
            message = PDECoreMessages.BundleErrorReporter_unusedPluginClass;
            this.report(message, header.getLineNumber() + 1, 1);
        }
        if (this.isCheckUnknownClass()) {
            try {
                if (!this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                    return;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
            try {
                IType type;
                if (pluginClass.indexOf(36) != -1) {
                    pluginClass = pluginClass.replace('$', '.');
                }
                if ((type = javaProject.findType(pluginClass)) == null || !type.exists()) {
                    message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NoExist, (Object)pluginClass);
                    this.report(message, this.getLine(header, pluginClass), "compilers.p.unknown-class");
                    return;
                }
                IPackageFragmentRoot pfroot = (IPackageFragmentRoot)type.getAncestor(3);
                if (pfroot != null && pfroot.isExternal()) {
                    message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_externalClass, (Object)pluginClass);
                    this.report(message, this.getLine(header, pluginClass), "compilers.p.unknown-class");
                    return;
                }
            }
            catch (JavaModelException e) {
                PDECore.logException(e);
            }
        }
    }

    private void validateBundleClasspath() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-ClassPath");
        if (header == null) {
            return;
        }
        String classpath = header.getValue();
        String message = null;
        if (classpath.trim().length() == 0) {
            message = PDECoreMessages.BundleErrorReporter_ClasspathNotEmpty;
            this.report(message, header.getLineNumber() + 1, 0);
            return;
        }
        ManifestElement[] elements = header.getElements();
        if (elements.length == 0) {
            return;
        }
    }

    private void validateBundleName() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-Name");
        if (header == null) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_headerMissing, (Object)"Bundle-Name"), 1, 0);
            return;
        }
        this.validateTranslatableString(header, true);
    }

    private boolean validateBundleSymbolicName() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-SymbolicName");
        if (header == null) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_headerMissing, (Object)"Bundle-SymbolicName"), 1, 0);
            return false;
        }
        String symbolicName = header.getValue();
        if (symbolicName.trim().length() == 0) {
            String message = PDECoreMessages.BundleErrorReporter_NoSymbolicName;
            this.report(message, header.getLineNumber() + 1, 0);
            return false;
        }
        ManifestElement[] elements = header.getElements();
        if (elements.length == 0) {
            return false;
        }
        this.fPluginId = elements[0].getValue();
        this.validatePluginId(header, this.fPluginId);
        this.validateSingletonAttribute(header, elements[0]);
        this.validateSingletonDirective(header, elements[0]);
        return true;
    }

    private void validateBundleVendor() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-Vendor");
        if (header == null) {
            return;
        }
        this.validateTranslatableString(header, true);
    }

    private void validateBundleVersion() {
        IHeader header = (IHeader)this.fHeaders.get("Bundle-Version");
        if (header == null) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_headerMissing, (Object)"Bundle-Version"), 1, 0);
            return;
        }
        String version = header.getValue();
        IStatus status = BundleErrorReporter.validateVersionString(version);
        if (!status.isOK()) {
            int line = this.getLine(header, version);
            this.report(status.getMessage(), line, 0);
        }
    }

    private void validateBundleVersionAttribute(IHeader header, ManifestElement element) {
        String versionRange = element.getAttribute("bundle-version");
        if (versionRange != null && !BundleErrorReporter.validateVersionRange(versionRange).isOK()) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_InvalidFormatInBundleVersion, (Object)element.getValue());
            this.report(message, this.getPackageLine(header, element), 0);
        }
    }

    public void validateContent(IProgressMonitor monitor) {
        super.validateContent(monitor);
        if (this.fHeaders == null || this.getErrorCount() > 0) {
            return;
        }
        this.readBundleManifestVersion();
        this.fHasFragment_Xml = this.fProject.getFile("fragment.xml").exists();
        this.fModel = PDECore.getDefault().getModelManager().findModel(this.fProject);
        if (this.fModel != null) {
            boolean bl = this.fHasExtensions = this.fModel.getPluginBase().getExtensionPoints().length > 0 || this.fModel.getPluginBase().getExtensions().length > 0;
        }
        if (!this.validateBundleSymbolicName()) {
            return;
        }
        this.validateBundleName();
        this.validateBundleVendor();
        this.validateBundleVersion();
        this.validateExtensibleAPI();
        this.validateFragmentHost();
        this.validateBundleClasspath();
        this.validateRequireBundle(monitor);
        this.validateBundleActivator();
        this.validatePluginClass();
        this.validateExportPackage(monitor);
        this.validateProvidePackage(monitor);
        this.validateImportPackage(monitor);
        this.validateEclipsePlatformFilter();
        this.validateAutoStart();
        this.validateLazyStart();
    }

    private void validateExportPackage(IProgressMonitor monitor) {
        IHeader header = (IHeader)this.fHeaders.get("Export-Package");
        if (header == null) {
            return;
        }
        String message = null;
        ManifestElement[] exportPackageElements = header.getElements();
        int i = 0;
        while (i < exportPackageElements.length) {
            this.checkCanceled(monitor);
            String exportPackageStmt = exportPackageElements[i].getValue();
            if (!".".equals(exportPackageStmt.trim())) {
                this.validateVersionAttribute(header, exportPackageElements[i], false);
                this.validateSpecificationVersionAttribute(header, exportPackageElements[i]);
                this.validateX_InternalDirective(header, exportPackageElements[i]);
                this.validateX_FriendsDirective(header, exportPackageElements[i]);
                if (this.isCheckUnresolvedImports()) {
                    IHeader jreHeader;
                    IPackageFragment f = (IPackageFragment)this.getProjectPackages().get(exportPackageStmt);
                    if (f != null && f.isDefaultPackage()) {
                        message = PDECoreMessages.BundleErrorReporter_CannotExportDefaultPackage;
                        this.report(message, this.getPackageLine(header, exportPackageElements[i]), "compilers.p.unresolved-import");
                    } else if (!(this.getProjectPackages().containsKey(exportPackageStmt) || this.getHostPackages().containsKey(exportPackageStmt) || this.fHasExtensibleApi && this.getFragmentsPackages().containsKey(exportPackageStmt))) {
                        message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistInProject, (Object)exportPackageStmt);
                        IMarker marker = this.report(message, this.getPackageLine(header, exportPackageElements[i]), "compilers.p.unresolved-import", 6);
                        try {
                            if (marker != null) {
                                marker.setAttribute("packageName", (Object)exportPackageStmt);
                            }
                        }
                        catch (CoreException coreException) {}
                    } else if (!(!exportPackageStmt.equals("java") && !exportPackageStmt.startsWith("java.") || (jreHeader = (IHeader)this.fHeaders.get("Eclipse-JREBundle")) != null && "true".equals(jreHeader.getValue()))) {
                        message = PDECoreMessages.BundleErrorReporter_exportNoJRE;
                        this.report(message, this.getPackageLine(header, exportPackageElements[i]), 0, 2);
                    }
                }
            }
            ++i;
        }
    }

    private void validateExtensibleAPI() {
        IHeader header = (IHeader)this.fHeaders.get("Eclipse-ExtensibleAPI");
        if (header == null) {
            return;
        }
        this.validateBooleanValue(header);
        this.fHasExtensibleApi = "true".equals(header.getValue());
    }

    private void validateFragmentHost() {
        IHeader header = (IHeader)this.fHeaders.get("Fragment-Host");
        if (header == null) {
            if (this.isCheckNoRequiredAttr() && this.fHasFragment_Xml) {
                String message = PDECoreMessages.BundleErrorReporter_HostNeeded;
                this.report(message, 1, "compilers.p.no-required-att");
            }
            return;
        }
        this.fFragment = true;
        ManifestElement[] fragmentHostElements = header.getElements();
        if (this.isCheckNoRequiredAttr() && fragmentHostElements.length == 0) {
            String message = PDECoreMessages.BundleErrorReporter_HostNeeded;
            this.report(message, 1, "compilers.p.no-required-att");
            return;
        }
        String fragmentHostStmt = fragmentHostElements[0].getValue();
        if (!this.validatePluginId(header, fragmentHostStmt)) {
            return;
        }
        this.validateBundleVersionAttribute(header, fragmentHostElements[0]);
        if (this.isCheckUnresolvedImports()) {
            VersionRange versionRange;
            HashMap availableBundlesMap = this.getAvailableBundles();
            IPluginModelBase availableModel = (IPluginModelBase)availableBundlesMap.get(fragmentHostStmt);
            if (availableModel == null || !availableModel.isEnabled()) {
                String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_HostNotExistPDE, (Object)fragmentHostStmt);
                this.report(message, this.getLine(header, fragmentHostStmt), "compilers.p.unresolved-import");
                return;
            }
            if (availableModel instanceof IFragmentModel) {
                String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_HostIsFragment, (Object)fragmentHostStmt);
                this.report(message, this.getLine(header, fragmentHostStmt), "compilers.p.unresolved-import");
                return;
            }
            String availableVersion = availableModel.getPluginBase().getVersion();
            String requiredVersionRange = fragmentHostElements[0].getAttribute("bundle-version");
            if (requiredVersionRange != null && BundleErrorReporter.validateVersionRange(requiredVersionRange).isOK() && !(versionRange = new VersionRange(requiredVersionRange)).isIncluded(new Version(availableVersion))) {
                String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_BundleRangeInvalidInBundleVersion, (Object)fragmentHostStmt);
                this.report(message, this.getLine(header, requiredVersionRange), "compilers.p.unresolved-import");
            }
            this.fHostBundleId = fragmentHostStmt;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validateImportPackage(IProgressMonitor monitor) {
        header = (IHeader)this.fHeaders.get("Import-Package");
        if (header == null) {
            return;
        }
        message = null;
        availableExportedPackagesMap = this.getAvailableExportedPackages();
        importPackageElements = header.getElements();
        i = 0;
        while (i < importPackageElements.length) {
            block9: {
                block10: {
                    this.checkCanceled(monitor);
                    this.validateSpecificationVersionAttribute(header, importPackageElements[i]);
                    this.validateVersionAttribute(header, importPackageElements[i], true);
                    this.validateResolutionDirective(header, importPackageElements[i]);
                    importPackageStmt = importPackageElements[i].getValue();
                    if (!this.isCheckUnresolvedImports()) break block9;
                    optional = this.isOptional(importPackageElements[i]);
                    severity = this.getRequireBundleSeverity(importPackageElements[i], optional);
                    if (availableExportedPackagesMap.containsKey(importPackageStmt)) break block10;
                    message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_PackageNotExported, (Object)importPackageStmt);
                    marker = this.report(message, this.getPackageLine(header, importPackageElements[i]), severity, 7);
                    try {
                        if (marker != null) {
                            marker.setAttribute("packageName", (Object)importPackageStmt);
                        }
                        if (optional) {
                            marker.setAttribute("optional", true);
                        }
                    }
                    catch (CoreException v0) {}
                    break block9;
                }
                requiredVersion = importPackageElements[i].getAttribute("version");
                if (requiredVersion == null || !BundleErrorReporter.validateVersionRange(requiredVersion).isOK()) ** GOTO lbl-1000
                range = new VersionRange(requiredVersion);
                epd = (ExportPackageDescription)availableExportedPackagesMap.get(importPackageStmt);
                if (epd.getVersion() != null && !range.isIncluded(epd.getVersion())) {
                    message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_VersionNotInRange, (Object[])new String[]{importPackageStmt, requiredVersion});
                    this.report(message, this.getPackageLine(header, importPackageElements[i]), severity);
                } else if (!(!importPackageStmt.equals("java") && !importPackageStmt.startsWith("java.") || (jreHeader = (IHeader)this.fHeaders.get("Eclipse-JREBundle")) != null && "true".equals(jreHeader.getValue()))) {
                    message = PDECoreMessages.BundleErrorReporter_importNoJRE;
                    this.report(message, this.getPackageLine(header, importPackageElements[i]), 0, 2);
                }
            }
            ++i;
        }
    }

    private void validateOptionalAttribute(IHeader header, ManifestElement requireBundleElements) {
        String rexport = requireBundleElements.getAttribute("optional");
        if (rexport != null) {
            this.validateBooleanAttributeValue(header, requireBundleElements, "optional");
            if (this.fEclipse3_1 && this.isCheckDeprecated()) {
                String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_optional, (Object)"optional");
                this.report(message, this.getLine(header, "optional="), "compilers.p.deprecated");
            }
        }
    }

    private boolean validatePluginId(IHeader header, String value) {
        if (!IdUtil.isValidCompositeID(value)) {
            String message = PDECoreMessages.BundleErrorReporter_InvalidSymbolicName;
            this.report(message, header.getLineNumber() + 1, 1);
            return false;
        }
        return true;
    }

    private void validateProvidePackage(IProgressMonitor monitor) {
        IHeader header = (IHeader)this.fHeaders.get("Provide-Package");
        if (header == null) {
            return;
        }
        String message = null;
        if (this.fEclipse3_1 && this.isCheckDeprecated()) {
            message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_header_Provide_Package, (Object)"Provide-Package");
            this.report(message, header.getLineNumber() + 1, "compilers.p.deprecated");
        }
        ManifestElement[] exportPackageElements = header.getElements();
        int i = 0;
        while (i < exportPackageElements.length) {
            this.checkCanceled(monitor);
            String exportPackageStmt = exportPackageElements[i].getValue();
            if (!".".equals(exportPackageStmt.trim())) {
                this.validateSpecificationVersionAttribute(header, exportPackageElements[i]);
                if (this.isCheckUnresolvedImports()) {
                    IPackageFragment f = (IPackageFragment)this.getProjectPackages().get(exportPackageStmt);
                    if (f != null && f.isDefaultPackage()) {
                        message = PDECoreMessages.BundleErrorReporter_CannotExportDefaultPackage;
                        this.report(message, this.getPackageLine(header, exportPackageElements[i]), "compilers.p.unresolved-import");
                    } else if (!(this.getProjectPackages().containsKey(exportPackageStmt) || this.getHostPackages().containsKey(exportPackageStmt) || this.fHasExtensibleApi && this.getFragmentsPackages().containsKey(exportPackageStmt))) {
                        message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistInProject, (Object)exportPackageStmt);
                        this.report(message, this.getPackageLine(header, exportPackageElements[i]), "compilers.p.unresolved-import");
                    }
                }
            }
            ++i;
        }
    }

    private void validateReprovideAttribute(IHeader header, ManifestElement requireBundleElements) {
        String rexport = requireBundleElements.getAttribute("reprovide");
        if (rexport != null) {
            this.validateBooleanAttributeValue(header, requireBundleElements, "reprovide");
            if (this.fEclipse3_1 && this.isCheckDeprecated()) {
                String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_reprovide, (Object)"reprovide");
                this.report(message, this.getLine(header, "reprovide="), "compilers.p.deprecated");
            }
        }
    }

    private void validateRequireBundle(IProgressMonitor monitor) {
        IHeader header = (IHeader)this.fHeaders.get("Require-Bundle");
        if (header == null) {
            return;
        }
        String message = null;
        HashMap availableBundlesMap = this.getAvailableBundles();
        ManifestElement[] requireBundleElements = header.getElements();
        int i = 0;
        while (i < requireBundleElements.length) {
            this.checkCanceled(monitor);
            String requireBundleStmt = requireBundleElements[i].getValue();
            if (COMPATIBILITY_PLUGIN.equals(requireBundleStmt)) {
                this.fCompatibility = true;
            }
            this.validateBundleVersionAttribute(header, requireBundleElements[i]);
            this.validateVisibilityDirective(header, requireBundleElements[i]);
            this.validateReprovideAttribute(header, requireBundleElements[i]);
            this.validateResolutionDirective(header, requireBundleElements[i]);
            this.validateOptionalAttribute(header, requireBundleElements[i]);
            if (!this.isCheckUnresolvedImports()) {
                return;
            }
            boolean optional = this.isOptional(requireBundleElements[i]);
            int severity = this.getRequireBundleSeverity(requireBundleElements[i], optional);
            if (!availableBundlesMap.containsKey(requireBundleStmt)) {
                message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistPDE, (Object)requireBundleStmt);
                IMarker marker = this.report(message, this.getPackageLine(header, requireBundleElements[i]), severity, 8);
                try {
                    if (marker != null) {
                        marker.setAttribute("bundleId", (Object)requireBundleElements[i].getValue());
                    }
                    if (optional) {
                        marker.setAttribute("optional", true);
                    }
                }
                catch (CoreException coreException) {}
            } else {
                IPluginModelBase availableModel = (IPluginModelBase)availableBundlesMap.get(requireBundleStmt);
                if (!(availableModel instanceof IPluginModel)) {
                    message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_IsFragment, (Object)requireBundleStmt);
                    this.report(message, this.getPackageLine(header, requireBundleElements[i]), severity);
                } else {
                    String availableVersion;
                    VersionRange versionRange;
                    String requiredVersionRange = requireBundleElements[i].getAttribute("bundle-version");
                    if (requiredVersionRange != null && BundleErrorReporter.validateVersionRange(requiredVersionRange).isOK() && !(versionRange = new VersionRange(requiredVersionRange)).isIncluded(new Version(availableVersion = availableModel.getPluginBase().getVersion()))) {
                        message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_BundleRangeInvalidInBundleVersion, (Object)requireBundleStmt);
                        this.report(message, this.getPackageLine(header, requireBundleElements[i]), severity);
                    }
                }
            }
            ++i;
        }
    }

    private boolean isOptional(ManifestElement element) {
        return "optional".equals(element.getDirective("resolution")) || "true".equals(element.getAttribute("optional"));
    }

    private int getRequireBundleSeverity(ManifestElement requireBundleElement, boolean optional) {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unresolved-import");
        if (optional && severity != 2) {
            ++severity;
        }
        return severity;
    }

    private void validateResolutionDirective(IHeader header, ManifestElement requireBundleElement) {
        String resolution = requireBundleElement.getDirective("resolution");
        if (resolution != null) {
            this.validateDirectiveValue(header, requireBundleElement, "resolution", new String[]{"mandatory", "optional"});
        }
    }

    private void validateSingletonAttribute(IHeader header, ManifestElement element) {
        String singletonAttr = element.getAttribute("singleton");
        if (this.fHasExtensions && !this.fEclipse3_1 && !"true".equals(singletonAttr)) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_singletonAttrRequired, (Object)"singleton");
            this.report(message, header.getLineNumber() + 1, 0, 4);
        } else if (this.isCheckDeprecated() && this.fEclipse3_1 && singletonAttr != null) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_singleton, (Object)"singleton");
            this.report(message, this.getLine(header, "singleton="), "compilers.p.deprecated", 3);
        } else {
            this.validateBooleanAttributeValue(header, element, "singleton");
        }
    }

    private void validateSingletonDirective(IHeader header, ManifestElement element) {
        String singletonDir = element.getDirective("singleton");
        if (this.fHasExtensions && this.fEclipse3_1 && !"true".equals(singletonDir)) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_singletonRequired, (Object)"singleton");
            this.report(message, header.getLineNumber() + 1, 0, 3);
        } else {
            this.validateBooleanDirectiveValue(header, element, "singleton");
        }
    }

    private void validateSpecificationVersionAttribute(IHeader header, ManifestElement element) {
        String version = element.getAttribute("specification-version");
        IStatus status = BundleErrorReporter.validateVersionString(version);
        if (!status.isOK()) {
            this.report(status.getMessage(), this.getPackageLine(header, element), 0);
        }
        if (this.isCheckDeprecated() && this.fEclipse3_1 && version != null) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_specification_version, (Object)"specification-version");
            this.report(message, this.getPackageLine(header, element), "compilers.p.deprecated");
        }
    }

    private void validateVersionAttribute(IHeader header, ManifestElement element, boolean range) {
        IStatus status;
        String version = element.getAttribute("version");
        if (version == null) {
            return;
        }
        IStatus iStatus = status = range ? BundleErrorReporter.validateVersionRange(version) : BundleErrorReporter.validateVersionString(version);
        if (!status.isOK()) {
            this.report(status.getMessage(), this.getPackageLine(header, element), 0);
        }
    }

    private void validateVisibilityDirective(IHeader header, ManifestElement requireBundleElement) {
        String visibility = requireBundleElement.getDirective("visibility");
        if (visibility != null) {
            this.validateDirectiveValue(header, requireBundleElement, "visibility", new String[]{"private", "reexport"});
        }
    }

    private void validateX_InternalDirective(IHeader header, ManifestElement element) {
        String internal = element.getDirective("x-internal");
        if (internal == null) {
            return;
        }
        int i = 0;
        while (i < BOOLEAN_VALUES.length) {
            if (BOOLEAN_VALUES[i].equals(internal)) {
                return;
            }
            ++i;
        }
        String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_dir_value, (Object[])new String[]{internal, "x-internal"});
        this.report(message, this.getPackageLine(header, element), 0);
    }

    private void validateX_FriendsDirective(IHeader header, ManifestElement element) {
        String friends = element.getDirective("x-friends");
        String internal = element.getDirective("x-internal");
        if (friends != null && internal != null) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_directive_hasNoEffectWith_, (Object[])new String[]{"x-friends", "x-internal"});
            this.report(message, this.getPackageLine(header, element), 1);
        }
    }

    private void validateEclipsePlatformFilter() {
        IHeader header = (IHeader)this.fHeaders.get("Eclipse-PlatformFilter");
        if (header == null) {
            return;
        }
        String filter = header.getValue();
        try {
            PDECore.getDefault().getBundleContext().createFilter(filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            this.report(PDECoreMessages.BundleErrorReporter_invalidFilterSyntax, header.getLineNumber() + 1, 0);
        }
    }

    protected void validateTranslatableString(IHeader header, boolean shouldTranslate) {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.not-externalized-att");
        if (severity == 2) {
            return;
        }
        String value = header.getValue();
        if (shouldTranslate) {
            NLResourceHelper helper;
            if (!value.startsWith("%")) {
                this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_non_ext_attribute, (Object)header.getName()), this.getLine(header, value), severity);
            } else if (this.fModel instanceof AbstractModel && ((helper = ((AbstractModel)((Object)this.fModel)).getNLResourceHelper()) == null || !helper.resourceExists(value))) {
                this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_key_not_found, (Object)value.substring(1)), this.getLine(header, value), severity);
            }
        }
    }

    private void validateAutoStart() {
        IHeader header = (IHeader)this.fHeaders.get("Eclipse-AutoStart");
        if (!this.isValidStartHeader(header)) {
            return;
        }
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
        if (severity == 2) {
            return;
        }
        if (TargetPlatform.getTargetVersion() >= 3.2) {
            int line = header.getLineNumber();
            header = (IHeader)this.fHeaders.get("Bundle-ManifestVersion");
            if (header != null && header.getValue().equals("2")) {
                this.report(PDECoreMessages.BundleErrorReporter_startHeader_autoStartDeprecated, line + 1, severity, 1);
            }
        }
    }

    private void validateLazyStart() {
        IHeader header = (IHeader)this.fHeaders.get("Eclipse-LazyStart");
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
        if (header != null && TargetPlatform.getTargetVersion() < 3.2 && severity != 2) {
            this.report(PDECoreMessages.BundleErrorReporter_lazyStart_unsupported, header.getLineNumber() + 1, severity, -1);
        } else {
            this.isValidStartHeader(header);
        }
    }

    private boolean isValidStartHeader(IHeader header) {
        if (header == null) {
            return false;
        }
        ManifestElement[] elements = header.getElements();
        return this.startHeaderElementsValid(header, elements) && this.exceptionsAttributesValid(header, elements);
    }

    private boolean startHeaderElementsValid(IHeader header, ManifestElement[] elements) {
        if (elements == null || elements.length == 0) {
            return true;
        }
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-element");
        if (severity == 2) {
            return true;
        }
        if (elements.length > 1) {
            this.report(String.valueOf(header.getName()) + PDECoreMessages.BundleErrorReporter_startHeader_tooManyElements, header.getLineNumber() + 1, severity);
            return false;
        }
        String[] values = elements[0].getValueComponents();
        if (values == null || values.length > 1 || !values[0].equals(Boolean.toString(true)) && !values[0].equals(Boolean.toString(false))) {
            this.report(String.valueOf(header.getName()) + PDECoreMessages.BundleErrorReporter_startHeader_illegalValue, header.getLineNumber() + 1, severity);
            return false;
        }
        return true;
    }

    private boolean exceptionsAttributesValid(IHeader header, ManifestElement[] elements) {
        String key;
        if (elements == null || elements.length == 0) {
            return true;
        }
        int unknwnAttSev = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-attribute");
        if (unknwnAttSev == 2) {
            return true;
        }
        Enumeration keys = elements[0].getKeys();
        if (keys != null && keys.hasMoreElements() && "exceptions".equals(key = (String)keys.nextElement())) {
            String[] values = elements[0].getAttributes(key);
            int i = 0;
            while (i < values.length) {
                StringTokenizer st = new StringTokenizer(values[i], ",");
                while (st.hasMoreTokens()) {
                    if (this.packageExists(header, st.nextToken().trim())) continue;
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean packageExists(IHeader header, String exportPackageStmt) {
        if (!(this.getProjectPackages().containsKey(exportPackageStmt) || this.getHostPackages().containsKey(exportPackageStmt) || this.fHasExtensibleApi && this.getFragmentsPackages().containsKey(exportPackageStmt))) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistInProject, (Object)exportPackageStmt);
            this.report(message, header.getLineNumber() + 1, "compilers.p.unresolved-import");
            return false;
        }
        return true;
    }
}

