/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.FactoryConfigurationError;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class CoreUtility {
    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            fos = null;
            in.close();
            in = null;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
    }

    public static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static boolean isInterestingExtensionPoint(String point) {
        return "org.eclipse.pde.core.source".equals(point) || "org.eclipse.core.runtime.products".equals(point) || "org.eclipse.pde.core.javadoc".equals(point) || "org.eclipse.ui.intro".equals(point);
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                CoreUtility.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    public static void createProject(IProject project, IPath location, IProgressMonitor monitor) throws CoreException {
        if (!Platform.getLocation().equals((Object)location)) {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation(location);
            project.create(desc, monitor);
        } else {
            project.create(monitor);
        }
    }

    public static String getWritableString(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String normalize(String text) {
        if (text == null || text.trim().length() == 0) {
            return "";
        }
        text = text.replaceAll("\\r|\\n|\\f|\\t", " ");
        return text.replaceAll("\\s+", " ");
    }

    public static void deleteContent(File curr) {
        if (curr.exists()) {
            File[] children;
            if (curr.isDirectory() && (children = curr.listFiles()) != null) {
                int i = 0;
                while (i < children.length) {
                    CoreUtility.deleteContent(children[i]);
                    ++i;
                }
            }
            curr.delete();
        }
    }

    public static boolean guessUnpack(BundleDescription bundle) {
        IPluginModelBase model;
        if (bundle == null) {
            return true;
        }
        if (new File(bundle.getLocation()).isFile()) {
            return false;
        }
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        IContainer container = root.getContainerForLocation((IPath)new Path(bundle.getLocation()));
        if (container == null) {
            return true;
        }
        if (container instanceof IProject) {
            try {
                if (!((IProject)container).hasNature("org.eclipse.jdt.core.javanature")) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        if ((model = PDECore.getDefault().getModelManager().findModel(bundle)) == null) {
            return true;
        }
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        if (libraries.length == 0) {
            return false;
        }
        int i = 0;
        while (i < libraries.length) {
            if (libraries[i].getName().equals(".")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jarContainsResource(File file, String resource, boolean directory) {
        ZipFile jarFile;
        block10: {
            boolean bl;
            jarFile = null;
            try {
                try {
                    jarFile = new ZipFile(file, 1);
                    ZipEntry resourceEntry = jarFile.getEntry(resource);
                    if (resourceEntry == null) break block10;
                    bl = directory ? resourceEntry.isDirectory() : true;
                    Object var5_6 = null;
                }
                catch (IOException iOException) {
                    break block10;
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (jarFile == null) throw throwable;
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (jarFile == null) return bl;
            jarFile.close();
            return bl;
        }
        Object var5_8 = null;
        try {}
        catch (IOException iOException) {
            return false;
        }
        if (jarFile == null) return false;
        jarFile.close();
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(IPath originPath, String name, File target) {
        File source = new File(originPath.toFile(), name);
        if (!source.exists()) {
            return;
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                is = new FileInputStream(source);
                os = new FileOutputStream(target);
                byte[] buf = new byte[1024];
                long currentLen = 0L;
                int len = is.read(buf);
                while (len != -1) {
                    currentLen += (long)len;
                    os.write(buf, 0, len);
                    len = is.read(buf);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_11 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (is != null) {
            is.close();
        }
        if (os == null) return;
        os.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document getTextDocument(File bundleLocation, String path) {
        ZipFile jarFile;
        block14: {
            Document document;
            jarFile = null;
            InputStream stream = null;
            try {
                try {
                    String extension = new Path(bundleLocation.getName()).getFileExtension();
                    if ("jar".equals(extension) && bundleLocation.isFile()) {
                        jarFile = new ZipFile(bundleLocation, 1);
                        ZipEntry manifestEntry = jarFile.getEntry(path);
                        if (manifestEntry != null) {
                            stream = jarFile.getInputStream(manifestEntry);
                        }
                    } else {
                        File file = new File(bundleLocation, path);
                        if (file.exists()) {
                            stream = new FileInputStream(file);
                        }
                    }
                    document = CoreUtility.getTextDocument(stream);
                    Object var6_8 = null;
                }
                catch (IOException iOException) {
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    if (jarFile == null) throw throwable;
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (jarFile == null) return document;
            jarFile.close();
            return document;
        }
        Object var6_10 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (jarFile == null) return null;
        jarFile.close();
        return null;
    }

    public static Document getTextDocument(InputStream in) {
        String result;
        block8: {
            ByteArrayOutputStream output = null;
            result = null;
            try {
                int count;
                output = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                    output.write(buffer, 0, count);
                }
                result = output.toString("UTF-8");
                output.close();
                output = null;
                in.close();
                in = null;
            }
            catch (IOException iOException) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (in == null) break block8;
                try {
                    in.close();
                }
                catch (IOException iOException3) {}
            }
        }
        return result == null ? null : new Document(result);
    }
}

