/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class JUnitLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(IEditorPart editor, String mode) {
        IJavaElement element = null;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.searchAndLaunch(new Object[]{element}, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    protected void searchAndLaunch(Object[] search, String mode) {
        try {
            if (search != null) {
                if (search.length == 0) {
                    MessageDialog.openInformation((Shell)JUnitPlugin.getActiveWorkbenchShell(), (String)JUnitMessages.LaunchTestAction_dialog_title, (String)JUnitMessages.LaunchTestAction_message_notests);
                    return;
                }
                if (search[0] instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)search[0];
                    if (element.getElementType() < 5) {
                        this.launchContainer(element, mode);
                        return;
                    }
                    if (element.getElementType() == 9) {
                        this.launchMethod((IMethod)element, mode);
                        return;
                    }
                }
                this.launchType(search, mode);
            }
        }
        catch (LaunchCancelledByUserException launchCancelledByUserException) {}
    }

    protected void launchType(Object[] search, String mode) {
        IType[] types = null;
        try {
            types = TestSearchEngine.findTests(search);
        }
        catch (InterruptedException e) {
            JUnitPlugin.log(e);
            return;
        }
        catch (InvocationTargetException e) {
            JUnitPlugin.log(e);
            return;
        }
        IType type = null;
        if (types.length == 0) {
            MessageDialog.openInformation((Shell)JUnitPlugin.getActiveWorkbenchShell(), (String)JUnitMessages.LaunchTestAction_dialog_title, (String)JUnitMessages.LaunchTestAction_message_notests);
        } else {
            type = types.length > 1 ? this.chooseType(types, mode) : types[0];
        }
        if (type != null) {
            try {
                this.launch(type, mode);
            }
            catch (LaunchCancelledByUserException launchCancelledByUserException) {}
        }
    }

    private void launchContainer(IJavaElement container, String mode) throws LaunchCancelledByUserException {
        String handleIdentifier = container.getHandleIdentifier();
        ILaunchConfiguration config = this.findLaunchConfiguration(mode, container, handleIdentifier, "", "");
        String name = JavaElementLabels.getTextLabel((Object)container, (long)JavaElementLabels.ALL_FULLY_QUALIFIED);
        name = name.substring(name.lastIndexOf(47) + 1);
        if (config == null) {
            config = this.createConfiguration(container.getJavaProject(), name, "", handleIdentifier, "");
        }
        this.launchConfiguration(mode, config);
    }

    private void launch(IType type, String mode) throws LaunchCancelledByUserException {
        String fullyQualifiedName = type.getFullyQualifiedName('.');
        ILaunchConfiguration config = this.findLaunchConfiguration(mode, (IJavaElement)type, "", fullyQualifiedName, "");
        if (config == null) {
            config = this.createConfiguration(type.getJavaProject(), type.getElementName(), fullyQualifiedName, "", "");
        }
        this.launchConfiguration(mode, config);
    }

    private void launchMethod(IMethod method, String mode) throws LaunchCancelledByUserException {
        IType declaringType = method.getDeclaringType();
        String fullyQualifiedName = declaringType.getFullyQualifiedName('.');
        ILaunchConfiguration config = this.findLaunchConfiguration(mode, (IJavaElement)method, "", fullyQualifiedName, method.getElementName());
        if (config == null) {
            config = this.createConfiguration(method.getJavaProject(), String.valueOf(declaringType.getElementName()) + "." + method.getElementName(), fullyQualifiedName, "", method.getElementName());
        }
        this.launchConfiguration(mode, config);
    }

    protected void launchConfiguration(String mode, ILaunchConfiguration config) {
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected IType chooseType(IType[] types, String mode) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(JUnitPlugin.getActiveWorkbenchShell(), (ILabelProvider)new JavaElementLabelProvider(2048));
        dialog.setElements((Object[])types);
        dialog.setTitle(JUnitMessages.LaunchTestAction_dialog_title2);
        if (mode.equals("debug")) {
            dialog.setMessage(JUnitMessages.LaunchTestAction_message_selectTestToRun);
        } else {
            dialog.setMessage(JUnitMessages.LaunchTestAction_message_selectTestToDebug);
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration findLaunchConfiguration(String mode, IJavaElement element, String container, String testClass, String testName) throws LaunchCancelledByUserException {
        ILaunchConfigurationType configType = this.getJUnitLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("org.eclipse.jdt.junit.CONTAINER", "").equals(container) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(testClass) && config.getAttribute("org.eclipse.jdt.junit.TESTNAME", "").equals(testName) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(element.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JUnitPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return null;
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) throws LaunchCancelledByUserException {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(JUnitPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(JUnitMessages.LaunchTestAction_message_selectConfiguration);
        if (mode.equals("debug")) {
            dialog.setMessage(JUnitMessages.LaunchTestAction_message_selectDebugConfiguration);
        } else {
            dialog.setMessage(JUnitMessages.LaunchTestAction_message_selectRunConfiguration);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        throw new LaunchCancelledByUserException();
    }

    protected ILaunchConfiguration createConfiguration(IJavaProject project, String name, String mainType, String container, String testName) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getJUnitLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getElementName());
            wc.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
            wc.setAttribute("org.eclipse.jdt.junit.CONTAINER", container);
            if (testName.length() > 0) {
                wc.setAttribute("org.eclipse.jdt.junit.TESTNAME", testName);
            }
            config = wc.doSave();
        }
        catch (CoreException ce) {
            JUnitPlugin.log(ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getJUnitLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.jdt.junit.launchconfig");
    }

    public class LaunchCancelledByUserException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

