/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.junit.model.TestElement;

public class TestSuiteElement
extends TestElement {
    private List fChildren;

    public TestSuiteElement(TestSuiteElement parent, String id, String testName, int childrenCount) {
        super(parent, id, testName);
        this.fChildren = new ArrayList(childrenCount);
    }

    public void addChild(TestElement child) {
        this.fChildren.add(child);
    }

    public TestElement[] getChildren() {
        return this.fChildren.toArray(new TestElement[this.fChildren.size()]);
    }

    public TestElement.Status getStatus() {
        TestElement.Status highest = TestElement.Status.NOT_RUN;
        boolean hasNotRun = false;
        TestElement[] children = this.fChildren.toArray(new TestElement[this.fChildren.size()]);
        int i = 0;
        while (i < children.length) {
            TestElement testElement = children[i];
            TestElement.Status childStatus = testElement.getStatus();
            if (childStatus == TestElement.Status.RUNNING) {
                return TestElement.Status.RUNNING;
            }
            if (childStatus == TestElement.Status.NOT_RUN) {
                hasNotRun = true;
            } else if (childStatus.getPriority() < highest.getPriority()) {
                highest = childStatus;
            }
            ++i;
        }
        if (hasNotRun && highest != TestElement.Status.NOT_RUN) {
            return TestElement.Status.RUNNING;
        }
        return highest;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.fChildren.size() + ")";
    }
}

