/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitAddLibraryProposal;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;

public class JUnitQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return 0x1000002 == problemId || 268435846 == problemId;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) {
        if (this.isJUnitProblem(context, locations)) {
            return new IJavaCompletionProposal[]{new JUnitAddLibraryProposal(context)};
        }
        return null;
    }

    private boolean isJUnitProblem(IInvocationContext context, IProblemLocation[] locations) {
        ICompilationUnit unit = context.getCompilationUnit();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation location = locations[i];
            if (!this.hasCorrections(context.getCompilationUnit(), location.getProblemId())) break;
            try {
                String s = unit.getBuffer().getText(location.getOffset(), location.getLength());
                if (s.equals("TestCase") || s.equals("junit") || s.equals("TestSuite") || s.equals("Test")) {
                    return true;
                }
            }
            catch (JavaModelException e) {
                JUnitPlugin.log(e.getStatus());
            }
            ++i;
        }
        return false;
    }
}

