/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class TestSessionLabelProvider
extends LabelProvider {
    private final TestRunnerViewPart fTestRunnerPart;
    private int fLayoutMode;

    public TestSessionLabelProvider(TestRunnerViewPart testRunnerPart) {
        this.fTestRunnerPart = testRunnerPart;
        this.fLayoutMode = 1;
    }

    public String getText(Object element) {
        if (element instanceof TestCaseElement) {
            String testMethodName = ((TestCaseElement)element).getTestMethodName();
            if (this.fLayoutMode == 1) {
                return testMethodName;
            }
            String className = ((TestCaseElement)element).getClassName();
            return Messages.format(JUnitMessages.TestSessionLabelProvider_testMethodName_className, new Object[]{testMethodName, className});
        }
        if (element instanceof TestElement) {
            return ((TestElement)element).getTestName();
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }

    public Image getImage(Object element) {
        if (element instanceof TestCaseElement) {
            TestElement.Status status = ((TestCaseElement)element).getStatus();
            if (status == TestElement.Status.NOT_RUN) {
                return this.fTestRunnerPart.fTestIcon;
            }
            if (status == TestElement.Status.RUNNING) {
                return this.fTestRunnerPart.fTestRunningIcon;
            }
            if (status == TestElement.Status.OK) {
                return this.fTestRunnerPart.fTestOkIcon;
            }
            if (status == TestElement.Status.ERROR) {
                return this.fTestRunnerPart.fTestErrorIcon;
            }
            if (status == TestElement.Status.FAILURE) {
                return this.fTestRunnerPart.fTestFailIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        if (element instanceof TestSuiteElement) {
            TestElement.Status status = ((TestSuiteElement)element).getStatus();
            if (status == TestElement.Status.NOT_RUN) {
                return this.fTestRunnerPart.fSuiteIcon;
            }
            if (status == TestElement.Status.RUNNING) {
                return this.fTestRunnerPart.fSuiteRunningIcon;
            }
            if (status == TestElement.Status.OK) {
                return this.fTestRunnerPart.fSuiteOkIcon;
            }
            if (status == TestElement.Status.ERROR) {
                return this.fTestRunnerPart.fSuiteErrorIcon;
            }
            if (status == TestElement.Status.FAILURE) {
                return this.fTestRunnerPart.fSuiteFailIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }

    public void setLayout(int layoutMode) {
        if (layoutMode != this.fLayoutMode) {
            this.fLayoutMode = layoutMode;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }
}

