/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.CheckedTableSelectionDialog;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.Resources;
import org.eclipse.jdt.internal.junit.wizards.SuiteClassesContentProvider;
import org.eclipse.jdt.internal.junit.wizards.TestSuiteClassListRange;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class UpdateTestSuite
implements IObjectActionDelegate {
    private Shell fShell;
    private IPackageFragment fPack;
    private ICompilationUnit fTestSuite;
    private IMethod fSuiteMethod;
    private static boolean fEmptySelectionAllowed = false;
    private Object[] fSelectedTestCases;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        block8: {
            JavaElementLabelProvider lprovider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
            SuiteClassesContentProvider cprovider = new SuiteClassesContentProvider();
            IType testSuiteType = this.fTestSuite.findPrimaryType();
            this.fSuiteMethod = testSuiteType.getMethod("suite", new String[0]);
            if (this.fSuiteMethod.exists()) {
                try {
                    ISourceRange range = this.fSuiteMethod.getSourceRange();
                    IBuffer buf = this.fTestSuite.getBuffer();
                    String originalContent = buf.getText(range.getOffset(), range.getLength());
                    buf.close();
                    if (UpdateTestSuite.getTestSuiteClassListRange(originalContent) != null) {
                        CheckedTableSelectionDialog dialog = new CheckedTableSelectionDialog(this.fShell, (ILabelProvider)lprovider, cprovider);
                        dialog.setValidator(new UpdateAllTestsValidator());
                        dialog.setTitle(WizardMessages.UpdateAllTests_title);
                        dialog.setMessage(WizardMessages.UpdateAllTests_message);
                        dialog.setInitialSelections(cprovider.getElements(this.fPack));
                        dialog.setSize(60, 25);
                        dialog.setInput(this.fPack);
                        if (dialog.open() == 0) {
                            this.fSelectedTestCases = dialog.getResult();
                            try {
                                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(this.getRunnable());
                            }
                            catch (Exception e) {
                                JUnitPlugin.log(e);
                            }
                        }
                        break block8;
                    }
                    this.cannotUpdateSuiteError();
                }
                catch (JavaModelException e) {
                    JUnitPlugin.log(e);
                }
            } else {
                this.noSuiteError();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object testSuiteObj;
        this.fShell = JUnitPlugin.getActiveWorkbenchShell();
        if (selection instanceof IStructuredSelection && (testSuiteObj = ((IStructuredSelection)selection).getFirstElement()) != null && testSuiteObj instanceof ICompilationUnit) {
            this.fTestSuite = (ICompilationUnit)testSuiteObj;
            IJavaElement packIJE = this.fTestSuite.getParent();
            if (packIJE instanceof IPackageFragment) {
                this.fPack = (IPackageFragment)packIJE;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTestCasesInSuite(IProgressMonitor monitor) {
        block9: {
            block8: {
                try {
                    try {
                        monitor.beginTask(WizardMessages.UpdateAllTests_beginTask, 5);
                        if (!UpdateTestSuite.checkValidateEditStatus(this.fTestSuite, this.fShell)) {
                            Object var9_2 = null;
                            break block8;
                        }
                        ISourceRange range = this.fSuiteMethod.getSourceRange();
                        Document fullSource = new Document(this.fTestSuite.getBuffer().getContents());
                        String originalContent = fullSource.get(range.getOffset(), range.getLength());
                        StringBuffer source = new StringBuffer(originalContent);
                        TestSuiteClassListRange classRange = UpdateTestSuite.getTestSuiteClassListRange(source.toString());
                        if (classRange != null) {
                            monitor.worked(1);
                            source.replace(classRange.getStart(), classRange.getEnd(), UpdateTestSuite.getUpdatableString(this.fSelectedTestCases));
                            fullSource.replace(range.getOffset(), range.getLength(), source.toString());
                            monitor.worked(1);
                            String formattedContent = JUnitStubUtility.formatCompilationUnit(this.fTestSuite.getJavaProject(), fullSource.get(), this.fTestSuite.findRecommendedLineSeparator());
                            IBuffer buf = this.fTestSuite.getBuffer();
                            buf.replace(0, buf.getLength(), formattedContent);
                            monitor.worked(1);
                            this.fTestSuite.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                            monitor.worked(1);
                        }
                        break block9;
                    }
                    catch (JavaModelException e) {
                        ExceptionHandler.handle((CoreException)((Object)e), this.fShell, WizardMessages.UpdateTestSuite_update, WizardMessages.UpdateTestSuite_error);
                    }
                    catch (BadLocationException badLocationException) {
                        Assert.isTrue((boolean)false, (String)"Should never happen");
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var9_3 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var9_4 = null;
        monitor.done();
    }

    public static TestSuiteClassListRange getTestSuiteClassListRange(String source) {
        int start = source.indexOf("$JUnit-BEGIN$");
        if (start <= -1) {
            return null;
        }
        if ((start = source.lastIndexOf("//", start)) <= -1) {
            return null;
        }
        int end = source.indexOf("$JUnit-END$", start);
        if (end <= -1) {
            return null;
        }
        return new TestSuiteClassListRange(start, end += "$JUnit-END$".length());
    }

    public static String getUpdatableString(Object[] selectedClasses) {
        StringBuffer suite = new StringBuffer();
        suite.append("//$JUnit-BEGIN$\n");
        int i = 0;
        while (i < selectedClasses.length) {
            if (selectedClasses[i] instanceof IType) {
                IType testType = (IType)selectedClasses[i];
                IMethod suiteMethod = testType.getMethod("suite", new String[0]);
                if (!suiteMethod.exists()) {
                    suite.append("suite.addTestSuite(" + testType.getElementName() + ".class);");
                } else {
                    suite.append("suite.addTest(" + testType.getElementName() + ".suite());");
                }
            }
            ++i;
        }
        suite.append("\n//$JUnit-END$");
        return suite.toString();
    }

    public static boolean checkValidateEditStatus(ICompilationUnit testSuiteCu, Shell shell) {
        IStatus status = UpdateTestSuite.validateModifiesFiles(UpdateTestSuite.getTestSuiteFile(testSuiteCu));
        if (status.isOK()) {
            return true;
        }
        ErrorDialog.openError((Shell)shell, (String)WizardMessages.UpdateTestSuite_update, (String)WizardMessages.UpdateTestSuite_could_not_update, (IStatus)status);
        return false;
    }

    private static IFile getTestSuiteFile(ICompilationUnit testSuiteCu) {
        return (IFile)testSuiteCu.getResource();
    }

    private static IStatus validateModifiesFiles(IFile fileToModify) {
        IFile[] filesToModify = new IFile[]{fileToModify};
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            return status;
        }
        status = Resources.makeCommittable((IResource[])filesToModify, null);
        if (!status.isOK()) {
            return status;
        }
        return new JUnitStatus();
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                UpdateTestSuite.this.updateTestCasesInSuite(monitor);
            }
        };
    }

    private void cannotUpdateSuiteError() {
        MessageDialog.openError((Shell)this.fShell, (String)WizardMessages.UpdateAllTests_cannotUpdate_errorDialog_title, (String)Messages.format(WizardMessages.UpdateAllTests_cannotUpdate_errorDialog_message, new String[]{"//$JUnit-BEGIN$", "//$JUnit-END$"}));
    }

    private void noSuiteError() {
        MessageDialog.openError((Shell)this.fShell, (String)WizardMessages.UpdateAllTests_cannotFind_errorDialog_title, (String)WizardMessages.UpdateAllTests_cannotFind_errorDialog_message);
    }

    private class UpdateAllTestsValidator
    implements ISelectionStatusValidator {
        UpdateAllTestsValidator() {
        }

        public IStatus validate(Object[] selection) {
            int count = 0;
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IType) {
                    ++count;
                }
                ++i;
            }
            if (count == 0 && !fEmptySelectionAllowed) {
                return new JUnitStatus(4, "");
            }
            IStatus recursiveInclusionStatus = this.checkRecursiveSuiteInclusion(selection);
            if (recursiveInclusionStatus != null && !recursiveInclusionStatus.isOK()) {
                return recursiveInclusionStatus;
            }
            String message = count == 1 ? Messages.format(WizardMessages.UpdateAllTests_selected_methods_label_one, new Integer(count)) : Messages.format(WizardMessages.UpdateAllTests_selected_methods_label_many, new Integer(count));
            return new JUnitStatus(1, message);
        }

        private IStatus checkRecursiveSuiteInclusion(Object[] selection) {
            IType suiteClass = UpdateTestSuite.this.fSuiteMethod.getDeclaringType();
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IType && ((IType)selection[i]).equals(suiteClass)) {
                    return new JUnitStatus(2, WizardMessages.UpdateTestSuite_infinite_recursion);
                }
                ++i;
            }
            return null;
        }
    }
}

