/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWorkspaceOperation
extends AbstractOperation {
    protected IResource[] resources;
    private IResourceChangeListener listener;
    private boolean isValid = true;
    private String errorTitle;
    static /* synthetic */ Class class$0;

    AbstractWorkspaceOperation(String name, String errorTitle) {
        super(name);
        this.addContext(PlatformUI.getWorkbench().getOperationSupport().getUndoContext());
        this.errorTitle = errorTitle;
    }

    protected void setTargetResources(IResource[] resources) {
        this.resources = resources;
        if (this.listener == null && resources != null) {
            this.addWorkspaceListener();
        }
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private void addWorkspaceListener() {
        this.listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    event.getDelta().accept(AbstractWorkspaceOperation.this.getDeltaVisitor());
                }
                catch (CoreException coreException) {
                    AbstractWorkspaceOperation.this.markInvalid();
                }
            }
        };
        this.getWorkspace().addResourceChangeListener(this.listener, 1);
    }

    public void dispose() {
        this.getWorkspace().removeResourceChangeListener(this.listener);
        super.dispose();
    }

    protected void markInvalid() {
        this.isValid = false;
    }

    public boolean canUndo() {
        return this.isValid;
    }

    public boolean canRedo() {
        return this.isValid;
    }

    public IStatus execute(IProgressMonitor monitor, final IAdaptable info) {
        try {
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractWorkspaceOperation.this.doExecute(monitor, info);
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(info), (String)this.errorTitle, null, (IStatus)e.getStatus());
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, final IAdaptable info) {
        try {
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractWorkspaceOperation.this.doUndo(monitor, info);
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(info), (String)this.errorTitle, null, (IStatus)e.getStatus());
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    protected abstract void doUndo(IProgressMonitor var1, IAdaptable var2) throws CoreException;

    protected abstract void doExecute(IProgressMonitor var1, IAdaptable var2) throws CoreException;

    protected IResourceDeltaVisitor getDeltaVisitor() {
        return new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (AbstractWorkspaceOperation.this.resources == null) {
                    return false;
                }
                int i = 0;
                while (i < AbstractWorkspaceOperation.this.resources.length) {
                    if (AbstractWorkspaceOperation.this.resources[i].equals((Object)delta.getResource()) && AbstractWorkspaceOperation.this.isResourceInvalid(AbstractWorkspaceOperation.this.resources[i], delta)) {
                        AbstractWorkspaceOperation.this.markInvalid();
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
    }

    protected boolean isResourceInvalid(IResource resource, IResourceDelta delta) {
        return true;
    }

    protected Shell getShell(IAdaptable info) {
        if (info != null) {
            Shell shell;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((shell = (Shell)info.getAdapter((Class)clazz)) != null) {
                return shell;
            }
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

