/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.markers.internal.CategorySorter;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.SortUtil;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkerAdapter {
    MarkerView view;
    private MarkerList lastMarkers;
    private MarkerCategory[] categories;
    private boolean building = true;

    MarkerAdapter(MarkerView markerView) {
        this.view = markerView;
    }

    public CategorySorter getCategorySorter() {
        return (CategorySorter)this.view.getViewer().getSorter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildAllMarkers(IProgressMonitor monitor) {
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                this.building = true;
                                try {
                                    int markerLimit = this.view.getMarkerLimit();
                                    monitor.beginTask(MarkerMessages.MarkerView_19, markerLimit == -1 ? 60 : 100);
                                    try {
                                        monitor.subTask(MarkerMessages.MarkerView_waiting_on_changes);
                                        if (monitor.isCanceled()) {
                                            Object var5_3 = null;
                                            this.building = false;
                                            return;
                                        }
                                        monitor.subTask(MarkerMessages.MarkerView_searching_for_markers);
                                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
                                        this.lastMarkers = MarkerList.compute(this.view.getEnabledFilters(), (IProgressMonitor)subMonitor, true);
                                        if (monitor.isCanceled()) {
                                            break block14;
                                        }
                                        this.view.refreshMarkerCounts(monitor);
                                    }
                                    catch (CoreException e) {
                                        Util.log(e);
                                        this.lastMarkers = new MarkerList();
                                        Object var5_5 = null;
                                        this.building = false;
                                        return;
                                    }
                                    if (monitor.isCanceled()) {
                                        break block15;
                                    }
                                    ViewerSorter sorter = this.view.getViewer().getSorter();
                                    if (markerLimit == -1 || this.isShowingHierarchy()) {
                                        sorter.sort((Viewer)this.view.getViewer(), (Object[])this.lastMarkers.toArray());
                                    } else {
                                        monitor.subTask(MarkerMessages.MarkerView_18);
                                        SubProgressMonitor mon = new SubProgressMonitor(monitor, 40);
                                        this.lastMarkers = SortUtil.getFirst(this.lastMarkers, (Comparator)sorter, markerLimit, (IProgressMonitor)mon);
                                        if (monitor.isCanceled()) {
                                            break block16;
                                        }
                                        sorter.sort((Viewer)this.view.getViewer(), (Object[])this.lastMarkers.toArray());
                                    }
                                    if (this.lastMarkers.getSize() == 0) {
                                        this.categories = new MarkerCategory[0];
                                        monitor.done();
                                        break block17;
                                    }
                                    monitor.subTask(MarkerMessages.MarkerView_queueing_updates);
                                    if (this.isShowingHierarchy()) {
                                        this.categories = this.buildHierarchy(this.lastMarkers, 0, this.lastMarkers.getSize() - 1, 0);
                                    }
                                    if (monitor.isCanceled()) {
                                        break block18;
                                    }
                                    monitor.done();
                                    break block19;
                                }
                                catch (Throwable throwable) {
                                    Object var5_10 = null;
                                    this.building = false;
                                    throw throwable;
                                }
                            }
                            Object var5_4 = null;
                            this.building = false;
                            return;
                        }
                        Object var5_6 = null;
                        this.building = false;
                        return;
                    }
                    Object var5_7 = null;
                    this.building = false;
                    return;
                }
                Object var5_8 = null;
                this.building = false;
                return;
            }
            Object var5_9 = null;
            this.building = false;
            return;
        }
        Object var5_11 = null;
        this.building = false;
    }

    private boolean isShowingHierarchy() {
        ViewerSorter sorter = this.view.getViewer().getSorter();
        if (sorter instanceof CategorySorter) {
            return ((CategorySorter)sorter).getCategoryField() != null;
        }
        return false;
    }

    MarkerCategory[] buildHierarchy(MarkerList markers, int start, int end, int sortIndex) {
        CategorySorter sorter = this.getCategorySorter();
        if (sortIndex > 0) {
            return null;
        }
        ArrayList<MarkerCategory> categories = new ArrayList<MarkerCategory>();
        Object previous = null;
        int categoryStart = start;
        Object[] elements = markers.getArray();
        int i = start;
        while (i <= end) {
            if (previous != null && sorter.compare(previous, elements[i], sortIndex, false) != 0) {
                categories.add(new MarkerCategory(this, categoryStart, i - 1));
                categoryStart = i;
            }
            previous = elements[i];
            ++i;
        }
        if (end >= categoryStart) {
            categories.add(new MarkerCategory(this, categoryStart, end));
        }
        MarkerCategory[] nodes = new MarkerCategory[categories.size()];
        categories.toArray(nodes);
        return nodes;
    }

    public MarkerList getCurrentMarkers() {
        if (this.lastMarkers == null) {
            this.view.scheduleMarkerUpdate(100);
            this.building = true;
        }
        if (this.building) {
            return new MarkerList();
        }
        return this.lastMarkers;
    }

    public Object[] getElements() {
        if (this.lastMarkers == null) {
            this.view.scheduleMarkerUpdate(100);
            this.building = true;
        }
        if (this.building) {
            return Util.EMPTY_MARKER_ARRAY;
        }
        if (this.isShowingHierarchy() && this.categories != null) {
            return this.categories;
        }
        return this.lastMarkers.toArray();
    }

    public boolean hasNoMarkers() {
        return this.lastMarkers == null;
    }

    public MarkerCategory[] getCategories() {
        if (this.building) {
            return null;
        }
        return this.categories;
    }

    class MarkerCategory
    extends MarkerNode {
        MarkerAdapter markerAdapter;
        int start;
        int end;
        private ConcreteMarker[] children;
        private String name;

        MarkerCategory(MarkerAdapter adapter, int startIndex, int endIndex) {
            this.markerAdapter = adapter;
            this.start = startIndex;
            this.end = endIndex;
            this.name = adapter.getCategorySorter().getCategoryField().getValue(this.markerAdapter.lastMarkers.toArray()[startIndex]);
        }

        public MarkerNode[] getChildren() {
            if (this.children == null) {
                if (MarkerAdapter.this.building) {
                    return Util.EMPTY_MARKER_ARRAY;
                }
                ConcreteMarker[] allMarkers = this.markerAdapter.lastMarkers.toArray();
                int totalSize = this.getDisplayedSize();
                this.children = new ConcreteMarker[totalSize];
                System.arraycopy(allMarkers, this.start, this.children, 0, totalSize);
                MarkerAdapter.this.view.getTableSorter().sort((Viewer)MarkerAdapter.this.view.getViewer(), this.children);
                int i = 0;
                while (i < this.children.length) {
                    this.children[i].setCategory(this);
                    ++i;
                }
            }
            return this.children;
        }

        private int getDisplayedSize() {
            if (MarkerAdapter.this.view.getMarkerLimit() > 0) {
                return Math.min(this.getTotalSize(), MarkerAdapter.this.view.getMarkerLimit());
            }
            return this.getTotalSize();
        }

        public MarkerNode getParent() {
            return null;
        }

        public String getDescription() {
            if (MarkerAdapter.this.view.getMarkerLimit() < 0) {
                return NLS.bind((String)MarkerMessages.Category_Label, (Object[])new Object[]{this.name, String.valueOf(this.getDisplayedSize())});
            }
            return NLS.bind((String)MarkerMessages.Category_Limit_Label, (Object[])new Object[]{this.name, String.valueOf(this.getDisplayedSize()), String.valueOf(this.getTotalSize())});
        }

        private int getTotalSize() {
            return this.end - this.start + 1;
        }

        public boolean isConcrete() {
            return false;
        }

        public ConcreteMarker getConcreteRepresentative() {
            return this.markerAdapter.lastMarkers.getMarker(this.start);
        }

        public String getName() {
            return this.name;
        }
    }
}

