/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.localstore.BlobStore;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.HistoryStoreEntry;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.localstore.IHistoryStoreVisitor;
import org.eclipse.core.internal.properties.IndexedStoreWrapper;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.FileState;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.utils.Convert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class HistoryStore
implements IHistoryStore {
    static final String INDEX_FILE = ".index";
    protected BlobStore blobStore;
    Set blobsToRemove = new HashSet();
    IndexedStoreWrapper store;
    protected Workspace workspace;

    public HistoryStore(Workspace workspace, IPath location, int limit) {
        this.workspace = workspace;
        this.blobStore = new BlobStore(EFS.getLocalFileSystem().getStore(location), limit);
        this.store = new IndexedStoreWrapper(location.append(INDEX_FILE));
    }

    protected void accept(byte[] key, IHistoryStoreVisitor visitor, boolean visitOnPartialMatch, boolean includeLastModTime) {
        try {
            IndexCursor cursor = this.store.getCursor();
            cursor.find(key);
            while (cursor.keyMatches(key)) {
                HistoryStoreEntry storedEntry;
                int bytesToOmit;
                byte[] storedKey = cursor.getKey();
                int n = bytesToOmit = includeLastModTime ? 1 : 9;
                if (storedKey.length - bytesToOmit == key.length) {
                    HistoryStoreEntry storedEntry2 = HistoryStoreEntry.create(this.store, cursor);
                    if (!visitor.visit(storedEntry2)) break;
                    cursor.next();
                    continue;
                }
                if (!visitOnPartialMatch) {
                    cursor.next();
                    continue;
                }
                byte b = storedKey[key.length];
                if ((key[key.length - 1] == 47 || b == 47) && !visitor.visit(storedEntry = HistoryStoreEntry.create(this.store, cursor))) break;
                cursor.next();
            }
            cursor.close();
        }
        catch (Exception e) {
            String message = CompatibilityMessages.history_problemsAccessing;
            ResourceStatus status = new ResourceStatus(271, null, message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    protected void accept(IPath path, IHistoryStoreVisitor visitor, boolean visitOnPartialMatch) {
        this.accept(Convert.toUTF8((String)path.toString()), visitor, visitOnPartialMatch, false);
    }

    public IFileState addState(IPath key, IFileStore localFile, IFileInfo info, boolean moveContents) {
        long lastModified = info.getLastModified();
        if (Policy.DEBUG_HISTORY) {
            System.out.println("History: Adding state for key: " + key + ", file: " + localFile + ", timestamp: " + lastModified + ", size: " + localFile.fetchInfo().getLength());
        }
        if (!this.isValid(localFile)) {
            return null;
        }
        UniversalUniqueIdentifier uuid = null;
        try {
            uuid = this.blobStore.addBlob(localFile, moveContents);
            this.addState(key, uuid, lastModified);
            this.store.commit();
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
        return new FileState((IHistoryStore)this, key, lastModified, uuid);
    }

    protected void addState(IPath path, UniversalUniqueIdentifier uuid, long lastModified) {
        byte[] keyPrefix = HistoryStoreEntry.keyPrefixToBytes(path, lastModified);
        class BitVisitor
        implements IHistoryStoreVisitor {
            BitSet bits;
            final /* synthetic */ HistoryStore this$0;

            BitVisitor(HistoryStore historyStore) {
                this.this$0 = historyStore;
                this.bits = new BitSet();
            }

            public byte useNextClearBit(byte[] key) {
                int nextBit = this.bits.length();
                if (nextBit > 127) {
                    if (this.bits.cardinality() < 127) {
                        try {
                            IndexCursor cursor = this.this$0.store.getCursor();
                            byte destCount = (byte)this.bits.nextClearBit(0);
                            if (destCount < 0) {
                                return -1;
                            }
                            byte sourceCount = (byte)this.bits.nextSetBit(destCount);
                            if (sourceCount < 0) {
                                return destCount;
                            }
                            byte[] completeKey = new byte[key.length + 1];
                            System.arraycopy(key, 0, completeKey, 0, key.length);
                            while (sourceCount >= 0 && destCount >= 0) {
                                completeKey[completeKey.length - 1] = sourceCount;
                                cursor.find(completeKey);
                                if (cursor.keyMatches(completeKey)) {
                                    HistoryStoreEntry storedEntry = HistoryStoreEntry.create(this.this$0.store, cursor);
                                    HistoryStoreEntry entryToInsert = new HistoryStoreEntry(storedEntry.getPath(), storedEntry.getUUID(), storedEntry.getLastModified(), destCount);
                                    this.this$0.remove(storedEntry);
                                    ObjectID valueID = this.this$0.store.createObject(entryToInsert.valueToBytes());
                                    this.this$0.store.getIndex().insert(entryToInsert.getKey(), valueID);
                                    sourceCount = (byte)this.bits.nextSetBit(sourceCount + 1);
                                }
                                destCount = (byte)(destCount + 1);
                            }
                            cursor.close();
                            return destCount;
                        }
                        catch (Exception e) {
                            String message = CompatibilityMessages.history_problemsAccessing;
                            ResourceStatus status = new ResourceStatus(271, null, message, (Throwable)e);
                            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                        }
                    } else {
                        return -1;
                    }
                }
                return (byte)nextBit;
            }

            public boolean visit(HistoryStoreEntry entry) {
                this.bits.set(entry.getCount());
                return true;
            }
        }
        BitVisitor visitor = new BitVisitor(this);
        this.accept(keyPrefix, visitor, false, true);
        byte index = visitor.useNextClearBit(keyPrefix);
        try {
            if (index < 0) {
                String message = NLS.bind((String)CompatibilityMessages.history_tooManySimUpdates, (Object)path, (Object)new Date(lastModified));
                ResourceStatus status = new ResourceStatus(272, path, message, null);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                return;
            }
            HistoryStoreEntry entryToInsert = new HistoryStoreEntry(path, uuid, lastModified, index);
            ObjectID valueID = this.store.createObject(entryToInsert.valueToBytes());
            this.store.getIndex().insert(entryToInsert.getKey(), valueID);
        }
        catch (Exception e) {
            this.resetIndexedStore();
            String message = NLS.bind((String)CompatibilityMessages.history_couldNotAdd, (Object)path);
            ResourceStatus status = new ResourceStatus(272, path, message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    public Set allFiles(IPath path, int depth, IProgressMonitor monitor) {
        HashSet allFiles = new HashSet();
        int pathLength = path.segmentCount();
        class PathCollector
        implements IHistoryStoreVisitor {
            final /* synthetic */ HistoryStore this$0;
            private final /* synthetic */ int val$depth;
            private final /* synthetic */ int val$pathLength;
            private final /* synthetic */ Set val$allFiles;

            PathCollector(HistoryStore historyStore, int n, int n2, Set set) {
                this.this$0 = historyStore;
                this.val$depth = n;
                this.val$pathLength = n2;
                this.val$allFiles = set;
            }

            public boolean visit(HistoryStoreEntry state) {
                IPath memberPath = state.getPath();
                boolean withinDepthRange = false;
                switch (this.val$depth) {
                    case 0: {
                        withinDepthRange = memberPath.segmentCount() == this.val$pathLength;
                        break;
                    }
                    case 1: {
                        withinDepthRange = memberPath.segmentCount() <= this.val$pathLength + 1;
                        break;
                    }
                    case 2: {
                        withinDepthRange = true;
                    }
                }
                if (withinDepthRange) {
                    this.val$allFiles.add(memberPath);
                }
                return withinDepthRange;
            }
        }
        this.accept(path, new PathCollector(this, depth, pathLength, allFiles), true);
        return allFiles;
    }

    public void clean(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        int entryCount = 0;
        WorkspaceDescription description = this.workspace.internalGetDescription();
        long minimumTimestamp = System.currentTimeMillis() - description.getFileStateLongevity();
        int max = description.getMaxFileStates();
        IPath current = null;
        ArrayList<HistoryStoreEntry> result = new ArrayList<HistoryStoreEntry>(Math.min(max, 1000));
        try {
            IndexCursor cursor = this.store.getCursor();
            cursor.findFirstEntry();
            while (cursor.isSet()) {
                ++entryCount;
                HistoryStoreEntry entry = HistoryStoreEntry.create(this.store, cursor);
                if (entry.getLastModified() < minimumTimestamp) {
                    this.remove(entry);
                    continue;
                }
                if (!entry.getPath().equals(current)) {
                    this.removeOldestEntries(result, max);
                    result.clear();
                    current = entry.getPath();
                }
                result.add(entry);
                cursor.next();
            }
            this.removeOldestEntries(result, max);
            cursor.close();
            this.store.commit();
            if (Policy.DEBUG_HISTORY) {
                Policy.debug((String)("Time to apply history store policies: " + (System.currentTimeMillis() - start) + "ms."));
                Policy.debug((String)("Total number of history store entries: " + entryCount));
            }
            start = System.currentTimeMillis();
            this.blobStore.deleteBlobs(this.blobsToRemove);
            if (Policy.DEBUG_HISTORY) {
                Policy.debug((String)("Time to remove " + this.blobsToRemove.size() + " unreferenced blobs: " + (System.currentTimeMillis() - start) + "ms."));
            }
            this.blobsToRemove = new HashSet();
        }
        catch (Exception e) {
            String message = CompatibilityMessages.history_problemsCleaning;
            ResourceStatus status = new ResourceStatus(273, null, message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    public void closeHistoryStore(IResource resource) {
    }

    public void copyHistory(IResource sourceResource, IResource destinationResource, boolean moving) {
        ResourceStatus status;
        String message;
        if (sourceResource == null || destinationResource == null) {
            String message2 = CompatibilityMessages.history_copyToNull;
            ResourceStatus status2 = new ResourceStatus(566, null, message2, null);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status2);
            return;
        }
        if (sourceResource.equals((Object)destinationResource)) {
            String message3 = CompatibilityMessages.history_copyToSelf;
            ResourceStatus status3 = new ResourceStatus(566, sourceResource.getFullPath(), message3, null);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status3);
            return;
        }
        final IPath source = sourceResource.getFullPath();
        final IPath destination = destinationResource.getFullPath();
        final HashSet matches = new HashSet();
        IHistoryStoreVisitor visitor = new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry entry) {
                IPath path = entry.getPath();
                int prefixSegments = source.matchingFirstSegments(path);
                if (prefixSegments == 0) {
                    String message = NLS.bind((String)CompatibilityMessages.history_interalPathErrors, (Object)source, (Object)path);
                    ResourceStatus status = new ResourceStatus(566, source, message, null);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                    return false;
                }
                if (!HistoryStore.this.stateAlreadyExists(path = destination.append(path.removeFirstSegments(prefixSegments)), entry.getUUID())) {
                    matches.add(path);
                    HistoryStore.this.addState(path, entry.getUUID(), entry.getLastModified());
                }
                return true;
            }
        };
        this.accept(source, visitor, true);
        WorkspaceDescription description = this.workspace.internalGetDescription();
        int maxFileStates = description.getMaxFileStates();
        try {
            Iterator i = matches.iterator();
            while (i.hasNext()) {
                LinkedList<HistoryStoreEntry> removeEntries = new LinkedList<HistoryStoreEntry>();
                IndexCursor cursor = this.store.getCursor();
                IPath path = (IPath)i.next();
                byte[] key = Convert.toUTF8((String)path.toString());
                cursor.find(key);
                while (cursor.keyMatches(key)) {
                    removeEntries.add(HistoryStoreEntry.create(this.store, cursor));
                    cursor.next();
                }
                cursor.close();
                this.removeOldestEntries(removeEntries, maxFileStates);
            }
        }
        catch (IndexedStoreException e) {
            message = NLS.bind((String)CompatibilityMessages.history_problemsPurging, (Object)source, (Object)destination);
            status = new ResourceStatus(568, source, message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
        catch (CoreException e) {
            message = NLS.bind((String)CompatibilityMessages.history_problemsPurging, (Object)source, (Object)destination);
            status = new ResourceStatus(568, source, message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
        try {
            this.store.commit();
        }
        catch (CoreException e) {
            message = NLS.bind((String)CompatibilityMessages.history_problemCopying, (Object)source, (Object)destination);
            status = new ResourceStatus(568, source, message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    public boolean exists(IFileState target) {
        return this.blobStore.fileFor(((FileState)target).getUUID()).fetchInfo().exists();
    }

    public InputStream getContents(IFileState target) throws CoreException {
        if (!target.exists()) {
            String message = CompatibilityMessages.history_notValid;
            throw new ResourceException(271, target.getFullPath(), message, null);
        }
        return this.blobStore.getBlob(((FileState)target).getUUID());
    }

    public IFileState[] getStates(final IPath key, IProgressMonitor monitor) {
        int max = this.workspace.internalGetDescription().getMaxFileStates();
        final ArrayList result = new ArrayList(max);
        IHistoryStoreVisitor visitor = new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry entry) {
                result.add(new FileState((IHistoryStore)HistoryStore.this, key, entry.getLastModified(), entry.getUUID()));
                return true;
            }
        };
        this.accept(key, visitor, false);
        if (result.isEmpty()) {
            return ICoreConstants.EMPTY_FILE_STATES;
        }
        IFileState[] states = new IFileState[result.size()];
        int i = 0;
        while (i < states.length) {
            states[i] = (IFileState)result.get(result.size() - (i + 1));
            ++i;
        }
        return states;
    }

    private boolean isValid(IFileStore localFile) {
        boolean result;
        WorkspaceDescription description = this.workspace.internalGetDescription();
        long length = localFile.fetchInfo().getLength();
        boolean bl = result = length <= description.getMaxFileStateSize();
        if (Policy.DEBUG_HISTORY && !result) {
            System.out.println("History: Ignoring file (too large). File: " + localFile.toString() + ", size: " + length + ", max: " + description.getMaxFileStateSize());
        }
        return result;
    }

    protected void remove(HistoryStoreEntry entry) throws IndexedStoreException {
        try {
            Vector objectIds = this.store.getIndex().getObjectIdentifiersMatching(entry.getKey());
            if (objectIds.size() == 1) {
                this.store.removeObject((ObjectID)objectIds.get(0));
            } else if (objectIds.size() > 1) {
                String message = NLS.bind((String)CompatibilityMessages.history_tooManySimUpdates, (Object)entry.getPath(), (Object)new Date(entry.getLastModified()));
                ResourceStatus status = new ResourceStatus(273, entry.getPath(), message, null);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        catch (Exception e) {
            Object[] messageArgs = new String[]{entry.getPath().toString(), new Date(entry.getLastModified()).toString(), entry.getUUID().toString()};
            String message = NLS.bind((String)CompatibilityMessages.history_specificProblemsCleaning, (Object[])messageArgs);
            ResourceStatus status = new ResourceStatus(273, null, message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
        this.blobsToRemove.add(entry.getUUID());
        entry.remove();
    }

    public void remove(IPath path, IProgressMonitor monitor) {
        if (Path.ROOT.equals((Object)path)) {
            this.removeAll();
            return;
        }
        try {
            IndexCursor cursor = this.store.getCursor();
            byte[] key = Convert.toUTF8((String)path.toString());
            cursor.find(key);
            while (cursor.keyMatches(key)) {
                HistoryStoreEntry entry = HistoryStoreEntry.create(this.store, cursor);
                this.remove(entry);
            }
            cursor.close();
            this.store.commit();
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.history_problemsRemoving, (Object)path);
            ResourceStatus status = new ResourceStatus(273, path, message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    private void removeAll() {
        try {
            IndexCursor cursor = this.store.getCursor();
            cursor.findFirstEntry();
            while (cursor.isSet()) {
                HistoryStoreEntry entry = HistoryStoreEntry.create(this.store, cursor);
                this.remove(entry);
            }
            cursor.close();
            this.store.commit();
        }
        catch (Exception e) {
            String message = NLS.bind((String)CompatibilityMessages.history_problemsRemoving, (Object)this.workspace.getRoot().getFullPath());
            ResourceStatus status = new ResourceStatus(273, this.workspace.getRoot().getFullPath(), message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    public void removeGarbage() {
        try {
            IndexCursor cursor = this.store.getCursor();
            cursor.findFirstEntry();
            while (!this.blobsToRemove.isEmpty() && cursor.isSet()) {
                HistoryStoreEntry entry = HistoryStoreEntry.create(this.store, cursor);
                this.blobsToRemove.remove(entry.getUUID());
                cursor.next();
            }
            cursor.close();
            this.blobStore.deleteBlobs(this.blobsToRemove);
            this.blobsToRemove = new HashSet();
        }
        catch (Exception e) {
            String message = CompatibilityMessages.history_problemsCleaning;
            ResourceStatus status = new ResourceStatus(273, null, message, (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    protected void removeOldestEntries(List entries, int maxEntries) throws IndexedStoreException {
        if (entries.size() <= maxEntries) {
            return;
        }
        int limit = entries.size() - maxEntries;
        int i = 0;
        while (i < limit) {
            this.remove((HistoryStoreEntry)entries.get(i));
            ++i;
        }
    }

    protected void resetIndexedStore() {
        this.store.reset();
        File target = this.workspace.getMetaArea().getHistoryStoreLocation().toFile();
        Workspace.clear((File)target);
        target.mkdirs();
        String message = CompatibilityMessages.history_corrupt;
        ResourceStatus status = new ResourceStatus(566, null, message, null);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public void shutdown(IProgressMonitor monitor) {
        if (this.store == null) {
            return;
        }
        this.store.close();
    }

    public void startup(IProgressMonitor monitor) {
    }

    boolean stateAlreadyExists(IPath path, final UniversalUniqueIdentifier uuid) {
        final boolean[] rc = new boolean[1];
        IHistoryStoreVisitor visitor = new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry entry) {
                if (rc[0] || uuid.equals((Object)entry.getUUID())) {
                    rc[0] = true;
                    return false;
                }
                return true;
            }
        };
        this.accept(path, visitor, false);
        return rc[0];
    }
}

