/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.util.ArrayList;
import org.eclipse.ui.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.cheatsheets.ITaskGroup;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskChoiceCompletionStrategy;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskSetCompletionStrategy;
import org.eclipse.ui.internal.cheatsheets.composite.parser.ITaskParseStrategy;
import org.eclipse.ui.internal.cheatsheets.composite.parser.TaskGroupParseStrategy;

public class TaskGroup
extends AbstractTask
implements ITaskGroup {
    private ITaskParseStrategy parserStrategy;
    private ArrayList subtasks;
    private CompletionStrategy completionStrategy;

    public TaskGroup(CompositeCheatSheetModel model, String id, String name, String kind) {
        super(model, id, name, kind);
        if (kind == null) {
            this.kind = "set";
        }
        this.parserStrategy = new TaskGroupParseStrategy();
        this.completionStrategy = this.determineCompletionStrategy(kind);
    }

    private CompletionStrategy determineCompletionStrategy(String kind) {
        if ("choice".equals(kind)) {
            return new TaskChoiceCompletionStrategy();
        }
        return new TaskSetCompletionStrategy();
    }

    public ITaskParseStrategy getParserStrategy() {
        return this.parserStrategy;
    }

    public ICompositeCheatSheetTask[] getSubtasks() {
        if (this.subtasks == null) {
            return EMPTY;
        }
        return this.subtasks.toArray(new ICompositeCheatSheetTask[this.subtasks.size()]);
    }

    public void addSubtask(ICompositeCheatSheetTask task) {
        if (this.subtasks == null) {
            this.subtasks = new ArrayList();
        }
        this.subtasks.add(task);
        ((AbstractTask)task).setParent(this);
    }

    public void checkState() {
        int newState = this.computeState();
        if (newState != this.state) {
            this.setState(newState);
        }
    }

    public int computeState() {
        return this.completionStrategy.computeState(this);
    }

    public static interface CompletionStrategy {
        public int computeState(TaskGroup var1);
    }
}

