/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.actions.IMenuContributor;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.cheatsheets.views.CoreItem;
import org.eclipse.ui.internal.cheatsheets.views.IntroItem;
import org.eclipse.ui.internal.cheatsheets.views.Page;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;

public class CheatSheetPage
extends Page
implements IMenuContributor {
    private Color introColor;
    private Color activeColor;
    private Color alternateColor;
    private CheatSheet cheatSheet;
    private ArrayList viewItemList;
    private CheatSheetViewer viewer;

    public CheatSheetPage(CheatSheet cheatSheet, ArrayList viewItemList, CheatSheetViewer cheatSheetViewer) {
        this.cheatSheet = cheatSheet;
        this.viewItemList = viewItemList;
        this.viewer = cheatSheetViewer;
    }

    public void createPart(Composite parent) {
        CheatSheetStopWatch.startStopWatch("CheatSheetPage.createPart()");
        super.createPart(parent);
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createPart()", "Time in CheatSheetPage.createInfoArea() after super.createInfoArea(): ");
        IntroItem intro = new IntroItem(this, this.cheatSheet.getIntroItem(), this.introColor, this.viewer);
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createPart()", "Time in CheatSheetPage.createInfoArea() after new IntroItem(): ");
        intro.setBold(true);
        this.viewItemList.add(intro);
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createInfoArea()", "Time in CheatSheetPage.createPart() before add loop: ");
        ArrayList items = this.cheatSheet.getItems();
        int i = 0;
        while (i < items.size()) {
            Color color = i % 2 == 0 ? this.backgroundColor : this.alternateColor;
            CoreItem coreItem = new CoreItem(this, (Item)items.get(i), color, this.viewer);
            this.viewItemList.add(coreItem);
            ++i;
        }
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createInfoArea()", "Time in CheatSheetPage.createPart(): ");
    }

    protected String getTitle() {
        if (this.cheatSheet != null && this.cheatSheet.getTitle() != null) {
            return this.cheatSheet.getTitle();
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        if (this.alternateColor != null) {
            this.alternateColor.dispose();
        }
        if (this.activeColor != null) {
            this.activeColor.dispose();
        }
        if (this.introColor != null) {
            this.introColor.dispose();
        }
        this.alternateColor = null;
        this.activeColor = null;
        this.introColor = null;
    }

    protected void init(Display display) {
        super.init(display);
        this.computeColors(display);
    }

    private void computeColors(Display display) {
        RGB rgb;
        RGB white = new RGB(255, 255, 255);
        RGB black = new RGB(0, 0, 0);
        if (this.toolkit.getColors().isWhiteBackground()) {
            rgb = this.toolkit.getColors().getSystemColor(26);
            if (FormColors.testTwoPrimaryColors((RGB)(rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)20)), (int)245, (int)256)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)80);
            } else if (FormColors.testAnyPrimaryColor((RGB)rgb, (int)170, (int)191)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)85);
            } else if (FormColors.testAnyPrimaryColor((RGB)rgb, (int)190, (int)215)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)90);
            }
            if (Math.abs(rgb.blue - rgb.green) < 5 && Math.abs(rgb.blue - rgb.red) < 5 && Math.abs(rgb.green - rgb.red) < 5) {
                rgb = FormColors.blend((RGB)rgb, (RGB)new RGB(100, 100, 255), (int)90);
            }
            this.activeColor = new Color((Device)display, rgb);
            rgb = this.toolkit.getColors().getSystemColor(22);
            if (FormColors.testTwoPrimaryColors((RGB)(rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)60)), (int)209, (int)220)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)70);
            } else if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)209, (int)230)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)80);
            }
            this.alternateColor = new Color((Device)display, rgb);
        } else {
            rgb = this.toolkit.getColors().getSystemColor(26);
            if (FormColors.testTwoPrimaryColors((RGB)(rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)30)), (int)200, (int)221)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)80);
            } else if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)222, (int)241)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)60);
            } else if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)240, (int)256)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)30);
            }
            this.activeColor = new Color((Device)display, rgb);
            rgb = this.toolkit.getColors().getSystemColor(22);
            rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)60);
            if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)200, (int)216)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)90);
            } else if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)215, (int)221)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)80);
            } else if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)220, (int)231)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)60);
            } else if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)230, (int)256)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)40);
            }
            this.alternateColor = new Color((Device)display, rgb);
        }
        rgb = this.activeColor.getRGB();
        rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)40);
        this.introColor = new Color((Device)display, rgb);
    }

    public void initialized() {
        Iterator iter = this.viewItemList.iterator();
        while (iter.hasNext()) {
            ViewItem item = (ViewItem)iter.next();
            item.initialized();
        }
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public Color getAlternateColor() {
        return this.alternateColor;
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    private int contributeRestartItem(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 8, index++);
        item.setText(Messages.RESTART_MENU);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheatSheetPage.this.viewer.restart();
            }
        });
        return index;
    }

    public int contributeToViewMenu(Menu menu, int index) {
        return this.contributeRestartItem(menu, index);
    }
}

