/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.ProjectSetContentHandler;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.UIProjectSetSerializationContext;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectSetImporter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IProject[] importProjectSet(String filename, Shell shell, IProgressMonitor monitor) throws InvocationTargetException {
        IProject[] iProjectArray;
        InputStreamReader reader = null;
        try {
            try {
                ArrayList<IProject> newProjects;
                block22: {
                    reader = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser parser = factory.newSAXParser();
                    ProjectSetContentHandler handler = new ProjectSetContentHandler();
                    InputSource source = new InputSource(reader);
                    parser.parse(source, (DefaultHandler)handler);
                    Map map = handler.getReferences();
                    newProjects = new ArrayList<IProject>();
                    if ((map == null || map.size() == 0) && handler.isVersionOne()) {
                        IProject[] projects;
                        IProjectSetSerializer serializer = Team.getProjectSetSerializer((String)"versionOneSerializer");
                        if (serializer != null && (projects = serializer.addToWorkspace(new String[0], filename, (Object)shell, monitor)) != null) {
                            newProjects.addAll(Arrays.asList(projects));
                        }
                    } else {
                        UIProjectSetSerializationContext context = new UIProjectSetSerializationContext(shell, filename);
                        Iterator it = map.keySet().iterator();
                        ArrayList<TeamException> errors = new ArrayList<TeamException>();
                        while (true) {
                            if (!it.hasNext()) {
                                if (!errors.isEmpty()) {
                                    if (errors.size() != 1) break;
                                    throw (TeamException)((Object)errors.get(0));
                                }
                                break block22;
                            }
                            try {
                                IProject[] projects;
                                String id = (String)it.next();
                                List references = (List)map.get(id);
                                RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
                                if (providerType == null) {
                                    providerType = TeamPlugin.getAliasType((String)id);
                                }
                                if (providerType == null) {
                                    throw new TeamException((IStatus)new Status(4, "org.eclipse.team.ui", 0, NLS.bind((String)TeamUIMessages.ProjectSetImportWizard_0, (Object[])new String[]{id}), null));
                                }
                                ProjectSetCapability serializer = providerType.getProjectSetCapability();
                                ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)serializer);
                                if (serializer == null || (projects = serializer.addToWorkspace(references.toArray(new String[references.size()]), (ProjectSetSerializationContext)context, monitor)) == null) continue;
                                newProjects.addAll(Arrays.asList(projects));
                            }
                            catch (TeamException e) {
                                errors.add(e);
                            }
                        }
                        TeamException[] exceptions = errors.toArray(new TeamException[errors.size()]);
                        IStatus[] status = new IStatus[exceptions.length];
                        int i = 0;
                        while (true) {
                            if (i >= exceptions.length) {
                                throw new TeamException((IStatus)new MultiStatus("org.eclipse.team.ui", 0, status, TeamUIMessages.ProjectSetImportWizard_1, null));
                            }
                            status[i] = exceptions[i].getStatus();
                            ++i;
                        }
                    }
                }
                iProjectArray = newProjects.toArray(new IProject[newProjects.size()]);
                Object var18_27 = null;
                if (reader == null) return iProjectArray;
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (SAXException e) {
                throw new InvocationTargetException(e);
            }
            catch (TeamException e) {
                throw new InvocationTargetException(e);
            }
            catch (ParserConfigurationException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var18_28 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        reader.close();
        return iProjectArray;
    }
}

