/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeChangeListener;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.CommonMenuManager;
import org.eclipse.team.internal.ui.mapping.IEmptyTreeListener;
import org.eclipse.team.internal.ui.mapping.TeamViewerSorter;
import org.eclipse.team.internal.ui.synchronize.AbstractTreeViewerAdvisor;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;
import org.eclipse.team.ui.mapping.SynchronizationStateTester;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSiteFactory;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentServiceListener;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.part.IPageSite;

public class CommonViewerAdvisor
extends AbstractTreeViewerAdvisor
implements INavigatorContentServiceListener,
IEmptyTreeListener,
IPropertyChangeListener {
    public static final String TEAM_NAVIGATOR_CONTENT = "org.eclipse.team.ui.navigatorViewer";
    private Set extensions = new HashSet();
    private NavigatorActionService actionService;
    private IEmptyTreeListener emptyTreeListener;

    private static CommonViewer createViewer(Composite parent, ISynchronizePageConfiguration configuration, IEmptyTreeListener listener) {
        final NavigableCommonViewer v = new NavigableCommonViewer(configuration.getViewerId(), parent, 770, listener);
        v.setSorter((ViewerSorter)new TeamViewerSorter(new CommonViewerSorter()));
        ISynchronizationScope scope = CommonViewerAdvisor.getScope(configuration);
        CommonViewerAdvisor.bindTeamContentProviders(v);
        scope.addScopeChangeListener(new ISynchronizationScopeChangeListener(){

            public void scopeChanged(ISynchronizationScope scope, ResourceMapping[] newMappings, ResourceTraversal[] newTraversals) {
                CommonViewerAdvisor.enableContentProviders(v, scope);
                Utils.asyncExec(new Runnable(this, v){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ CommonViewer val$v;
                    {
                        this.this$1 = var1_1;
                        this.val$v = commonViewer;
                    }

                    public void run() {
                        this.val$v.refresh();
                    }
                }, (StructuredViewer)v);
            }
        });
        CommonViewerAdvisor.enableContentProviders(v, scope);
        configuration.getSite().setSelectionProvider((ISelectionProvider)v);
        return v;
    }

    private static void enableContentProviders(CommonViewer v, ISynchronizationScope scope) {
        v.getNavigatorContentService().getActivationService().activateExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(scope), true);
    }

    private static void bindTeamContentProviders(CommonViewer v) {
        ITeamContentProviderManager teamContentProviderManager = TeamUI.getTeamContentProviderManager();
        ITeamContentProviderDescriptor[] descriptors = teamContentProviderManager.getDescriptors();
        HashSet<String> toBind = new HashSet<String>();
        int i = 0;
        while (i < descriptors.length) {
            ITeamContentProviderDescriptor descriptor = descriptors[i];
            toBind.add(descriptor.getContentExtensionId());
            ++i;
        }
        v.getNavigatorContentService().bindExtensions(toBind.toArray(new String[toBind.size()]), true);
    }

    private static ISynchronizationScope getScope(ISynchronizePageConfiguration configuration) {
        return (ISynchronizationScope)configuration.getProperty("org.eclipse.team.ui.synchronizationScope");
    }

    public CommonViewerAdvisor(Composite parent, ISynchronizePageConfiguration configuration) {
        super(configuration);
        CommonViewer viewer = CommonViewerAdvisor.createViewer(parent, configuration, this);
        TeamUI.getTeamContentProviderManager().addPropertyChangeListener(this);
        GridData data = new GridData(1808);
        viewer.getControl().setLayoutData((Object)data);
        viewer.getNavigatorContentService().addListener((INavigatorContentServiceListener)this);
        this.initializeViewer((StructuredViewer)viewer);
        IBaseLabelProvider provider = viewer.getLabelProvider();
        if (provider instanceof DecoratingLabelProvider) {
            DecoratingLabelProvider dlp = (DecoratingLabelProvider)provider;
            DecorationContext decorationContext = new DecorationContext();
            decorationContext.putProperty("org.eclipse.team.ui.syncStateTester", (Object)new SynchronizationStateTester(){

                public boolean isStateDecorationEnabled() {
                    return false;
                }
            });
            dlp.setDecorationContext((IDecorationContext)decorationContext);
        }
        viewer.setInput(this.getInitialInput());
        viewer.expandToLevel(2);
    }

    public void initializeViewer(StructuredViewer viewer) {
        this.createActionService((CommonViewer)viewer, this.getConfiguration());
        super.initializeViewer(viewer);
    }

    private void createActionService(CommonViewer viewer, ISynchronizePageConfiguration configuration) {
        ICommonViewerSite commonSite = this.createCommonViewerSite(viewer, configuration);
        this.actionService = new NavigatorActionService(commonSite, (StructuredViewer)viewer, viewer.getNavigatorContentService());
    }

    private ICommonViewerSite createCommonViewerSite(CommonViewer viewer, ISynchronizePageConfiguration configuration) {
        IWorkbenchSite site = configuration.getSite().getWorkbenchSite();
        if (site instanceof IEditorSite) {
            IEditorSite es = (IEditorSite)site;
            return CommonViewerSiteFactory.createCommonViewerSite((IEditorSite)es);
        }
        if (site instanceof IViewSite) {
            IViewSite vs = (IViewSite)site;
            return CommonViewerSiteFactory.createCommonViewerSite((IViewSite)vs);
        }
        if (site instanceof IPageSite) {
            IPageSite ps = (IPageSite)site;
            return CommonViewerSiteFactory.createCommonViewerSite((String)configuration.getViewerId(), (IPageSite)ps);
        }
        return CommonViewerSiteFactory.createCommonViewerSite((String)configuration.getViewerId(), (ISelectionProvider)viewer, (Shell)configuration.getSite().getShell());
    }

    private Object getInitialInput() {
        return this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    public void onLoad(INavigatorContentExtension anExtension) {
        this.extensions.add(anExtension);
        SynchronizationContext context = this.getParticipant().getContext();
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationScope", (Object)context.getScope());
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationPageConfiguration", (Object)this.getConfiguration());
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationContext", (Object)context);
    }

    private ModelSynchronizeParticipant getParticipant() {
        return (ModelSynchronizeParticipant)this.getConfiguration().getParticipant();
    }

    protected String getContextMenuId(StructuredViewer viewer) {
        return ((CommonViewer)viewer).getNavigatorContentService().getViewerDescriptor().getPopupMenuId();
    }

    protected void registerContextMenu(StructuredViewer viewer, MenuManager menuMgr) {
        this.actionService.prepareMenuForPlatformContributions(menuMgr, (ISelectionProvider)viewer, false);
    }

    protected void fillContextMenu(StructuredViewer viewer, IMenuManager manager) {
        if (manager instanceof CommonMenuManager) {
            CommonMenuManager cmm = (CommonMenuManager)manager;
            cmm.clearHandlers();
        }
        ISelection selection = this.getViewer().getSelection();
        this.actionService.setContext(new ActionContext(selection));
        this.actionService.fillContextMenu(manager);
        super.fillContextMenu(viewer, manager);
    }

    public void dispose() {
        TeamUI.getTeamContentProviderManager().removePropertyChangeListener(this);
        this.actionService.dispose();
        super.dispose();
    }

    protected void updateActionBars(IStructuredSelection selection) {
        super.updateActionBars(selection);
        if (!this.getConfiguration().getSite().isModal()) {
            this.actionService.setContext(new ActionContext((ISelection)selection));
            this.actionService.fillActionBars(this.getConfiguration().getSite().getActionBars());
        }
    }

    protected MenuManager createContextMenuManager(String targetID) {
        return new CommonMenuManager(targetID);
    }

    protected void addContextMenuGroups(IMenuManager manager) {
    }

    public void addEmptyTreeListener(IEmptyTreeListener emptyTreeListener) {
        this.emptyTreeListener = emptyTreeListener;
    }

    public void treeEmpty(TreeViewer viewer) {
        if (this.emptyTreeListener != null) {
            this.emptyTreeListener.treeEmpty(viewer);
        }
    }

    public void notEmpty(TreeViewer viewer) {
        if (this.emptyTreeListener != null) {
            this.emptyTreeListener.notEmpty(viewer);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.ENABLED_MODEL_PROVIDERS")) {
            CommonViewerAdvisor.enableContentProviders((CommonViewer)this.getViewer(), CommonViewerAdvisor.getScope(this.getConfiguration()));
        }
    }

    public static final class NavigableCommonViewer
    extends CommonViewer
    implements AbstractTreeViewerAdvisor.ITreeViewerAccessor {
        private final IEmptyTreeListener listener;
        private boolean empty;

        private NavigableCommonViewer(String id, Composite parent, int style, IEmptyTreeListener listener) {
            super(id, parent, style);
            this.listener = listener;
        }

        protected ILabelProvider wrapLabelProvider(ILabelProvider provider) {
            return provider;
        }

        public void createChildren(TreeItem item) {
            super.createChildren((Widget)item);
        }

        public void openSelection() {
            this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
        }

        protected void internalRefresh(Object element, boolean updateLabels) {
            super.internalRefresh(element, updateLabels);
            this.checkForEmptyViewer();
        }

        protected void internalRemove(Object parent, Object[] elements) {
            super.internalRemove(parent, elements);
            if (parent == this.getInput()) {
                this.checkForEmptyViewer();
            }
        }

        protected void internalRemove(Object[] elements) {
            super.internalRemove(elements);
            this.checkForEmptyViewer();
        }

        protected void internalAdd(Widget widget, Object parentElement, Object[] childElements) {
            super.internalAdd(widget, parentElement, childElements);
            if (this.empty) {
                this.empty = false;
                this.listener.notEmpty((TreeViewer)this);
            }
        }

        protected void inputChanged(Object input, Object oldInput) {
            super.inputChanged(input, oldInput);
            this.checkForEmptyViewer();
        }

        private void checkForEmptyViewer() {
            Widget w;
            Item[] children;
            Object input = this.getInput();
            if (input != null && (children = this.getChildren(w = this.findItem(input))).length == 0) {
                if (!this.empty) {
                    this.empty = true;
                    this.listener.treeEmpty((TreeViewer)this);
                }
                return;
            }
            this.empty = false;
            if (this.listener != null) {
                this.listener.notEmpty((TreeViewer)this);
            }
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }
}

