/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.ui.SaveablePartAdapter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPageDialog;
import org.eclipse.team.ui.synchronize.ParticipantPageSaveablePart;

public final class ModelParticipantPageDialog
extends ParticipantPageDialog {
    private static final int DONE_ID = 1025;
    private static final int REPLACE_ID = 1026;
    private final ModelSynchronizeParticipant participant;
    private Button doneButton;
    private Button replaceButton;

    public ModelParticipantPageDialog(Shell shell, ModelSynchronizeParticipant participant, CompareConfiguration cc, ISynchronizePageConfiguration pc) {
        super(shell, ModelParticipantPageDialog.createInput(shell, participant, cc, pc), participant);
        this.participant = participant;
    }

    private static SaveablePartAdapter createInput(Shell shell, ModelSynchronizeParticipant participant, CompareConfiguration cc, ISynchronizePageConfiguration pc) {
        ParticipantPageSaveablePart input = new ParticipantPageSaveablePart(shell, cc, pc, participant);
        return input;
    }

    public boolean close() {
        boolean close = super.close();
        if (super.close()) {
            this.getInput().dispose();
        }
        return close;
    }

    protected boolean isOfferToRememberParticipant() {
        if (this.isReplace()) {
            return false;
        }
        return super.isOfferToRememberParticipant();
    }

    private boolean isReplace() {
        return ((IMergeContext)this.participant.getContext()).getMergeType() == 2;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        boolean isReplace = this.isReplace();
        isReplace = false;
        if (isReplace) {
            this.replaceButton = this.createButton(parent, 1026, TeamUIMessages.ModelParticipantPageDialog_0, true);
            this.replaceButton.setEnabled(true);
        }
        this.doneButton = this.createButton(parent, 1025, TeamUIMessages.ResourceMappingMergeOperation_2, !isReplace);
        this.doneButton.setEnabled(true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            super.buttonPressed(0);
        } else if (buttonId == 1026) {
            super.buttonPressed(0);
        } else {
            super.buttonPressed(buttonId);
        }
    }
}

