/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class ResourceModelContentProvider
extends SynchronizationContentProvider {
    private WorkbenchContentProvider provider;

    protected ITreeContentProvider getDelegateContentProvider() {
        if (this.provider == null) {
            this.provider = new WorkbenchContentProvider();
        }
        return this.provider;
    }

    protected String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    protected Object getModelRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean isInScope(ISynchronizationScope scope, Object parent, Object object) {
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if (resource == null) {
                return false;
            }
            if (!resource.isAccessible()) {
                return false;
            }
            if (scope.contains(resource)) {
                return true;
            }
            if (this.hasChildrenInScope(scope, object, resource)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasChildrenInScope(ISynchronizationScope scope, Object object, IResource resource) {
        if (!resource.isAccessible()) {
            return false;
        }
        IResource[] roots = scope.getRoots();
        int i = 0;
        while (i < roots.length) {
            IResource root = roots[i];
            if (resource.getFullPath().isPrefixOf(root.getFullPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void init(ICommonContentExtensionSite site) {
        super.init(site);
        TeamUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.provider.dispose();
        super.dispose();
        TeamUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.default_layout")) {
            this.refresh();
        }
        super.propertyChange(event);
    }

    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parent, Object[] children) {
        if (parent instanceof IResource) {
            IResource resource = (IResource)parent;
            if (!resource.isAccessible()) {
                return new Object[0];
            }
            Object[] allChildren = this.getLayout().equals("org.eclipse.team.ui.flay_layout") && resource.getType() == 4 ? this.getFlatChildren(context, resource) : (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 4 ? this.getCompressedChildren(context, (IProject)resource, children) : (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2 ? this.getCompressedChildren(context, (IFolder)resource, children) : this.getTreeChildren(context, resource, children)));
            return super.getChildrenInContext(context, parent, allChildren);
        }
        return super.getChildrenInContext(context, parent, children);
    }

    private Object[] getCompressedChildren(ISynchronizationContext context, IProject project, Object[] children) {
        HashSet<Object> result = new HashSet<Object>();
        IResourceDiffTree diffTree = context.getDiffTree();
        IDiff[] diffs = diffTree.getDiffs((IResource)project, 2);
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            IResource resource = diffTree.getResource(diff);
            if (resource.getType() == 1) {
                IContainer parent = resource.getParent();
                if (parent.getType() == 2) {
                    result.add(parent);
                } else {
                    result.add(resource);
                }
            } else if (resource.getType() == 2) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray();
    }

    private Object[] getCompressedChildren(ISynchronizationContext context, IFolder folder, Object[] children) {
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < children.length) {
            IResource resource;
            Object object = children[i];
            if (object instanceof IResource && (resource = (IResource)object).getType() == 1) {
                result.add(resource);
            }
            ++i;
        }
        IResourceDiffTree diffTree = context.getDiffTree();
        IDiff[] diffs = diffTree.getDiffs((IResource)folder, 1);
        int i2 = 0;
        while (i2 < diffs.length) {
            IDiff diff = diffs[i2];
            IResource resource = diffTree.getResource(diff);
            if (resource.getType() == 1) {
                result.add(resource);
            }
            ++i2;
        }
        return result.toArray();
    }

    private Object[] getFlatChildren(ISynchronizationContext context, IResource resource) {
        IResourceDiffTree diffTree = context.getDiffTree();
        IDiff[] diffs = diffTree.getDiffs(resource, 2);
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            result.add(diffTree.getResource(diff));
            ++i;
        }
        Object[] allChildren = result.toArray();
        return allChildren;
    }

    private Object[] getTreeChildren(ISynchronizationContext context, IResource resource, Object[] children) {
        HashSet<Object> result = new HashSet<Object>();
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            result.add(object);
            ++i;
        }
        IPath[] childPaths = context.getDiffTree().getChildren(resource.getFullPath());
        int i2 = 0;
        while (i2 < childPaths.length) {
            IPath path = childPaths[i2];
            IDiff delta = context.getDiffTree().getDiff(path);
            Object child = delta == null ? (path.segmentCount() == 1 ? ((IWorkspaceRoot)resource).getProject(path.lastSegment()) : ((IContainer)resource).getFolder((IPath)new Path(path.lastSegment()))) : context.getDiffTree().getResource(delta);
            if (this.isInScope(context.getScope(), resource, child)) {
                result.add(child);
            }
            ++i2;
        }
        Object[] allChildren = result.toArray(new Object[result.size()]);
        return allChildren;
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        ISynchronizationScope scope = context.getScope();
        ResourceMapping mapping = scope.getMapping(object);
        if (mapping != null) {
            return scope.getTraversals(mapping);
        }
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if (scope.contains(resource)) {
                ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
                ResourceTraversal[] traversals = scope.getTraversals();
                int i = 0;
                while (i < traversals.length) {
                    ResourceTraversal traversal = traversals[i];
                    if (traversal.contains(resource)) {
                        boolean include = false;
                        int depth = traversal.getDepth();
                        if (depth == 2) {
                            include = true;
                        } else {
                            IResource[] roots = traversal.getResources();
                            int j = 0;
                            while (j < roots.length) {
                                IResource root = roots[j];
                                if (root.equals((Object)resource)) {
                                    include = true;
                                    break;
                                }
                                if (root.getFullPath().equals((Object)resource.getFullPath().removeLastSegments(1)) && depth == 1) {
                                    include = true;
                                    depth = 0;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (include) {
                            result.add(new ResourceTraversal(new IResource[]{resource}, depth, 0));
                        }
                    }
                    ++i;
                }
                return result.toArray(new ResourceTraversal[result.size()]);
            }
            ResourceMapping[] mappings = scope.getMappings("org.eclipse.core.resources.modelProvider");
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            int i = 0;
            while (i < mappings.length) {
                ResourceMapping resourceMapping = mappings[i];
                if (resourceMapping.getModelObject() instanceof IResource) {
                    IResource root = (IResource)resourceMapping.getModelObject();
                    if (resource.getFullPath().isPrefixOf(root.getFullPath()) && (mapping = scope.getMapping((Object)root)) != null) {
                        ResourceTraversal[] traversals = scope.getTraversals(mapping);
                        result.addAll(Arrays.asList(traversals));
                    }
                }
                ++i;
            }
            return result.toArray(new ResourceTraversal[result.size()]);
        }
        return new ResourceTraversal[0];
    }

    protected boolean hasChildrenInContext(ISynchronizationContext context, Object element) {
        if (element instanceof IContainer) {
            IResourceDiffTree tree;
            IContainer container = (IContainer)element;
            if (context != null && (tree = context.getDiffTree()).getChildren(container.getFullPath()).length > 0) {
                return true;
            }
        }
        return false;
    }

    public void propertyChanged(IDiffTree tree, int property, final IPath[] paths) {
        Utils.syncExec(new Runnable(){

            public void run() {
                Object[] resources;
                ISynchronizationContext context = ResourceModelContentProvider.this.getContext();
                if (context != null && (resources = ResourceModelContentProvider.this.getResources(context, paths)).length > 0) {
                    ((AbstractTreeViewer)ResourceModelContentProvider.this.getViewer()).update(resources, null);
                }
            }
        }, (StructuredViewer)this.getViewer());
    }

    private IResource[] getResources(ISynchronizationContext context, IPath[] paths) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < paths.length) {
            IPath path = paths[i];
            IResource resource = this.getResource(context, path);
            if (resource != null) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private IResource getResource(ISynchronizationContext context, IPath path) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource != null) {
            return resource;
        }
        if (context != null) {
            IResourceDiffTree diffTree = context.getDiffTree();
            IDiff node = diffTree.getDiff(path);
            if (node != null) {
                return diffTree.getResource(node);
            }
            if (diffTree.getChildren(path).length > 0) {
                if (path.segmentCount() == 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                }
                if (path.segmentCount() > 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                }
            }
        }
        return null;
    }

    protected StructuredViewer getStructuredViewer() {
        return (StructuredViewer)this.getViewer();
    }

    private String getLayout() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.default_layout");
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            parent = this.getModelRoot();
        }
        return super.getChildren(parent);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ISynchronizationContext) {
            element = this.getModelRoot();
        }
        return super.hasChildren(element);
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            parent = this.getModelRoot();
        }
        return super.getElements(parent);
    }

    public Object getParent(Object element) {
        ISynchronizationContext context;
        if (element instanceof IProject && (context = this.getContext()) != null) {
            return context;
        }
        return super.getParent(element);
    }

    protected void refresh() {
        Utils.syncExec(new Runnable(){

            public void run() {
                TreeViewer treeViewer = (TreeViewer)ResourceModelContentProvider.this.getViewer();
                treeViewer.refresh();
            }
        }, this.getViewer().getControl());
    }
}

