/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.RefreshParticipantJob;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public class RefreshModelParticipantJob
extends RefreshParticipantJob {
    private final ResourceMapping[] mappings;

    public RefreshModelParticipantJob(ISynchronizeParticipant participant, String jobName, String taskName, ResourceMapping[] mappings, IRefreshSubscriberListener listener) {
        super(participant, jobName, taskName, listener);
        this.mappings = mappings;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRefresh(RefreshParticipantJob.IChangeDescription changeListener, IProgressMonitor monitor) throws CoreException {
        SynchronizationContext context = ((ModelSynchronizeParticipant)this.getParticipant()).getContext();
        try {
            context.getDiffTree().addDiffChangeListener((IDiffChangeListener)((ChangeDescription)changeListener));
            context.refresh(this.mappings, monitor);
            try {
                Platform.getJobManager().join((Object)context, monitor);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            context.getDiffTree().removeDiffChangeListener((IDiffChangeListener)((ChangeDescription)changeListener));
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        context.getDiffTree().removeDiffChangeListener((IDiffChangeListener)((ChangeDescription)changeListener));
    }

    protected int getChangeCount() {
        return ((ModelSynchronizeParticipant)this.getParticipant()).getContext().getDiffTree().size();
    }

    protected void handleProgressGroupSet(IProgressMonitor group) {
    }

    protected RefreshParticipantJob.IChangeDescription createChangeDescription() {
        return new ChangeDescription();
    }

    public boolean belongsTo(Object family) {
        if (family == (ModelSynchronizeParticipant)this.getParticipant()) {
            return true;
        }
        return super.belongsTo(family);
    }

    public class ChangeDescription
    implements RefreshParticipantJob.IChangeDescription,
    IDiffChangeListener {
        Map changes = new HashMap();

        public int getChangeCount() {
            return this.changes.size();
        }

        public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
            IDiff[] additions = event.getAdditions();
            int i = 0;
            while (i < additions.length) {
                IDiff node = additions[i];
                this.changes.put(node.getPath(), node);
                ++i;
            }
            IDiff[] changed = event.getChanges();
            int i2 = 0;
            while (i2 < changed.length) {
                IDiff node = changed[i2];
                this.changes.put(node.getPath(), node);
                ++i2;
            }
        }

        public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
        }
    }
}

