/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.internal.ui.OverlayIcon;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;

public abstract class AbstractSynchronizeLabelProvider
implements ILabelProvider {
    private Map fgImageCache;
    private Font busyFont;
    private CompareConfiguration compareConfig = new CompareConfiguration();

    public Image getImage(Object element) {
        Image base = this.getDelegateImage(element);
        if (this.isDecorationEnabled() && base != null) {
            Image decorateImage;
            base = decorateImage = this.decorateImage(base, element);
        }
        if (this.isIncludeOverlays() && base != null) {
            base = this.addOverlays(base, element);
        }
        return base;
    }

    protected Image decorateImage(Image base, Object element) {
        IDiff node = this.getDiff(element);
        Image decoratedImage = this.getCompareImage(base, node);
        return decoratedImage;
    }

    protected Image getDelegateImage(Object element) {
        ILabelProvider modelLabelProvider = this.getDelegateLabelProvider();
        Image base = modelLabelProvider.getImage(element);
        return base;
    }

    private Image getCompareImage(Image base, IDiff node) {
        int compareKind = 0;
        if (node != null) {
            switch (node.getKind()) {
                case 1: {
                    compareKind = 1;
                    break;
                }
                case 2: {
                    compareKind = 2;
                    break;
                }
                case 4: {
                    compareKind = 3;
                }
            }
            if (node instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)node;
                switch (twd.getDirection()) {
                    case 256: {
                        compareKind |= 8;
                        break;
                    }
                    case 512: {
                        compareKind |= 4;
                        break;
                    }
                    case 768: {
                        compareKind |= 4;
                        compareKind |= 8;
                    }
                }
            }
        }
        return this.compareConfig.getImage(base, compareKind);
    }

    public String getText(Object element) {
        String base = this.getDelegateText(element);
        if (this.isSyncInfoInTextEnabled()) {
            return this.decorateText(base, element);
        }
        return base;
    }

    protected String getDelegateText(Object element) {
        ILabelProvider modelLabelProvider = this.getDelegateLabelProvider();
        String base = modelLabelProvider.getText(element);
        if ((base == null || base.length() == 0) && element instanceof ModelProvider) {
            ModelProvider provider = (ModelProvider)element;
            base = Utils.getLabel(provider);
        }
        return base;
    }

    protected String decorateText(String base, Object element) {
        IDiff node = this.getDiff(element);
        if (node != null && node.getKind() != 0) {
            String syncKindString = node.toDiffString();
            return NLS.bind((String)TeamUIMessages.AbstractSynchronizationLabelProvider_0, (Object[])new String[]{base, syncKindString});
        }
        return base;
    }

    public void addListener(ILabelProviderListener listener) {
        this.getDelegateLabelProvider().addListener(listener);
    }

    public void dispose() {
        this.compareConfig.dispose();
        if (this.busyFont != null) {
            this.busyFont.dispose();
        }
        if (this.fgImageCache != null) {
            Iterator it = this.fgImageCache.values().iterator();
            while (it.hasNext()) {
                Image element = (Image)it.next();
                element.dispose();
            }
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.getDelegateLabelProvider().isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.getDelegateLabelProvider().removeListener(listener);
    }

    protected boolean isSyncInfoInTextEnabled() {
        return this.isDecorationEnabled() && TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.view_syncinfo_in_label");
    }

    protected abstract ILabelProvider getDelegateLabelProvider();

    protected abstract boolean isDecorationEnabled();

    protected IDiff getDiff(Object element) {
        return null;
    }

    private Image addOverlays(Image base, Object element) {
        int severity;
        if (!this.isIncludeOverlays()) {
            return base;
        }
        ArrayList<ImageDescriptor> overlays = new ArrayList<ImageDescriptor>();
        ArrayList<Integer> locations = new ArrayList<Integer>();
        if (this.isBusy(element)) {
            overlays.add(TeamUIPlugin.getImageDescriptor("ovr/waiting_ovr.gif"));
            locations.add(new Integer(0));
        }
        if (!this.isConflicting(element) && this.hasDecendantConflicts(element)) {
            overlays.add(TeamUIPlugin.getImageDescriptor("ovr/confchg_ov.gif"));
            locations.add(new Integer(3));
        }
        if ((severity = this.getMarkerSeverity(element)) == 2) {
            overlays.add(TeamUIPlugin.getImageDescriptor("ovr/error_co.gif"));
            locations.add(new Integer(2));
        } else if (severity == 1) {
            overlays.add(TeamUIPlugin.getImageDescriptor("ovr/warning_co.gif"));
            locations.add(new Integer(2));
        }
        if (!overlays.isEmpty()) {
            Image conflictDecoratedImage;
            ImageDescriptor[] overlayImages = overlays.toArray(new ImageDescriptor[overlays.size()]);
            int[] locationInts = new int[locations.size()];
            int i = 0;
            while (i < locations.size()) {
                locationInts[i] = (Integer)locations.get(i);
                ++i;
            }
            OverlayIcon overlay = new OverlayIcon(base, overlayImages, locationInts, new Point(base.getBounds().width, base.getBounds().height));
            if (this.fgImageCache == null) {
                this.fgImageCache = new HashMap(10);
            }
            if ((conflictDecoratedImage = (Image)this.fgImageCache.get((Object)overlay)) == null) {
                conflictDecoratedImage = overlay.createImage();
                this.fgImageCache.put(overlay, conflictDecoratedImage);
            }
            return conflictDecoratedImage;
        }
        return base;
    }

    protected boolean isIncludeOverlays() {
        return false;
    }

    protected int getMarkerSeverity(Object element) {
        ResourceMapping mapping = Utils.getResourceMapping(element);
        int result = -1;
        if (mapping != null) {
            try {
                IMarker[] markers = mapping.findMarkers("org.eclipse.core.resources.problemmarker", true, null);
                int i = 0;
                while (i < markers.length) {
                    IMarker marker = markers[i];
                    Integer severity = (Integer)marker.getAttribute("severity");
                    if (severity != null) {
                        if (severity == 2) {
                            return 2;
                        }
                        if (severity == 1) {
                            result = 1;
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    protected boolean hasDecendantConflicts(Object element) {
        return false;
    }

    private boolean isConflicting(Object element) {
        IDiff node = this.getDiff(element);
        if (node != null && node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            return twd.getDirection() == 768;
        }
        return false;
    }

    protected boolean isBusy(Object element) {
        return false;
    }

    public Font getFont(Object element) {
        if (this.isBusy(element)) {
            if (this.busyFont == null) {
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] data = defaultFont.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(2);
                    ++i;
                }
                this.busyFont = new Font((Device)TeamUIPlugin.getStandardDisplay(), data);
            }
            return this.busyFont;
        }
        return null;
    }
}

