/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.registry.IBundleFolder;
import org.eclipse.pde.internal.runtime.registry.ParentAdapter;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserContentProvider;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserLabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class RegistryBrowser
extends ViewPart
implements BundleListener,
IRegistryChangeListener {
    public static final String SHOW_RUNNING_PLUGINS = "RegistryView.showRunning.label";
    private TreeViewer treeViewer;
    private IMemento memento;
    private Action refreshAction;
    private Action showPluginsAction;
    private Action collapseAllAction;
    private Action removeAction;
    private Action addAction;
    private DrillDownAdapter drillDownAdapter;
    private Composite mainView;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"REGISTRYVIEW") : memento;
        this.initializeMemento();
    }

    private void initializeMemento() {
        if (this.memento.getString(SHOW_RUNNING_PLUGINS) == null) {
            this.memento.putString(SHOW_RUNNING_PLUGINS, "false");
        }
    }

    public void dispose() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        PDERuntimePlugin.getDefault().getBundleContext().removeBundleListener((BundleListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.makeActions();
        this.createTreeViewer(composite);
        this.fillToolBar();
        this.treeViewer.refresh();
        this.setContentDescription(((RegistryBrowserContentProvider)this.treeViewer.getContentProvider()).getTitleSummary());
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
        PDERuntimePlugin.getDefault().getBundleContext().addBundleListener((BundleListener)this);
    }

    private void createTreeViewer(Composite parent) {
        this.mainView = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.mainView.setLayout((Layout)layout);
        this.mainView.setLayoutData((Object)new GridData(1808));
        Tree tree = new Tree(this.mainView, 0x800002);
        GridData gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(tree);
        boolean showRunning = this.memento.getString(SHOW_RUNNING_PLUGINS).equals("true");
        this.treeViewer.setContentProvider((IContentProvider)new RegistryBrowserContentProvider(this.treeViewer, showRunning));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RegistryBrowserLabelProvider(this.treeViewer));
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PluginObjectAdapter) {
                    e1 = ((PluginObjectAdapter)((Object)e1)).getObject();
                }
                if (e2 instanceof PluginObjectAdapter) {
                    e2 = ((PluginObjectAdapter)((Object)e2)).getObject();
                }
                if (e1 instanceof IBundleFolder && e2 instanceof IBundleFolder) {
                    return ((IBundleFolder)e1).getFolderId() - ((IBundleFolder)e2).getFolderId();
                }
                if (e1 instanceof Bundle && e2 instanceof Bundle) {
                    String id1 = ((Bundle)e1).getSymbolicName();
                    String id2 = ((Bundle)e2).getSymbolicName();
                    if (id2.indexOf(id1) == 0) {
                        return -1;
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        Bundle[] bundles = PDERuntimePlugin.getDefault().getBundleContext().getBundles();
        this.treeViewer.setInput((Object)new PluginObjectAdapter(bundles));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.treeViewer.getControl(), "org.eclipse.pde.doc.user.registry_view");
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                RegistryBrowser.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.setRemoveAllWhenShown(true);
        popupMenuManager.addMenuListener(listener);
        Menu menu = popupMenuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    private void fillToolBar() {
        this.drillDownAdapter = new RegistryDrillDownAdapter(this.treeViewer);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager mng = bars.getToolBarManager();
        this.drillDownAdapter.addNavigationActions(mng);
        mng.add((IAction)this.refreshAction);
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.collapseAllAction);
        IMenuManager mgr = bars.getMenuManager();
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.showPluginsAction);
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        Tree tree = this.getUndisposedTree();
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showPluginsAction);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void saveState(IMemento memento) {
        if (memento == null || this.memento == null || this.treeViewer == null) {
            return;
        }
        boolean showRunning = ((RegistryBrowserContentProvider)this.treeViewer.getContentProvider()).isShowRunning();
        if (showRunning) {
            this.memento.putString(SHOW_RUNNING_PLUGINS, Boolean.toString(true));
        } else {
            this.memento.putString(SHOW_RUNNING_PLUGINS, Boolean.toString(false));
        }
        memento.putMemento(this.memento);
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void bundleChanged(BundleEvent event) {
        Tree tree = this.getUndisposedTree();
        if (tree == null) {
            return;
        }
        final RegistryBrowserContentProvider provider = (RegistryBrowserContentProvider)this.treeViewer.getContentProvider();
        final Bundle eventBundle = Platform.getBundle((String)event.getBundle().getSymbolicName());
        if (eventBundle == null) {
            return;
        }
        final PluginObjectAdapter adapter = new PluginObjectAdapter(eventBundle);
        tree.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Tree tree = RegistryBrowser.this.getUndisposedTree();
                if (tree == null) {
                    return;
                }
                TreeItem[] items = RegistryBrowser.this.treeViewer.getTree().getItems();
                if (items != null) {
                    int i = 0;
                    while (i < items.length) {
                        Bundle bundle;
                        Object object = items[i].getData();
                        if (object instanceof PluginObjectAdapter) {
                            object = ((PluginObjectAdapter)((Object)object)).getObject();
                        }
                        if (object != null && object instanceof Bundle && (bundle = (Bundle)object).equals(eventBundle)) {
                            RegistryBrowser.this.treeViewer.update((Object)items[i], null);
                            RegistryBrowser.this.updateTitle();
                            return;
                        }
                        ++i;
                    }
                }
                if (provider.isShowRunning() && eventBundle.getState() != 32) {
                    return;
                }
                RegistryBrowser.this.treeViewer.add(RegistryBrowser.this.treeViewer.getInput(), (Object)adapter);
                RegistryBrowser.this.updateTitle();
            }
        });
    }

    public void registryChanged(IRegistryChangeEvent event) {
        Tree tree = this.getUndisposedTree();
        if (tree == null) {
            return;
        }
        final IExtensionDelta[] deltas = event.getExtensionDeltas();
        tree.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (RegistryBrowser.this.getUndisposedTree() == null) {
                    return;
                }
                int i = 0;
                while (i < deltas.length) {
                    RegistryBrowser.this.handleDelta(deltas[i]);
                    ++i;
                }
            }
        });
    }

    private void handleDelta(IExtensionDelta delta) {
        IExtension ext = delta.getExtension();
        IExtensionPoint extPoint = delta.getExtensionPoint();
        if (delta.getKind() == 1) {
            this.addToTree(ext);
            this.addToTree(extPoint);
        } else if (delta.getKind() == 2) {
            this.removeFromTree(ext);
            this.removeFromTree(extPoint);
        }
    }

    private void addToTree(Object object) {
        String namespace = this.getNamespaceIdentifier(object);
        if (namespace == null) {
            return;
        }
        TreeItem[] bundles = this.treeViewer.getTree().getItems();
        int i = 0;
        while (i < bundles.length) {
            Object data = bundles[i].getData();
            Object adapted = null;
            if (data instanceof PluginObjectAdapter) {
                adapted = ((PluginObjectAdapter)((Object)data)).getObject();
            }
            if (adapted instanceof Bundle && ((Bundle)adapted).getSymbolicName().equals(namespace)) {
                this.treeViewer.refresh(data);
                return;
            }
            ++i;
        }
    }

    private String getNamespaceIdentifier(Object object) {
        if (object instanceof IExtensionPoint) {
            return ((IExtensionPoint)object).getNamespaceIdentifier();
        }
        if (object instanceof IExtension) {
            return ((IExtension)object).getContributor().getName();
        }
        return null;
    }

    private boolean correctFolder(IBundleFolder folder, Object child) {
        if (folder == null) {
            return false;
        }
        if (child instanceof IExtensionPoint) {
            return folder.getFolderId() == 2;
        }
        if (child instanceof IExtension) {
            return folder.getFolderId() == 1;
        }
        return false;
    }

    private void removeFromTree(Object object) {
        String namespace = this.getNamespaceIdentifier(object);
        if (namespace == null) {
            return;
        }
        TreeItem[] bundles = this.treeViewer.getTree().getItems();
        int i = 0;
        while (i < bundles.length) {
            Object data = bundles[i].getData();
            Object adapted = null;
            if (data instanceof PluginObjectAdapter) {
                adapted = ((PluginObjectAdapter)((Object)data)).getObject();
            }
            if (adapted instanceof Bundle && ((Bundle)adapted).getSymbolicName().equals(namespace)) {
                bundles[i].getItems();
                this.treeViewer.refresh(data);
                return;
            }
            ++i;
        }
    }

    public void makeActions() {
        this.refreshAction = new Action("refresh"){

            public void run() {
                BusyIndicator.showWhile((Display)RegistryBrowser.this.treeViewer.getTree().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RegistryBrowser.access$2(5.access$0(this.this$1)).refresh();
                    }
                });
            }

            static /* synthetic */ RegistryBrowser access$0(5 var0) {
                return var0.RegistryBrowser.this;
            }
        };
        this.refreshAction.setText(PDERuntimeMessages.RegistryView_refresh_label);
        this.refreshAction.setToolTipText(PDERuntimeMessages.RegistryView_refresh_tooltip);
        this.refreshAction.setImageDescriptor(PDERuntimePluginImages.DESC_REFRESH);
        this.refreshAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_REFRESH_DISABLED);
        this.showPluginsAction = new Action(PDERuntimeMessages.RegistryView_showRunning_label){

            public void run() {
                RegistryBrowserContentProvider cp = (RegistryBrowserContentProvider)RegistryBrowser.this.treeViewer.getContentProvider();
                cp.setShowRunning(RegistryBrowser.this.showPluginsAction.isChecked());
                RegistryBrowser.this.treeViewer.refresh();
                RegistryBrowser.this.updateTitle();
            }
        };
        this.showPluginsAction.setChecked(this.memento.getString(SHOW_RUNNING_PLUGINS).equals("true"));
        this.removeAction = new Action("Remove"){

            public void run() {
                Tree tree = RegistryBrowser.this.getUndisposedTree();
                if (tree == null) {
                    return;
                }
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                Object token = ((ExtensionRegistry)registry).getTemporaryUserToken();
                TreeItem[] selection = tree.getSelection();
                int i = 0;
                while (i < selection.length) {
                    Object obj = selection[i].getData();
                    if (obj instanceof ParentAdapter) {
                        obj = ((ParentAdapter)((Object)obj)).getObject();
                    }
                    if (obj instanceof IExtensionPoint) {
                        registry.removeExtensionPoint((IExtensionPoint)obj, token);
                    } else if (obj instanceof IExtension) {
                        registry.removeExtension((IExtension)obj, token);
                    }
                    ++i;
                }
            }
        };
        this.addAction = new Action("Add..."){

            public void run() {
                Tree tree = RegistryBrowser.this.getUndisposedTree();
                if (tree == null) {
                    return;
                }
                FileDialog dialog = new FileDialog(RegistryBrowser.this.getSite().getShell(), 4096);
                String input = dialog.open();
                if (input == null) {
                    return;
                }
                Object selection = tree.getSelection()[0].getData();
                if (selection instanceof PluginObjectAdapter) {
                    selection = ((PluginObjectAdapter)((Object)selection)).getObject();
                }
                if (!(selection instanceof Bundle)) {
                    return;
                }
                IContributor contributor = ContributorFactoryOSGi.createContributor((Bundle)((Bundle)selection));
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                Object token = ((ExtensionRegistry)registry).getTemporaryUserToken();
                try {
                    registry.addContribution((InputStream)new FileInputStream(input), contributor, false, null, null, token);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        };
        this.collapseAllAction = new Action("collapseAll"){

            public void run() {
                RegistryBrowser.this.treeViewer.collapseAll();
            }
        };
        this.collapseAllAction.setText(PDERuntimeMessages.RegistryView_collapseAll_label);
        this.collapseAllAction.setImageDescriptor(PDERuntimePluginImages.DESC_COLLAPSE_ALL);
        this.collapseAllAction.setToolTipText(PDERuntimeMessages.RegistryView_collapseAll_tooltip);
    }

    public void updateTitle() {
        if (this.treeViewer == null || this.treeViewer.getContentProvider() == null) {
            return;
        }
        this.setContentDescription(((RegistryBrowserContentProvider)this.treeViewer.getContentProvider()).getTitleSummary());
    }

    private Tree getUndisposedTree() {
        if (this.treeViewer == null || this.treeViewer.getTree() == null || this.treeViewer.getTree().isDisposed()) {
            return null;
        }
        return this.treeViewer.getTree();
    }

    class RegistryDrillDownAdapter
    extends DrillDownAdapter {
        public RegistryDrillDownAdapter(TreeViewer tree) {
            super(tree);
        }

        public void goInto() {
            super.goInto();
            RegistryBrowser.this.showPluginsAction.setEnabled(!this.canGoHome());
        }

        public void goBack() {
            super.goBack();
            RegistryBrowser.this.showPluginsAction.setEnabled(!this.canGoHome());
        }

        public void goHome() {
            super.goHome();
            RegistryBrowser.this.showPluginsAction.setEnabled(!this.canGoHome());
        }

        public void goInto(Object newInput) {
            super.goInto(newInput);
            RegistryBrowser.this.showPluginsAction.setEnabled(!this.canGoHome());
        }
    }
}

