/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import java.util.HashSet;
import org.eclipse.core.internal.resources.mapping.SimpleResourceMapping;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ResourceModelProvider
extends ModelProvider {
    private IResource[] getChildren(IContainer container, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (context instanceof RemoteResourceMappingContext) {
            HashSet<IResource> result = new HashSet<IResource>();
            RemoteResourceMappingContext rrmc = (RemoteResourceMappingContext)context;
            IResource[] remoteMembers = rrmc.fetchMembers(container, monitor);
            int i = 0;
            while (i < remoteMembers.length) {
                IResource resource = remoteMembers[i];
                result.add(resource);
                ++i;
            }
            IResource[] localMembers = container.members();
            int i2 = 0;
            while (i2 < localMembers.length) {
                IResource resource = localMembers[i2];
                result.add(resource);
                ++i2;
            }
        }
        return container.members();
    }

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        return new ResourceMapping[]{new SimpleResourceMapping(resource)};
    }

    public ResourceMapping[] getMappings(ResourceTraversal[] traversals, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < traversals.length) {
            ResourceTraversal traversal = traversals[i];
            IResource[] resources = traversal.getResources();
            int depth = traversal.getDepth();
            int j = 0;
            while (j < resources.length) {
                IResource resource = resources[j];
                switch (depth) {
                    case 2: {
                        result.add(resource);
                        break;
                    }
                    case 1: {
                        if (resource.getType() == 1) {
                            result.add(resource);
                            break;
                        }
                        IResource[] children = this.getChildren((IContainer)resource, context, monitor);
                        int k = 0;
                        while (k < children.length) {
                            IResource child = children[k];
                            if (child.getType() == 1) {
                                result.add(child);
                            }
                            ++k;
                        }
                        break;
                    }
                    case 0: {
                        if (resource.getType() != 1) break;
                        result.add(resource);
                    }
                }
                ++j;
            }
            ++i;
        }
        return this.getMappings(result.toArray(new IResource[result.size()]), context, monitor);
    }
}

