/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.contentassist.CurrentFrameContext;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class ExpressionInputDialog
extends TrayDialog {
    protected IJavaVariable fVariable;
    protected String fResult = null;
    protected Composite fInputArea;
    protected Label fEvaluateLabel;
    protected JDISourceViewer fSourceViewer;
    protected IContentAssistProcessor fCompletionProcessor;
    protected IDocumentListener fDocumentListener;
    protected IHandlerService fService;
    protected IHandlerActivation fActivation;
    protected Text fErrorText;
    static /* synthetic */ Class class$0;

    protected ExpressionInputDialog(Shell parentShell, IJavaVariable variable) {
        super(parentShell);
        this.setShellStyle(1232);
        this.fVariable = variable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createInputArea(composite);
        this.createErrorText(composite);
        this.populateInputArea();
        return composite;
    }

    protected void createErrorText(Composite parent) {
        this.fErrorText = new Text(parent, 8);
        this.fErrorText.setLayoutData((Object)new GridData(768));
        this.fErrorText.setBackground(this.fErrorText.getDisplay().getSystemColor(22));
        this.fErrorText.setFont(parent.getFont());
    }

    protected void createInputArea(Composite parent) {
        this.fInputArea = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        this.fInputArea.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fInputArea.setLayout((Layout)layout);
        Dialog.applyDialogFont((Control)this.fInputArea);
    }

    protected void populateInputArea() {
        this.createSourceViewer();
    }

    protected void createSourceViewer() {
        Composite parent = this.fInputArea;
        String name = ActionMessages.ExpressionInputDialog_3;
        try {
            name = this.fVariable.getName();
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fEvaluateLabel = new Label(parent, 64);
        this.fEvaluateLabel.setText(MessageFormat.format(ActionMessages.ExpressionInputDialog_0, name));
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.fEvaluateLabel.setLayoutData((Object)data);
        this.fEvaluateLabel.setFont(parent.getFont());
        this.fSourceViewer = new JDISourceViewer(parent, null, 2816);
        this.fSourceViewer.setInput(parent);
        this.configureSourceViewer();
        this.fSourceViewer.doOperation(7);
    }

    private void configureSourceViewer() {
        JavaTextTools tools = JDIDebugUIPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fSourceViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(){

            public IContentAssistProcessor getContentAssistantProcessor() {
                return ExpressionInputDialog.this.getCompletionProcessor();
            }
        });
        this.fSourceViewer.setEditable(true);
        this.fSourceViewer.setDocument((IDocument)document);
        TextViewerUndoManager undoManager = new TextViewerUndoManager(10);
        this.fSourceViewer.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.fSourceViewer);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fSourceViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        gd = (GridData)this.fSourceViewer.getControl().getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        document.set(this.getInitialText(this.fVariable));
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                ExpressionInputDialog.this.refreshValidState();
            }
        };
        this.fSourceViewer.getDocument().addDocumentListener(this.fDocumentListener);
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                ExpressionInputDialog.this.fSourceViewer.doOperation(13);
                return null;
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fService = (IHandlerService)workbench.getAdapter((Class)clazz);
        this.fActivation = this.fService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler);
    }

    protected String getInitialText(IJavaVariable variable) {
        try {
            IValue value;
            String signature = variable.getSignature();
            if (signature.equals("Ljava/lang/String;") && !((value = variable.getValue()) instanceof JDINullValue)) {
                String currentValue = value.getValueString();
                StringBuffer buffer = new StringBuffer(currentValue.length());
                buffer.append('\"');
                char[] chars = currentValue.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    char c = chars[i];
                    if (c == '\b') {
                        buffer.append("\\b");
                    } else if (c == '\t') {
                        buffer.append("\\t");
                    } else if (c == '\n') {
                        buffer.append("\\n");
                    } else if (c == '\f') {
                        buffer.append("\\f");
                    } else if (c == '\r') {
                        buffer.append("\\r");
                    } else if (c == '\"') {
                        buffer.append("\\\"");
                    } else if (c == '\'') {
                        buffer.append("\\'");
                    } else if (c == '\\') {
                        buffer.append("\\\\");
                    } else {
                        buffer.append(c);
                    }
                    ++i;
                }
                buffer.append('\"');
                return buffer.toString();
            }
        }
        catch (DebugException debugException) {}
        return null;
    }

    protected IContentAssistProcessor getCompletionProcessor() {
        if (this.fCompletionProcessor == null) {
            this.fCompletionProcessor = new JavaDebugContentAssistProcessor(new CurrentFrameContext());
        }
        return this.fCompletionProcessor;
    }

    protected void refreshValidState() {
        boolean valid;
        String errorMessage = null;
        String text = this.fSourceViewer.getDocument().get();
        boolean bl = valid = text != null && text.trim().length() > 0;
        if (!valid) {
            errorMessage = ActionMessages.ExpressionInputDialog_1;
        }
        this.setErrorMessage(errorMessage);
    }

    protected void setErrorMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.fErrorText.setText(message);
        this.getButton(0).setEnabled(message.length() == 0);
    }

    protected void okPressed() {
        this.fResult = this.getText();
        this.dispose();
        super.okPressed();
    }

    protected String getText() {
        return this.fSourceViewer.getDocument().get();
    }

    protected void dispose() {
        this.disposeSourceViewer();
    }

    protected void disposeSourceViewer() {
        if (this.fActivation != null) {
            this.fService.deactivateHandler(this.fActivation);
        }
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fSourceViewer.getTextWidget().dispose();
            this.fSourceViewer.dispose();
            this.fSourceViewer = null;
        }
        if (this.fEvaluateLabel != null) {
            this.fEvaluateLabel.dispose();
            this.fEvaluateLabel = null;
        }
        this.fDocumentListener = null;
        this.fCompletionProcessor = null;
    }

    public String getResult() {
        return this.fResult;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ActionMessages.ExpressionInputDialog_2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.refreshValidState();
    }

    public boolean close() {
        this.dispose();
        return super.close();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected String getDialogSettingsSectionName() {
        return "EXPRESSION_INPUT_DIALOG";
    }
}

