/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.text.MessageFormat;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.JREsLabelProvider;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class JREsEnvironmentLabelProvider
extends JREsLabelProvider
implements IFontProvider {
    private IExecutionEnvironmentProvider fProvider;
    private Font fFont = null;

    public JREsEnvironmentLabelProvider(IExecutionEnvironmentProvider provider) {
        this.fProvider = provider;
    }

    public void dispose() {
        if (this.fFont != null) {
            this.fFont.dispose();
        }
        super.dispose();
    }

    public String getText(Object element) {
        String label = super.getText(element);
        if (this.isStrictlyCompatible(element)) {
            label = MessageFormat.format(JREMessages.JREsEnvironmentLabelProvider_0, label, JREMessages.JREsEnvironmentLabelProvider_1);
        }
        return label;
    }

    private boolean isStrictlyCompatible(Object element) {
        IExecutionEnvironment environment = this.fProvider.getEnvironment();
        if (environment != null && element instanceof IVMInstall) {
            return environment.isStrictlyCompatible((IVMInstall)element);
        }
        return false;
    }

    public Font getFont(Object element) {
        if (this.isStrictlyCompatible(element)) {
            if (this.fFont == null) {
                Font dialogFont = JFaceResources.getDialogFont();
                FontData[] fontData = dialogFont.getFontData();
                int i = 0;
                while (i < fontData.length) {
                    FontData data = fontData[i];
                    data.setStyle(1);
                    ++i;
                }
                Display display = JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay();
                this.fFont = new Font((Device)display, fontData);
            }
            return this.fFont;
        }
        return null;
    }

    public static interface IExecutionEnvironmentProvider {
        public IExecutionEnvironment getEnvironment();
    }
}

