/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQueryFactory;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePreferences;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringContributionManager;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;

public class RefactoringCore {
    public static final String ID_PLUGIN = "org.eclipse.ltk.core.refactoring";
    private static IValidationCheckResultQueryFactory fQueryFactory = new DefaultQueryFactory();

    private RefactoringCore() {
    }

    public static IUndoManager getUndoManager() {
        return RefactoringCorePlugin.getUndoManager();
    }

    public static IRefactoringHistoryService getHistoryService() {
        return RefactoringHistoryService.getInstance();
    }

    public static RefactoringContribution getRefactoringContribution(String id) {
        return RefactoringContributionManager.getInstance().getRefactoringContribution(id);
    }

    public static int getConditionCheckingFailedSeverity() {
        return RefactoringCorePreferences.getStopSeverity();
    }

    public static IValidationCheckResultQueryFactory getQueryFactory() {
        return fQueryFactory;
    }

    public static void internalSetQueryFactory(IValidationCheckResultQueryFactory factory) {
        fQueryFactory = factory == null ? new DefaultQueryFactory() : factory;
    }

    private static class NullQuery
    implements IValidationCheckResultQuery {
        NullQuery() {
        }

        public boolean proceed(RefactoringStatus status) {
            return true;
        }

        public void stopped(RefactoringStatus status) {
        }
    }

    private static class DefaultQueryFactory
    implements IValidationCheckResultQueryFactory {
        DefaultQueryFactory() {
        }

        public IValidationCheckResultQuery create(IAdaptable context) {
            return new NullQuery();
        }
    }
}

