/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryListener;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.ParticipantDescriptor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringUndoContext;
import org.eclipse.ltk.internal.core.refactoring.UndoManager2;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringContributionManager;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistorySerializer;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.osgi.framework.BundleContext;

public class RefactoringCorePlugin
extends Plugin {
    private static RefactoringCorePlugin fgDefault;
    private static IUndoManager fgUndoManager;
    private static IUndoContext fRefactoringUndoContext;
    private IRefactoringHistoryListener fRefactoringHistoryListener = null;
    static /* synthetic */ Class class$0;

    static {
        fgUndoManager = null;
    }

    public RefactoringCorePlugin() {
        fgDefault = this;
    }

    public static RefactoringCorePlugin getDefault() {
        return fgDefault;
    }

    public static String getPluginId() {
        return "org.eclipse.ltk.core.refactoring";
    }

    public static IUndoContext getUndoContext() {
        if (fRefactoringUndoContext == null) {
            IUndoContext workspaceContext;
            fRefactoringUndoContext = new RefactoringUndoContext();
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((workspaceContext = (IUndoContext)iWorkspace.getAdapter((Class)clazz)) instanceof ObjectUndoContext) {
                ((ObjectUndoContext)workspaceContext).addMatch(fRefactoringUndoContext);
            }
            IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
            operationHistory.setLimit(fRefactoringUndoContext, 5);
        }
        return fRefactoringUndoContext;
    }

    public static void log(IStatus status) {
        RefactoringCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, RefactoringCorePlugin.getPluginId(), 10000, RefactoringCoreMessages.RefactoringCorePlugin_internal_error, t);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public static void logRemovedListener(Throwable t) {
        Status status = new Status(4, RefactoringCorePlugin.getPluginId(), 10000, RefactoringCoreMessages.RefactoringCorePlugin_listener_removed, t);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public static void logRemovedParticipant(ParticipantDescriptor descriptor, Throwable t) {
        Status status = new Status(4, RefactoringCorePlugin.getPluginId(), 10000, Messages.format(RefactoringCoreMessages.RefactoringCorePlugin_participant_removed, descriptor.getId()), t);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public static void logErrorMessage(String message) {
        RefactoringCorePlugin.log((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10000, message, null));
    }

    public static IUndoManager getUndoManager() {
        if (fgUndoManager == null) {
            fgUndoManager = RefactoringCorePlugin.createUndoManager();
        }
        return fgUndoManager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        RefactoringContributionManager.getInstance().connect();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        service.connect();
        this.fRefactoringHistoryListener = new RefactoringHistorySerializer();
        service.addHistoryListener(this.fRefactoringHistoryListener);
    }

    public void stop(BundleContext context) throws Exception {
        if (fRefactoringUndoContext != null) {
            IUndoContext workspaceContext;
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((workspaceContext = (IUndoContext)iWorkspace.getAdapter((Class)clazz)) instanceof ObjectUndoContext) {
                ((ObjectUndoContext)workspaceContext).removeMatch(fRefactoringUndoContext);
            }
        }
        if (fgUndoManager != null) {
            fgUndoManager.shutdown();
        }
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        service.disconnect();
        if (this.fRefactoringHistoryListener != null) {
            service.removeHistoryListener(this.fRefactoringHistoryListener);
        }
        RefactoringContributionManager.getInstance().disconnect();
        super.stop(context);
    }

    private static IUndoManager createUndoManager() {
        return new UndoManager2();
    }
}

