/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryListener;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistoryEvent;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;

public final class RefactoringHistorySerializer
implements IRefactoringHistoryListener {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void historyNotification(RefactoringHistoryEvent event) {
        RefactoringDescriptorProxy proxy;
        long stamp;
        Assert.isNotNull((Object)event);
        int type = event.getEventType();
        if (type != 3 && type != 1) {
            if (type != 2) return;
        }
        if ((stamp = (proxy = event.getDescriptor()).getTimeStamp()) < 0L) return;
        String name = proxy.getProject();
        IFileStore store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(".refactorings");
        if (name != null && !"".equals(name)) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!project.isAccessible()) return;
            if (RefactoringHistoryService.getInstance().hasSharedRefactoringHistory(project)) {
                URI uri = project.getLocationURI();
                if (uri == null) return;
                try {
                    try {
                        this.processHistoryNotification(EFS.getStore((URI)uri).getChild(".refactorings"), event, name);
                    }
                    catch (CoreException exception) {
                        RefactoringCorePlugin.log(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    try {
                        project.refreshLocal(2, null);
                        throw throwable;
                    }
                    catch (CoreException exception) {
                        RefactoringCorePlugin.log(exception);
                    }
                    throw throwable;
                }
                {
                    Object var11_14 = null;
                    try {}
                    catch (CoreException exception) {
                        RefactoringCorePlugin.log(exception);
                        return;
                    }
                    project.refreshLocal(2, null);
                    return;
                }
            }
            try {
                this.processHistoryNotification(store.getChild(name), event, name);
                return;
            }
            catch (CoreException exception) {
                RefactoringCorePlugin.log(exception);
                return;
            }
        }
        try {
            this.processHistoryNotification(store.getChild(".workspace"), event, name);
            return;
        }
        catch (CoreException exception) {
            RefactoringCorePlugin.log(exception);
        }
    }

    private void processHistoryNotification(IFileStore store, RefactoringHistoryEvent event, String name) throws CoreException {
        RefactoringDescriptorProxy proxy = event.getDescriptor();
        int type = event.getEventType();
        RefactoringHistoryManager manager = new RefactoringHistoryManager(store, name);
        if (type == 1) {
            manager.addRefactoringDescriptor(proxy.requestDescriptor((IProgressMonitor)new NullProgressMonitor()), (IProgressMonitor)new NullProgressMonitor());
        } else if (type == 2 || type == 3) {
            manager.removeRefactoringDescriptor(proxy.getTimeStamp(), (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

