/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.DocumentCharSequence;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;
import org.eclipse.search.internal.core.text.FilesOfScopeCalculator;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextSearchVisitor {
    private final TextSearchRequestor fCollector;
    private final Matcher fMatcher;
    private Map fDocumentsInEditors;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private long fLastUpdateTime;
    private final MultiStatus fStatus;
    private final FileCharSequenceProvider fFileCharSequenceProvider;
    private final ReusableMatchAccess fMatchAccess;

    public TextSearchVisitor(TextSearchRequestor collector, Pattern searchPattern) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fMatcher = searchPattern.pattern().length() == 0 ? null : searchPattern.matcher(new String());
        this.fFileCharSequenceProvider = new FileCharSequenceProvider();
        this.fMatchAccess = new ReusableMatchAccess();
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        MultiStatus multiStatus;
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        try {
            this.fProgressMonitor.beginTask("", this.fNumberOfFilesToScan);
            if (this.fNumberOfFilesToScan > 0) {
                Object[] args = new Integer[]{new Integer(1), new Integer(this.fNumberOfFilesToScan)};
                this.fProgressMonitor.setTaskName(Messages.format(SearchMessages.TextSearchEngine_scanning, args));
            }
            this.fCollector.beginReporting();
            this.processFiles(files);
            multiStatus = this.fStatus;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
            throw throwable;
        }
        this.fProgressMonitor.done();
        this.fCollector.endReporting();
        return multiStatus;
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(new FilesOfScopeCalculator(scope, this.fStatus).process(), monitor);
    }

    private void processFiles(IFile[] files) {
        this.fDocumentsInEditors = this.evalNonFileBufferDocuments();
        int i = 0;
        while (i < files.length) {
            this.processFile(files[i]);
            ++i;
        }
        this.fDocumentsInEditors = null;
    }

    private Map evalNonFileBufferDocuments() {
        HashMap result = new HashMap();
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private void evaluateTextEditor(Map result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath());
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processFile(IFile file) {
        try {
            block17: {
                try {
                    block20: {
                        block19: {
                            block18: {
                                if (!this.fCollector.acceptFile(file)) break block18;
                                if (this.fMatcher != null) break block19;
                            }
                            var8_2 = null;
                            break block17;
                        }
                        document = this.getOpenDocument(file);
                        if (document == null) break block20;
                        this.locateMatches(file, new DocumentCharSequence(document));
                        ** GOTO lbl-1000
                    }
                    seq = null;
                    try {
                        try {
                            seq = this.fFileCharSequenceProvider.newCharSequence(file);
                            this.locateMatches(file, seq);
                        }
                        catch (FileCharSequenceProvider.FileCharSequenceException e) {
                            e.throwWrappedException();
                        }
                    }
                    catch (Throwable var6_20) {
                        var5_21 = null;
                        if (seq == null) throw var6_20;
                        try {
                            this.fFileCharSequenceProvider.releaseCharSequence(seq);
                            throw var6_20;
                        }
                        catch (IOException e) {
                            SearchPlugin.log(e);
                        }
                        throw var6_20;
                    }
                    {
                        var5_22 = null;
                        if (seq == null) ** GOTO lbl-1000
                        ** try [egrp 4[TRYBLOCK] [3 : 92->103)] { 
lbl37:
                        // 1 sources

                        this.fFileCharSequenceProvider.releaseCharSequence(seq);
lbl39:
                        // 1 sources

                        catch (IOException e) {
                            SearchPlugin.log(e);
                        }
                    }
                }
                catch (UnsupportedCharsetException e) {
                    args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                    message = Messages.format(SearchMessages.TextSearchVisitor_unsupportedcharset, args);
                    this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                }
                catch (IllegalCharsetNameException e) {
                    args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                    message = Messages.format(SearchMessages.TextSearchVisitor_illegalcharset, args);
                    this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                }
                catch (IOException e) {
                    args = new String[]{this.getExceptionMessage(e), file.getFullPath().makeRelative().toString()};
                    message = Messages.format(SearchMessages.TextSearchVisitor_error, args);
                    this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                }
                catch (CoreException e) {
                    args = new String[]{this.getExceptionMessage((Exception)e), file.getFullPath().makeRelative().toString()};
                    message = Messages.format(SearchMessages.TextSearchVisitor_error, args);
                    this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                }
                ** GOTO lbl-1000
            }
            this.updateProgressMonitor();
            return;
        }
        catch (Throwable var9_25) {
            var8_3 = null;
            this.updateProgressMonitor();
            throw var9_25;
        }
lbl-1000:
        // 8 sources

        {
            var8_4 = null;
            this.updateProgressMonitor();
            return;
        }
    }

    private void locateMatches(IFile file, CharSequence searchInput) throws CoreException {
        this.fMatcher.reset(searchInput);
        int k = 0;
        while (this.fMatcher.find()) {
            int start = this.fMatcher.start();
            int end = this.fMatcher.end();
            if (end != start) {
                this.fMatchAccess.initialize(file, start, end - start, searchInput);
                boolean res = this.fCollector.acceptPatternMatch(this.fMatchAccess);
                if (!res) {
                    return;
                }
            }
            if (k++ != 20) continue;
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
            }
            k = 0;
        }
        this.fMatchAccess.initialize(null, 0, 0, new String());
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file) {
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = (IDocument)this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    private void updateProgressMonitor() {
        long currTime;
        ++this.fNumberOfScannedFiles;
        if (this.fNumberOfScannedFiles < this.fNumberOfFilesToScan && (currTime = System.currentTimeMillis()) - this.fLastUpdateTime > 1000L) {
            Object[] args = new Object[]{new Integer(this.fNumberOfScannedFiles + 1), new Integer(this.fNumberOfFilesToScan)};
            this.fProgressMonitor.setTaskName(Messages.format(SearchMessages.TextSearchVisitor_scanning, args));
            this.fLastUpdateTime = currTime;
        }
        this.fProgressMonitor.worked(1);
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
        }
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;

        public void initialize(IFile file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public int getMatchOffset() {
            return this.fOffset;
        }

        public int getMatchLength() {
            return this.fLength;
        }

        public int getFileContentLength() {
            return this.fContent.length();
        }

        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }
    }
}

