/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.internal.core.text.FileNamePatternSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileSearchQuery
implements ISearchQuery {
    private String fSearchString;
    private String fSearchOptions;
    private FileNamePatternSearchScope fScope;
    private FileSearchResult fResult;

    public FileSearchQuery(FileNamePatternSearchScope scope, String options, String searchString) {
        this.fScope = scope;
        this.fSearchOptions = options;
        this.fSearchString = searchString;
    }

    public FileNamePatternSearchScope getSearchScope() {
        return this.fScope;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public IStatus run(IProgressMonitor monitor) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, isFileSearchOnly);
        return TextSearchEngine.create().search(this.fScope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    public String getLabel() {
        return SearchMessages.FileSearchQuery_label;
    }

    public String getSearchString() {
        return this.fSearchString;
    }

    public String getSearchOptions() {
        return this.fSearchOptions;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 1) {
            if (this.fSearchString.length() > 0) {
                Object[] args = new Object[]{this.fSearchString, this.fScope.getDescription()};
                return Messages.format(SearchMessages.FileSearchQuery_singularLabel, args);
            }
            Object[] args = new Object[]{this.fScope.getFileNamePatternDescription(), this.fScope.getDescription()};
            return Messages.format(SearchMessages.FileSearchQuery_singularLabel_fileNameSearch, args);
        }
        if (this.fSearchString.length() > 0) {
            Object[] args = new Object[]{this.fSearchString, new Integer(nMatches), this.fScope.getDescription()};
            return Messages.format(SearchMessages.FileSearchQuery_pluralPattern, args);
        }
        Object[] args = new Object[]{this.fScope.getFileNamePatternDescription(), new Integer(nMatches), this.fScope.getDescription()};
        return Messages.format(SearchMessages.FileSearchQuery_pluralPattern_fileNameSearch, args);
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, IFile file) {
        FileNamePatternSearchScope scope = FileNamePatternSearchScope.newSearchScope("", new IResource[]{file}, true);
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        TextSearchResultCollector collector = new TextSearchResultCollector(result, isFileSearchOnly);
        return TextSearchEngine.create().search(scope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    protected Pattern getSearchPattern() {
        String searchString = this.fSearchString;
        if (searchString.trim().equals(String.valueOf('*'))) {
            searchString = new String();
        }
        return PatternConstructor.createPattern(searchString, this.isRegexSearch(), true, this.isCaseSensitive(), false);
    }

    public boolean isRegexSearch() {
        return FileSearchQuery.isRegexSearch(this.getSearchOptions());
    }

    public static boolean isRegexSearch(String options) {
        return options.indexOf(114) != -1;
    }

    public boolean isCaseSensitive() {
        return FileSearchQuery.isCaseSensitive(this.getSearchOptions());
    }

    public static boolean isCaseSensitive(String options) {
        return options.indexOf(105) == -1;
    }

    public boolean canRerun() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new FileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    private static final class TextSearchResultCollector
    extends TextSearchRequestor {
        private final AbstractTextSearchResult fResult;
        private final boolean fIsFileSearchOnly;

        TextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly) {
            this.fResult = result;
            this.fIsFileSearchOnly = isFileSearchOnly;
        }

        public boolean acceptFile(IFile file) throws CoreException {
            if (this.fIsFileSearchOnly) {
                this.fResult.addMatch(new FileMatch(file, 0, 0));
            }
            return true;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
            this.fResult.addMatch(new FileMatch(matchRequestor.getFile(), matchRequestor.getMatchOffset(), matchRequestor.getMatchLength()));
            return true;
        }
    }
}

