/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.core.text.FileNamePatternSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.ScopePart;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.ReplaceAction2;
import org.eclipse.search.internal.ui.text.ReplaceDialog2;
import org.eclipse.search.internal.ui.util.FileTypeEditor;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.text2.IScopeDescription;
import org.eclipse.search2.internal.ui.text2.RetrieverQuery;
import org.eclipse.search2.internal.ui.text2.SearchMatchInformationProviderRegistry;
import org.eclipse.search2.internal.ui.text2.SelectedResourcesScopeDescription;
import org.eclipse.search2.internal.ui.text2.WindowWorkingSetScopeDescription;
import org.eclipse.search2.internal.ui.text2.WorkingSetScopeDescription;
import org.eclipse.search2.internal.ui.text2.WorkspaceScopeDescription;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contentassist.ContentAssistHandler;

public class TextSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage {
    private static final int HISTORY_SIZE = 12;
    public static final String EXTENSION_POINT_ID = "org.eclipse.search.internal.ui.text.TextSearchPage";
    private static final String PAGE_NAME = "TextSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_IS_REG_EX_SEARCH = "REG_EX_SEARCH";
    private static final String STORE_SEARCH_DERIVED = "SEARCH_DERIVED";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private List fPreviousSearchPatterns = new ArrayList(20);
    private boolean fFirstTime = true;
    private boolean fIsCaseSensitive;
    private boolean fIsRegExSearch;
    private boolean fSearchDerived;
    private Combo fPattern;
    private Button fIsCaseSensitiveCheckbox;
    private Combo fExtensions;
    private Button fIsRegExCheckbox;
    private CLabel fStatusLabel;
    private Button fSearchDerivedCheckbox;
    private ISearchPageContainer fContainer;
    private FileTypeEditor fFileTypeEditor;
    private ContentAssistHandler fReplaceContentAssistHandler;
    static /* synthetic */ Class class$0;

    public boolean performAction() {
        if (!SearchPreferencePage.useNewTextSearch() || this.getPattern().length() == 0) {
            NewSearchUI.runQueryInBackground(this.getSearchQuery());
        } else {
            NewSearchUI.runQueryInBackground(this.getNewSearchQuery());
        }
        return true;
    }

    public boolean performReplace() {
        ISearchQuery searchQuery = this.getSearchQuery();
        IStatus status = NewSearchUI.runQueryInForeground(this.getContainer().getRunnableContext(), searchQuery);
        if (status.matches(8)) {
            return false;
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_searchproblems_message, (IStatus)status);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                ISearchResultPage page;
                ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                if (view != null && (page = view.getActivePage()) instanceof FileSearchPage) {
                    FileSearchPage filePage = (FileSearchPage)page;
                    Object[] elements = filePage.getInput().getElements();
                    IFile[] files = new IFile[elements.length];
                    System.arraycopy(elements, 0, files, 0, files.length);
                    new ReplaceAction2(filePage, files).run();
                }
            }
        });
        return true;
    }

    private ISearchQuery getSearchQuery() {
        SearchPatternData patternData = this.getPatternData();
        FileNamePatternSearchScope scope = null;
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scope = FileNamePatternSearchScope.newWorkspaceScope(this.fSearchDerived);
                break;
            }
            case 1: {
                scope = this.getSelectedResourcesScope();
                break;
            }
            case 3: {
                scope = this.getEnclosingProjectScope();
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                String desc = Messages.format(SearchMessages.WorkingSetScope, ScopePart.toString(workingSets));
                scope = FileNamePatternSearchScope.newSearchScope(desc, workingSets, this.fSearchDerived);
                break;
            }
            default: {
                scope = FileNamePatternSearchScope.newWorkspaceScope(this.fSearchDerived);
            }
        }
        String[] fileExtensions = patternData.fileNamePatterns;
        int i = 0;
        while (i < fileExtensions.length) {
            scope.addFileNamePattern(fileExtensions[i]);
            ++i;
        }
        return new FileSearchQuery(scope, this.getSearchOptions(), patternData.textPattern);
    }

    private ISearchQuery getNewSearchQuery() {
        String strMatcher;
        String literal;
        RetrieverQuery query = new RetrieverQuery(this.getActivePage());
        SearchPatternData patternData = this.getPatternData();
        String pattern = patternData.textPattern;
        boolean isRegex = patternData.isRegExSearch;
        if (!isRegex && !(literal = PatternConstructor.appendAsRegEx(false, pattern, new StringBuffer()).toString()).equals(strMatcher = PatternConstructor.appendAsRegEx(true, pattern, new StringBuffer()).toString())) {
            isRegex = true;
            pattern = strMatcher;
        }
        IScopeDescription scope = null;
        switch (this.getContainer().getSelectedScope()) {
            case 1: {
                scope = this.getSelectedResourcesScopeDescription();
                break;
            }
            case 3: {
                scope = this.getEnclosingProjectScopeDescription();
                break;
            }
            case 2: {
                scope = this.getWorkingSetScopeDescription();
                break;
            }
            default: {
                scope = new WorkspaceScopeDescription();
            }
        }
        query.setSearchString(pattern);
        query.setIsCaseSensitive(patternData.isCaseSensitive);
        query.setIsRegularExpression(isRegex);
        query.setFilePatterns(patternData.fileNamePatterns);
        query.setSearchScope(scope, this.fSearchDerived);
        return query;
    }

    private IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData findInPrevious(String pattern) {
        Iterator iter = this.fPreviousSearchPatterns.iterator();
        while (iter.hasNext()) {
            SearchPatternData element = (SearchPatternData)iter.next();
            if (!pattern.equals(element.textPattern)) continue;
            return element;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        SearchPatternData match = this.findInPrevious(this.fPattern.getText());
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getPattern(), this.isCaseSensitive(), this.fIsRegExCheckbox.getSelection(), this.getExtensions(), this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    private String[] getPreviousExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(this.fPreviousSearchPatterns.size());
        int size = this.fPreviousSearchPatterns.size();
        int i = 0;
        while (i < size) {
            SearchPatternData data = (SearchPatternData)this.fPreviousSearchPatterns.get(i);
            String text = FileTypeEditor.typesToString(data.fileNamePatterns);
            if (!extensions.contains(text)) {
                extensions.add(text);
            }
            ++i;
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    private String[] getPreviousSearchPatterns() {
        int size = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = ((SearchPatternData)this.fPreviousSearchPatterns.get((int)i)).textPattern;
            ++i;
        }
        return patterns;
    }

    private String getSearchOptions() {
        StringBuffer result = new StringBuffer();
        if (!this.isCaseSensitive()) {
            result.append('i');
        }
        if (this.fIsRegExSearch) {
            result.append('r');
        }
        return result.toString();
    }

    private String[] getExtensions() {
        return this.fFileTypeEditor.getFileTypes();
    }

    private boolean isCaseSensitive() {
        return this.fIsCaseSensitiveCheckbox.getSelection();
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.fExtensions.setItems(this.getPreviousExtensions());
                if (this.fExtensions.getItemCount() == 0) {
                    this.loadFilePatternDefaults();
                }
                if (!this.initializePatternControl()) {
                    this.fPattern.select(0);
                    this.fExtensions.setText("*");
                    this.handleWidgetSelected();
                }
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    final void updateOKStatus() {
        boolean regexStatus = this.validateRegex();
        boolean hasFilePattern = this.fExtensions.getText().length() > 0;
        this.getContainer().setPerformActionEnabled(regexStatus && hasFilePattern);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        this.addTextPatternControls(result);
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.addFileNameControls(result);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.search.text_search_page_context");
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateRegex() {
        if (this.fIsRegExCheckbox.getSelection()) {
            block5: {
                try {
                    Pattern.compile(this.fPattern.getText());
                    break block5;
                }
                catch (PatternSyntaxException e) {
                    locMessage = e.getLocalizedMessage();
                    i = 0;
                    ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    continue;
                }
lbl12:
                // 1 sources

                this.statusMessage(true, locMessage.substring(0, i));
                return false;
            }
            this.statusMessage(false, "");
        } else {
            this.statusMessage(false, SearchMessages.SearchPage_containingText_hint);
        }
        return true;
    }

    private void addTextPatternControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(SearchMessages.SearchPage_containingText_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.fPattern = new Combo(group, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSearchPage.this.handleWidgetSelected();
                TextSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.setFont(group.getFont());
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        this.fIsCaseSensitiveCheckbox = new Button(group, 32);
        this.fIsCaseSensitiveCheckbox.setText(SearchMessages.SearchPage_caseSensitive);
        this.fIsCaseSensitiveCheckbox.setSelection(!this.fIsCaseSensitive);
        this.fIsCaseSensitiveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSearchPage.this.fIsCaseSensitive = TextSearchPage.this.fIsCaseSensitiveCheckbox.getSelection();
            }
        });
        this.fIsCaseSensitiveCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsCaseSensitiveCheckbox.setFont(group.getFont());
        this.fStatusLabel = new CLabel(group, 16384);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fStatusLabel.setFont(group.getFont());
        this.fStatusLabel.setAlignment(16384);
        this.fStatusLabel.setText(SearchMessages.SearchPage_containingText_hint);
        this.fIsRegExCheckbox = new Button(group, 32);
        this.fIsRegExCheckbox.setText(SearchMessages.SearchPage_regularExpression);
        this.fIsRegExCheckbox.setSelection(this.fIsRegExSearch);
        this.setContentAssistsEnablement(this.fIsRegExSearch);
        this.fIsRegExCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSearchPage.this.fIsRegExSearch = TextSearchPage.this.fIsRegExCheckbox.getSelection();
                TextSearchPage.this.updateOKStatus();
                TextSearchPage.this.writeConfiguration();
                TextSearchPage.this.setContentAssistsEnablement(TextSearchPage.this.fIsRegExSearch);
            }
        });
        this.fIsRegExCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsRegExCheckbox.setFont(group.getFont());
    }

    private void handleWidgetSelected() {
        int selectionIndex = this.fPattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData patternData = (SearchPatternData)this.fPreviousSearchPatterns.get(selectionIndex);
        if (!this.fPattern.getText().equals(patternData.textPattern)) {
            return;
        }
        this.fIsCaseSensitiveCheckbox.setSelection(patternData.isCaseSensitive);
        this.fIsRegExCheckbox.setSelection(patternData.isRegExSearch);
        this.fPattern.setText(patternData.textPattern);
        this.fFileTypeEditor.setFileTypes(patternData.fileNamePatterns);
        if (patternData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(patternData.workingSets);
        } else {
            this.getContainer().setSelectedScope(patternData.scope);
        }
    }

    private boolean initializePatternControl() {
        String text;
        ISelection selection = this.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && (text = ((ITextSelection)selection).getText()) != null) {
            this.fPattern.setText(this.insertEscapeChars(text));
            if (this.getPreviousExtensions().length > 0) {
                this.fExtensions.setText(this.getPreviousExtensions()[0]);
            } else {
                String extension = this.getExtensionFromEditor();
                if (extension != null) {
                    this.fExtensions.setText(extension);
                } else {
                    this.fExtensions.setText("*");
                }
            }
            return true;
        }
        return false;
    }

    private void loadFilePatternDefaults() {
        SearchMatchInformationProviderRegistry registry = SearchPlugin.getDefault().getSearchMatchInformationProviderRegistry();
        String[] defaults = registry.getDefaultFilePatterns();
        this.fExtensions.setItems(defaults);
        this.fExtensions.setText(defaults[0]);
    }

    private String insertEscapeChars(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        StringBuffer sbIn = new StringBuffer(text);
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int lengthOfFirstLine = 0;
        try {
            lengthOfFirstLine = reader.readLine().length();
        }
        catch (IOException iOException) {
            return "";
        }
        StringBuffer sbOut = new StringBuffer(lengthOfFirstLine + 5);
        int i = 0;
        while (i < lengthOfFirstLine) {
            char ch = sbIn.charAt(i);
            if (ch == '*' || ch == '?' || ch == '\\') {
                sbOut.append("\\");
            }
            sbOut.append(ch);
            ++i;
        }
        return sbOut.toString();
    }

    private String getExtensionFromEditor() {
        IEditorInput elem;
        IEditorPart ep = SearchPlugin.getActivePage().getActiveEditor();
        if (ep != null && (elem = ep.getEditorInput()) instanceof IFileEditorInput) {
            String extension = ((IFileEditorInput)elem).getFile().getFileExtension();
            if (extension == null) {
                return ((IFileEditorInput)elem).getFile().getName();
            }
            return "*." + extension;
        }
        return null;
    }

    private void addFileNameControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(SearchMessages.SearchPage_fileNamePatterns_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.fExtensions = new Combo(group, 2052);
        this.fExtensions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextSearchPage.this.updateOKStatus();
            }
        });
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fExtensions.setLayoutData((Object)data);
        this.fExtensions.setFont(group.getFont());
        Button button = new Button(group, 8);
        button.setText(SearchMessages.SearchPage_browse);
        GridData gridData = new GridData(1, 0x1000000, false, false, 1, 1);
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        button.setFont(group.getFont());
        IEditorRegistry editorRegistry = SearchPlugin.getDefault().getWorkbench().getEditorRegistry();
        this.fFileTypeEditor = new FileTypeEditor(editorRegistry, this.fExtensions, button);
        Label description = new Label(group, 16384);
        description.setText(SearchMessages.SearchPage_fileNamePatterns_hint);
        description.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        description.setFont(group.getFont());
        this.fSearchDerivedCheckbox = new Button(group, 32);
        this.fSearchDerivedCheckbox.setText(SearchMessages.TextSearchPage_searchDerived_label);
        this.fSearchDerivedCheckbox.setSelection(this.fSearchDerived);
        this.fSearchDerivedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSearchPage.this.fSearchDerived = TextSearchPage.this.fSearchDerivedCheckbox.getSelection();
                TextSearchPage.this.writeConfiguration();
            }
        });
        this.fSearchDerivedCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.fSearchDerivedCheckbox.setFont(group.getFont());
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private ISelection getSelection() {
        return this.fContainer.getSelection();
    }

    private FileNamePatternSearchScope getEnclosingProjectScope() {
        String[] enclosingProjectName = this.getContainer().getSelectedProjectNames();
        if (enclosingProjectName == null) {
            return FileNamePatternSearchScope.newWorkspaceScope(this.fSearchDerived);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] res = new IResource[enclosingProjectName.length];
        int i = 0;
        while (i < res.length) {
            res[i] = root.getProject(enclosingProjectName[i]);
            ++i;
        }
        int elementCount = res.length;
        String name = elementCount > 1 ? Messages.format(SearchMessages.EnclosingProjectsScope, enclosingProjectName[0]) : (elementCount == 1 ? Messages.format(SearchMessages.EnclosingProjectScope, enclosingProjectName[0]) : Messages.format(SearchMessages.EnclosingProjectScope, ""));
        return FileNamePatternSearchScope.newSearchScope(name, res, this.fSearchDerived);
    }

    private IScopeDescription getEnclosingProjectScopeDescription() {
        String[] enclosingProjectName = this.getContainer().getSelectedProjectNames();
        if (enclosingProjectName == null) {
            return new WorkspaceScopeDescription();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] res = new IResource[enclosingProjectName.length];
        int i = 0;
        while (i < res.length) {
            res[i] = root.getProject(enclosingProjectName[i]);
            ++i;
        }
        if (res.length == 0) {
            return new SelectedResourcesScopeDescription();
        }
        return this.getScopeDescription(res);
    }

    private IScopeDescription getScopeDescription(IResource[] res) {
        return new SelectedResourcesScopeDescription(res, false);
    }

    private IScopeDescription getWorkingSetScopeDescription() {
        IWorkingSet[] wss = this.getContainer().getSelectedWorkingSets();
        if (wss.length == 0) {
            return new WorkspaceScopeDescription();
        }
        if (wss.length == 1 && wss[0].equals(this.getActivePage().getAggregateWorkingSet())) {
            return new WindowWorkingSetScopeDescription();
        }
        return new WorkingSetScopeDescription(wss);
    }

    private FileNamePatternSearchScope getSelectedResourcesScope() {
        HashSet<IResource> resources = new HashSet<IResource>();
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                IResource resource;
                Object curr = iter.next();
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        return FileNamePatternSearchScope.newWorkspaceScope(this.fSearchDerived);
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IResource resource2;
                        IAdaptable iAdaptable = elements[i];
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((resource2 = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && resource2.isAccessible()) {
                            resources.add(resource2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)curr;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null || !resource.isAccessible()) continue;
                resources.add(resource);
            }
        }
        IResource[] arr = resources.toArray(new IResource[resources.size()]);
        return FileNamePatternSearchScope.newSearchScope(SearchMessages.SelectionScope, arr, this.fSearchDerived);
    }

    private IScopeDescription getSelectedResourcesScopeDescription() {
        HashSet<IResource> resources = new HashSet<IResource>();
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                IResource resource;
                Object curr = iter.next();
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        return new WorkspaceScopeDescription();
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IResource resource2;
                        IAdaptable iAdaptable = elements[i];
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((resource2 = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && resource2.isAccessible()) {
                            resources.add(resource2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)curr;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null || !resource.isAccessible()) continue;
                resources.add(resource);
            }
        }
        return this.getScopeDescription(resources.toArray(new IResource[resources.size()]));
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private IDialogSettings getDialogSettings() {
        return SearchPlugin.getDefault().getDialogSettingsSection(PAGE_NAME);
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        this.fIsRegExSearch = s.getBoolean(STORE_IS_REG_EX_SEARCH);
        this.fSearchDerived = s.getBoolean(STORE_SEARCH_DERIVED);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        s.put(STORE_IS_REG_EX_SEARCH, this.fIsRegExSearch);
        s.put(STORE_SEARCH_DERIVED, this.fSearchDerived);
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = (SearchPatternData)this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private void setContentAssistsEnablement(boolean enable) {
        if (enable) {
            if (this.fReplaceContentAssistHandler == null) {
                this.fReplaceContentAssistHandler = ContentAssistHandler.createHandlerForCombo((Combo)this.fPattern, (SubjectControlContentAssistant)ReplaceDialog2.createContentAssistant(true));
            }
            this.fReplaceContentAssistHandler.setEnabled(true);
        } else {
            if (this.fReplaceContentAssistHandler == null) {
                return;
            }
            this.fReplaceContentAssistHandler.setEnabled(false);
        }
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
    }

    private static class SearchPatternData {
        public final boolean isCaseSensitive;
        public final boolean isRegExSearch;
        public final String textPattern;
        public final String[] fileNamePatterns;
        public final int scope;
        public final IWorkingSet[] workingSets;

        public SearchPatternData(String textPattern, boolean isCaseSensitive, boolean isRegExSearch, String[] fileNamePatterns, int scope, IWorkingSet[] workingSets) {
            Assert.isNotNull((Object)fileNamePatterns);
            this.isCaseSensitive = isCaseSensitive;
            this.isRegExSearch = isRegExSearch;
            this.textPattern = textPattern;
            this.fileNamePatterns = fileNamePatterns;
            this.scope = scope;
            this.workingSets = workingSets;
        }

        public void store(IDialogSettings settings) {
            settings.put("ignoreCase", !this.isCaseSensitive);
            settings.put("isRegExSearch", this.isRegExSearch);
            settings.put("textPattern", this.textPattern);
            settings.put("fileNamePatterns", this.fileNamePatterns);
            settings.put("scope", this.scope);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getLabel();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
        }

        public static SearchPatternData create(IDialogSettings settings) {
            String[] fileNamePatterns;
            String textPattern = settings.get("textPattern");
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            if ((fileNamePatterns = settings.getArray("fileNamePatterns")) == null) {
                fileNamePatterns = new String[]{};
            }
            try {
                int scope = settings.getInt("scope");
                boolean isRegExSearch = settings.getBoolean("isRegExSearch");
                boolean ignoreCase = settings.getBoolean("ignoreCase");
                return new SearchPatternData(textPattern, !ignoreCase, isRegExSearch, fileNamePatterns, scope, workingSets);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

