/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.ui.text.SearchMatchInformationProvider;

public abstract class AbstractSearchMatchInformationProvider
extends SearchMatchInformationProvider {
    private ArrayList fLocations = new ArrayList();
    private int[] fLineOffsets = null;
    private int fLineCount;
    private IFile fFile;
    private int fFileLength;

    public void reset() {
        this.fFile = null;
        this.fLocations.clear();
        this.fLineOffsets = null;
        this.fLineCount = 0;
    }

    protected abstract void scanFile(TextSearchMatchAccess var1);

    private void checkScanFile(TextSearchMatchAccess match) {
        if (!match.getFile().equals((Object)this.fFile)) {
            this.reset();
            this.scanFile(match);
            if (this.fLineCount != 0) {
                int[] offsets = new int[this.fLineCount];
                System.arraycopy(this.fLineOffsets, 0, offsets, 0, this.fLineCount);
                this.fLineOffsets = offsets;
            }
            this.fFile = match.getFile();
            this.fFileLength = match.getFileContentLength();
        }
    }

    protected final void addLineOffset(int offset) {
        if (this.fLineCount == 0) {
            this.fLineOffsets = new int[1024];
        } else if (this.fLineCount == this.fLineOffsets.length) {
            int[] newOffsets = new int[this.fLineOffsets.length * 2];
            System.arraycopy(this.fLineOffsets, 0, newOffsets, 0, this.fLineCount);
            this.fLineOffsets = newOffsets;
        }
        this.fLineOffsets[this.fLineCount++] = offset;
    }

    protected final void addLocation(int offset, int length, int kind) {
        this.fLocations.add(new Location(offset, length, kind));
    }

    public SearchMatchInformationProvider.LineInformation getLineInformation(TextSearchMatchAccess match) {
        this.checkScanFile(match);
        return this.getLineInformation(match.getMatchOffset(), match.getMatchLength());
    }

    private SearchMatchInformationProvider.LineInformation getLineInformation(int offset, int length) {
        if (this.fLineOffsets != null) {
            int lineIdx = this.getLineIndexForOffset(offset);
            int lineOffset = this.fLineOffsets[lineIdx];
            int endLineIdx = this.getLineIndexForOffset(offset + length - 1);
            int lineLength = endLineIdx < this.fLineOffsets.length - 1 ? this.fLineOffsets[endLineIdx + 1] - lineOffset : this.fFileLength - lineOffset;
            return new SearchMatchInformationProvider.LineInformation(lineIdx + 1, lineOffset, lineLength);
        }
        return new SearchMatchInformationProvider.LineInformation(0, 0, 0);
    }

    private int getLineIndexForOffset(int offset) {
        int lineIdx = Arrays.binarySearch(this.fLineOffsets, offset);
        if (lineIdx < 0) {
            lineIdx = Math.max(0, -lineIdx - 2);
        }
        return lineIdx;
    }

    public int getLocationKind(TextSearchMatchAccess match) {
        this.checkScanFile(match);
        return this.getLocationKind(match.getMatchOffset());
    }

    private int getLocationKind(int offset) {
        int low = 0;
        int high = this.fLocations.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            Location loc = (Location)this.fLocations.get(mid);
            int locOffset = loc.fOffset;
            if (offset >= locOffset) {
                if (offset < locOffset + loc.fLength) {
                    return loc.fKind;
                }
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return 0;
    }

    private static class Location {
        private int fOffset;
        private int fLength;
        private int fKind;

        public Location(int offset, int length, int kind) {
            this.fOffset = offset;
            this.fLength = length;
            this.fKind = kind;
        }
    }
}

