/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.search.internal.core.text.FileNamePatternSearchScope;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.FindInRecentScopeActionDelegate;
import org.eclipse.search2.internal.ui.text2.IScopeDescription;
import org.eclipse.search2.internal.ui.text2.RetrieverQuery;
import org.eclipse.search2.internal.ui.text2.WorkingSetScopeDescription;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class FindInWorkingSetActionDelegate
extends FindInRecentScopeActionDelegate {
    public FindInWorkingSetActionDelegate() {
        super(SearchMessages.FindInWorkingSetActionDelegate_text);
    }

    protected boolean modifyQuery(RetrieverQuery query) {
        IScopeDescription scope;
        IWorkbenchPage page;
        if (super.modifyQuery(query) && (page = this.getWorkbenchPage()) != null && (scope = WorkingSetScopeDescription.createWithDialog(page, query.getScopeDescription())) != null) {
            query.setSearchScope(scope);
            return true;
        }
        return false;
    }

    protected FileNamePatternSearchScope getOldSearchScope(boolean includeDerived) {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page != null) {
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(page.getWorkbenchWindow().getShell(), true);
            if (dialog.open() == 0) {
                IWorkingSet[] workingSets = dialog.getSelection();
                if (workingSets != null) {
                    return FileNamePatternSearchScope.newSearchScope(workingSets, includeDerived);
                }
            } else {
                throw new OperationCanceledException();
            }
        }
        return FileNamePatternSearchScope.newWorkspaceScope(includeDerived);
    }
}

