/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.search2.internal.ui.text2.IFileSorter;

public class FlatFileSorter
implements IFileSorter {
    private static final int FLAT_KEY_VALUE = Integer.MIN_VALUE;
    private static final Integer FLAT_KEY = new Integer(Integer.MIN_VALUE);
    private Collator fCollator;
    private HashMap fCollationKeys;

    public FlatFileSorter(Collator collator) {
        this.fCollator = collator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sortFiles(IFile[] files) {
        ArrayList<Node> nodeList = new ArrayList<Node>(files.length);
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            nodeList.add(new Node(file.getName(), file));
            ++i;
        }
        this.fCollationKeys = new HashMap();
        try {
            this.sortNodesToFiles(nodeList, 0, files, 0, true);
            Object var3_5 = null;
            this.fCollationKeys = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fCollationKeys = null;
            throw throwable;
        }
    }

    private void sortNodesToFiles(ArrayList nodeList, int cmpIdx, IFile[] files, int fileIdx, boolean resolveWithDirectory) {
        int nodeListSize = nodeList.size();
        switch (nodeListSize) {
            case 0: {
                return;
            }
            case 1: {
                files[fileIdx] = ((Node)nodeList.get(0)).fFile;
                return;
            }
        }
        Node node = (Node)nodeList.get(0);
        int commonChar = this.getChar(node.fSortKey, cmpIdx);
        int i = 1;
        while (i < nodeListSize) {
            node = (Node)nodeList.get(i);
            int c = this.getChar(node.fSortKey, cmpIdx);
            if (c != commonChar) break;
            ++i;
        }
        if (i == nodeListSize) {
            if (commonChar == Integer.MIN_VALUE) {
                this.handleFlatList(nodeList, files, fileIdx, resolveWithDirectory);
            } else {
                this.sortNodesToFiles(nodeList, cmpIdx + 1, files, fileIdx, resolveWithDirectory);
            }
            return;
        }
        HashMap splitMap = new HashMap();
        ArrayList firstList = new ArrayList(nodeList.subList(0, i));
        splitMap.put(new Integer(commonChar), firstList);
        while (i < nodeListSize) {
            node = (Node)nodeList.get(i);
            int c = this.getChar(node.fSortKey, cmpIdx);
            this.addToMap(new Integer(c), node, splitMap);
            ++i;
        }
        ArrayList flatList = (ArrayList)splitMap.remove(FLAT_KEY);
        if (flatList != null) {
            this.handleFlatList(flatList, files, fileIdx, resolveWithDirectory);
            fileIdx += flatList.size();
        }
        TreeMap sorted = new TreeMap();
        Iterator iter = splitMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            CollationKey key = this.getCollationKey((Integer)entry.getKey());
            List existing = (List)sorted.get(key);
            if (existing != null) {
                existing.addAll((List)entry.getValue());
                continue;
            }
            sorted.put(key, entry.getValue());
        }
        iter = sorted.values().iterator();
        while (iter.hasNext()) {
            ArrayList list = (ArrayList)((Object)iter.next());
            this.sortNodesToFiles(list, cmpIdx + 1, files, fileIdx, resolveWithDirectory);
            fileIdx += list.size();
        }
    }

    private void handleFlatList(ArrayList flatList, IFile[] files, int fileIdx, boolean resolveWithDirectory) {
        switch (flatList.size()) {
            case 0: {
                break;
            }
            case 1: {
                files[fileIdx++] = ((Node)flatList.get(0)).fFile;
                break;
            }
            default: {
                if (resolveWithDirectory) {
                    Iterator iter = flatList.iterator();
                    while (iter.hasNext()) {
                        Node flatNode = (Node)iter.next();
                        flatNode.fSortKey = flatNode.fFile.getFullPath().toString();
                    }
                    this.sortNodesToFiles(flatList, 0, files, fileIdx, false);
                    fileIdx += flatList.size();
                    break;
                }
                Iterator iter = flatList.iterator();
                while (iter.hasNext()) {
                    Node flatNode = (Node)iter.next();
                    files[fileIdx++] = flatNode.fFile;
                }
                break block0;
            }
        }
    }

    private int getChar(String sortKey, int cmpIdx) {
        int result;
        try {
            result = sortKey.charAt(cmpIdx);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            result = Integer.MIN_VALUE;
        }
        return result;
    }

    private void addToMap(Object key, Node node, HashMap map) {
        ArrayList<Node> list = (ArrayList<Node>)map.get(key);
        if (list == null) {
            list = new ArrayList<Node>();
            map.put(key, list);
        }
        list.add(node);
    }

    private CollationKey getCollationKey(Integer ch) {
        CollationKey key = (CollationKey)this.fCollationKeys.get(ch);
        if (key == null) {
            key = this.fCollator.getCollationKey(String.valueOf((char)ch.intValue()));
            this.fCollationKeys.put(ch, key);
        }
        return key;
    }

    public static class Node {
        private String fSortKey;
        private IFile fFile;

        public Node(String name, IFile file) {
            this.fSortKey = name;
            this.fFile = file;
        }
    }
}

