/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;

public class RetrieverSearchScope
extends TextSearchScope {
    private boolean fIsCaseSensitive = false;
    private boolean fVisitDerived = false;
    private IResource[] fRoots;
    private HashSet fFileExtensions = new HashSet();
    private ArrayList fFileMatchers = new ArrayList();

    public RetrieverSearchScope(IResource root, String[] filePatterns, boolean isCaseSensitive) {
        this(new IResource[]{root}, filePatterns, isCaseSensitive);
    }

    public RetrieverSearchScope(IResource[] roots, String[] filePatterns, boolean isCaseSensitive) {
        this.fIsCaseSensitive = isCaseSensitive;
        this.compileFilePatterns(filePatterns);
        ArrayList<IResource> openRoots = new ArrayList<IResource>();
        int i = 0;
        while (i < roots.length) {
            IResource root = roots[i];
            if (root.getProject().isOpen()) {
                openRoots.add(root);
            }
            ++i;
        }
        this.fRoots = openRoots.toArray(new IResource[openRoots.size()]);
    }

    private void compileFilePatterns(String[] filePatterns) {
        this.fFileMatchers.clear();
        this.fFileExtensions.clear();
        if (filePatterns != null) {
            int i = 0;
            while (i < filePatterns.length) {
                this.compileFilePattern(filePatterns[i], this.fFileExtensions, this.fFileMatchers);
                ++i;
            }
        }
    }

    private void compileFilePattern(String pattern, HashSet extensions, ArrayList matchers) {
        String strMatcher;
        String suffix;
        String literal;
        int pos = (pattern = pattern.trim()).lastIndexOf(42);
        if (pos == 0 && (pos = pattern.lastIndexOf(46)) == 1 && (literal = PatternConstructor.appendAsRegEx(false, suffix = pattern.substring(2), new StringBuffer()).toString()).equals(strMatcher = PatternConstructor.appendAsRegEx(true, suffix, new StringBuffer()).toString())) {
            if (!this.fIsCaseSensitive) {
                suffix = suffix.toUpperCase();
            }
            extensions.add(suffix);
            return;
        }
        Pattern regex = PatternConstructor.createPattern(pattern, false, true, this.fIsCaseSensitive, false);
        matchers.add(regex.matcher(""));
    }

    public boolean contains(IResourceProxy proxy) {
        if (!this.fVisitDerived && proxy.isDerived()) {
            return false;
        }
        switch (proxy.getType()) {
            case 4: {
                return ((IProject)proxy.requestResource()).isOpen();
            }
            case 1: {
                return this.containsFile(proxy);
            }
        }
        return true;
    }

    private boolean containsFile(IResourceProxy proxy) {
        String name = proxy.getName();
        int iDot = name.lastIndexOf(46);
        String ext = null;
        if (iDot >= 0) {
            ext = name.substring(iDot + 1);
            if (!this.fIsCaseSensitive) {
                ext = ext.toUpperCase();
            }
            if (this.fFileExtensions.contains(ext)) {
                return true;
            }
        }
        int i = 0;
        while (i < this.fFileMatchers.size()) {
            Matcher m = (Matcher)this.fFileMatchers.get(i);
            m.reset(name);
            if (m.matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setVisitDerived(boolean visitDerived) {
        this.fVisitDerived = visitDerived;
    }

    public IResource[] getRoots() {
        return this.fRoots;
    }
}

