/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class EditCommentDialog
extends Dialog {
    private String fComment = "";
    private Text fCommentField;
    private final String fMessage;
    private final String fTitle;

    public EditCommentDialog(Shell shell, String title, String message, String comment) {
        super(shell);
        this.fTitle = title;
        this.fMessage = message;
        this.fComment = comment == null ? "" : comment;
    }

    protected void buttonPressed(int id) {
        this.fComment = id == 0 ? this.fCommentField.getText() : null;
        super.buttonPressed(id);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.fCommentField.setFocus();
        if (this.fComment != null) {
            this.fCommentField.setText(this.fComment);
            this.fCommentField.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.fMessage != null) {
            Label label = new Label(composite, 64);
            label.setText(this.fMessage);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.fCommentField = new Text(composite, 2562);
        GridData data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(3);
        this.fCommentField.setLayoutData((Object)data);
        EditCommentDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getComment() {
        return this.fComment;
    }
}

