/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringDescriptorDiff;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringDescriptorSynchronizationProxy;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;

public abstract class AbstractSynchronizationContentProvider
extends SynchronizationContentProvider {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getRefactorings(IFileRevision revision, Set set, int direction, IProgressMonitor monitor) {
        IStorage storage = null;
        try {
            storage = revision.getStorage((IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
        }
        catch (CoreException exception) {
            RefactoringUIPlugin.log(exception);
        }
        if (storage == null) return;
        InputStream stream = null;
        IRefactoringHistoryService service = RefactoringCore.getHistoryService();
        try {
            try {
                service.connect();
                stream = storage.getContents();
                RefactoringHistory history = service.readRefactoringHistory(stream, 4);
                if (history != null && !history.isEmpty()) {
                    RefactoringDescriptorProxy[] proxies = history.getDescriptors();
                    int offset = 0;
                    while (offset < proxies.length) {
                        RefactoringDescriptorSynchronizationProxy proxy = new RefactoringDescriptorSynchronizationProxy(proxies[offset], direction);
                        if (!set.contains((Object)proxy)) {
                            set.add(proxy);
                        } else {
                            set.remove((Object)proxy);
                        }
                        ++offset;
                    }
                }
            }
            catch (CoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            service.disconnect();
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var12_16 = null;
        }
        service.disconnect();
        if (stream == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        stream.close();
    }

    protected RefactoringHistory getRefactorings(ISynchronizationContext context, IProject project, IProgressMonitor monitor) {
        RefactoringHistoryImplementation refactoringHistoryImplementation;
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)project);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            RefactoringDescriptorProxy proxy;
            monitor.beginTask(RefactoringUIMessages.RefactoringModelMerger_retrieving_refactorings, 12);
            final IProgressMonitor finalMonitor = monitor;
            final HashSet<RefactoringDescriptorProxy> remote = new HashSet<RefactoringDescriptorProxy>();
            final HashSet local = new HashSet();
            final IResourceDiffTree tree = context.getDiffTree();
            tree.accept(project.getFolder(".refactorings").getFullPath(), new IDiffVisitor(){

                public final boolean visit(IDiff diff) {
                    if (diff instanceof IThreeWayDiff) {
                        IThreeWayDiff threeWay = (IThreeWayDiff)diff;
                        IResource resource = tree.getResource(diff);
                        if (resource.getName().equals("refactorings.history") && resource.getType() == 1) {
                            ITwoWayDiff localDiff;
                            IFileRevision beforeRevision;
                            ITwoWayDiff remoteDiff = threeWay.getRemoteChange();
                            if (remoteDiff instanceof IResourceDiff && remoteDiff.getKind() != 0) {
                                IFileRevision afterRevision = ((IResourceDiff)remoteDiff).getAfterState();
                                if (afterRevision != null) {
                                    AbstractSynchronizationContentProvider.this.getRefactorings(afterRevision, remote, 512, finalMonitor);
                                }
                                if ((beforeRevision = ((IResourceDiff)remoteDiff).getBeforeState()) != null) {
                                    AbstractSynchronizationContentProvider.this.getRefactorings(beforeRevision, remote, 512, finalMonitor);
                                }
                            }
                            if ((localDiff = threeWay.getLocalChange()) instanceof IResourceDiff && localDiff.getKind() != 0) {
                                IFileRevision afterRevision;
                                beforeRevision = ((IResourceDiff)localDiff).getBeforeState();
                                if (beforeRevision != null) {
                                    AbstractSynchronizationContentProvider.this.getRefactorings(beforeRevision, local, 256, finalMonitor);
                                }
                                if ((afterRevision = ((IResourceDiff)localDiff).getAfterState()) != null) {
                                    AbstractSynchronizationContentProvider.this.getRefactorings(afterRevision, local, 256, finalMonitor);
                                }
                            }
                        }
                    }
                    return true;
                }
            }, 2);
            Iterator iterator = new ArrayList(local).iterator();
            while (iterator.hasNext()) {
                proxy = (RefactoringDescriptorProxy)iterator.next();
                if (!remote.contains(proxy)) {
                    remote.add(proxy);
                    continue;
                }
                remote.remove(proxy);
            }
            iterator = new ArrayList(remote).iterator();
            while (iterator.hasNext()) {
                proxy = (RefactoringDescriptorSynchronizationProxy)((Object)iterator.next());
                if (this.isVisible((IDiff)new RefactoringDescriptorDiff(proxy, 4, proxy.getDirection()))) continue;
                remote.remove(proxy);
            }
            RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[remote.size()];
            remote.toArray(proxies);
            refactoringHistoryImplementation = new RefactoringHistoryImplementation(proxies);
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return refactoringHistoryImplementation;
    }
}

