/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.model.AbstractRefactoringDescriptorResourceMapping;
import org.eclipse.ltk.core.refactoring.model.AbstractRefactoringHistoryResourceMapping;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringDescriptorProxyAdapter;
import org.eclipse.ltk.internal.ui.refactoring.actions.AcceptRefactoringsAction;
import org.eclipse.ltk.internal.ui.refactoring.actions.RejectRefactoringsAction;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.mapping.SynchronizationActionProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class RefactoringSynchronizationActionProvider
extends SynchronizationActionProvider {
    static /* synthetic */ Class class$0;

    private static void getRefactoring(ISynchronizationScope scope, RefactoringDescriptorProxy proxy, Set set) {
        AbstractRefactoringDescriptorResourceMapping extended;
        IResource resource;
        ResourceMapping mapping;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((mapping = (ResourceMapping)proxy.getAdapter((Class)clazz)) instanceof AbstractRefactoringDescriptorResourceMapping && (resource = (extended = (AbstractRefactoringDescriptorResourceMapping)mapping).getResource()) != null && scope.contains(resource)) {
            set.add(proxy);
        }
    }

    private static RefactoringDescriptorProxy[] getRefactorings(ISynchronizationContext context, ISynchronizePageConfiguration configuration) {
        IStructuredSelection structured;
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)configuration);
        HashSet set = new HashSet();
        ISelection selection = configuration.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !(structured = (IStructuredSelection)selection).isEmpty()) {
            Object[] elements = structured.toArray();
            ISynchronizationScope scope = context.getScope();
            int index = 0;
            while (index < elements.length) {
                if (elements[index] instanceof RefactoringHistory) {
                    RefactoringSynchronizationActionProvider.getRefactorings(scope, (RefactoringHistory)elements[index], set);
                } else if (elements[index] instanceof RefactoringDescriptorProxy) {
                    RefactoringSynchronizationActionProvider.getRefactoring(scope, (RefactoringDescriptorProxy)elements[index], set);
                } else if (elements[index] instanceof RefactoringDescriptor) {
                    RefactoringSynchronizationActionProvider.getRefactoring(scope, (RefactoringDescriptorProxy)new RefactoringDescriptorProxyAdapter((RefactoringDescriptor)elements[index]), set);
                }
                ++index;
            }
        }
        return set.toArray(new RefactoringDescriptorProxy[set.size()]);
    }

    private static void getRefactorings(ISynchronizationScope scope, RefactoringHistory history, Set set) {
        AbstractRefactoringHistoryResourceMapping extended;
        IResource resource;
        ResourceMapping mapping;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((mapping = (ResourceMapping)history.getAdapter((Class)clazz)) instanceof AbstractRefactoringHistoryResourceMapping && (resource = (extended = (AbstractRefactoringHistoryResourceMapping)mapping).getResource()) != null && scope.contains(resource)) {
            set.addAll(Arrays.asList(history.getDescriptors()));
        }
    }

    private static boolean hasRefactoring(ISynchronizationScope scope, RefactoringDescriptorProxy proxy) {
        AbstractRefactoringDescriptorResourceMapping extended;
        IResource resource;
        ResourceMapping mapping;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((mapping = (ResourceMapping)proxy.getAdapter((Class)clazz)) instanceof AbstractRefactoringDescriptorResourceMapping && (resource = (extended = (AbstractRefactoringDescriptorResourceMapping)mapping).getResource()) != null) {
            return scope.contains(resource);
        }
        return false;
    }

    private static boolean hasRefactorings(ISynchronizationContext context, ISynchronizePageConfiguration configuration) {
        IStructuredSelection structured;
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)configuration);
        ISelection selection = configuration.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !(structured = (IStructuredSelection)selection).isEmpty()) {
            Object[] elements = structured.toArray();
            ISynchronizationScope scope = context.getScope();
            int index = 0;
            while (index < elements.length) {
                if (elements[index] instanceof RefactoringHistory) {
                    return RefactoringSynchronizationActionProvider.hasRefactorings(scope, (RefactoringHistory)elements[index]);
                }
                if (elements[index] instanceof RefactoringDescriptorProxy) {
                    return RefactoringSynchronizationActionProvider.hasRefactoring(scope, (RefactoringDescriptorProxy)elements[index]);
                }
                if (elements[index] instanceof RefactoringDescriptor) {
                    return RefactoringSynchronizationActionProvider.hasRefactoring(scope, (RefactoringDescriptorProxy)new RefactoringDescriptorProxyAdapter((RefactoringDescriptor)elements[index]));
                }
                ++index;
            }
        }
        return false;
    }

    private static boolean hasRefactorings(ISynchronizationScope scope, RefactoringHistory history) {
        AbstractRefactoringHistoryResourceMapping extended;
        IResource resource;
        ResourceMapping mapping;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((mapping = (ResourceMapping)history.getAdapter((Class)clazz)) instanceof AbstractRefactoringHistoryResourceMapping && (resource = (extended = (AbstractRefactoringHistoryResourceMapping)mapping).getResource()) != null) {
            return scope.contains(resource);
        }
        return false;
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        ISynchronizationContext syncContext = this.getSynchronizationContext();
        RefactoringDescriptorProxy[] proxies = RefactoringSynchronizationActionProvider.getRefactorings(syncContext, this.getSynchronizePageConfiguration());
        AcceptRefactoringsAction accept = new AcceptRefactoringsAction(syncContext, this.getExtensionSite().getViewSite().getShell());
        accept.setRefactoringDescriptors(proxies);
        menu.add((IAction)accept);
        RejectRefactoringsAction reject = new RejectRefactoringsAction(syncContext);
        reject.setRefactoringDescriptors(proxies);
        menu.add((IAction)reject);
    }

    protected void initialize() {
        super.initialize();
        ISynchronizePageConfiguration configuration = this.getSynchronizePageConfiguration();
        this.registerHandler("org.eclipse.team.ui.mergeAction", (IHandler)new RefactoringHandlerDelegate(MergeActionHandler.getDefaultHandler((String)"org.eclipse.team.ui.mergeAction", (ISynchronizePageConfiguration)configuration)));
        this.registerHandler("org.eclipse.team.ui.overwriteAction", (IHandler)new RefactoringHandlerDelegate(MergeActionHandler.getDefaultHandler((String)"org.eclipse.team.ui.overwriteAction", (ISynchronizePageConfiguration)configuration)));
        this.registerHandler("org.eclipse.team.ui.markAsMergeAction", (IHandler)new RefactoringHandlerDelegate(MergeActionHandler.getDefaultHandler((String)"org.eclipse.team.ui.markAsMergeAction", (ISynchronizePageConfiguration)configuration)));
    }

    private final class RefactoringHandlerDelegate
    extends AbstractHandler {
        private final IHandler fDelegateHandler;

        public RefactoringHandlerDelegate(IHandler handler) {
            Assert.isNotNull((Object)handler);
            this.fDelegateHandler = handler;
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            return this.fDelegateHandler.execute(event);
        }

        public boolean isEnabled() {
            return !RefactoringSynchronizationActionProvider.hasRefactorings(RefactoringSynchronizationActionProvider.this.getSynchronizationContext(), RefactoringSynchronizationActionProvider.this.getSynchronizePageConfiguration()) && this.fDelegateHandler.isEnabled();
        }
    }
}

