/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AnnotationBinding;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.DefaultValuePairBinding;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

class MemberValuePairBinding
implements IMemberValuePairBinding {
    static final MemberValuePairBinding[] NoPair = new MemberValuePairBinding[0];
    private static final Object NoValue = new Object();
    private static final Object[] EmptyArray = new Object[0];
    private ElementValuePair internalPair;
    private Object value = null;
    private BindingResolver bindingResolver;

    static Object buildDOMValue(Object internalObject, BindingResolver resolver) {
        if (internalObject == null) {
            return null;
        }
        if (internalObject instanceof Constant) {
            Constant constant = (Constant)internalObject;
            switch (constant.typeID()) {
                case 5: {
                    return constant.booleanValue();
                }
                case 3: {
                    return new Byte(constant.byteValue());
                }
                case 2: {
                    return new Character(constant.charValue());
                }
                case 8: {
                    return new Double(constant.doubleValue());
                }
                case 9: {
                    return new Float(constant.floatValue());
                }
                case 10: {
                    return new Integer(constant.intValue());
                }
                case 7: {
                    return new Long(constant.longValue());
                }
                case 4: {
                    return new Short(constant.shortValue());
                }
                case 11: {
                    return constant.stringValue();
                }
            }
        } else {
            if (internalObject instanceof TypeBinding) {
                return resolver.getTypeBinding((TypeBinding)internalObject);
            }
            if (internalObject instanceof org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding) {
                return resolver.getAnnotationInstance((org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding)internalObject);
            }
            if (internalObject instanceof FieldBinding) {
                return resolver.getVariableBinding((FieldBinding)internalObject);
            }
            if (internalObject instanceof Object[]) {
                Object[] elements = (Object[])internalObject;
                int length = elements.length;
                Object[] values = length == 0 ? EmptyArray : new Object[length];
                int i = 0;
                while (i < length) {
                    values[i] = MemberValuePairBinding.buildDOMValue(elements[i], resolver);
                    ++i;
                }
                return values;
            }
        }
        throw new IllegalStateException(internalObject.toString());
    }

    MemberValuePairBinding(ElementValuePair pair, BindingResolver resolver) {
        this.internalPair = pair;
        this.bindingResolver = resolver;
    }

    public IAnnotationBinding[] getAnnotations() {
        return AnnotationBinding.NoAnnotations;
    }

    public IJavaElement getJavaElement() {
        return null;
    }

    public String getKey() {
        return null;
    }

    public int getKind() {
        return 6;
    }

    public IMethodBinding getMethodBinding() {
        return this.bindingResolver.getMethodBinding(this.internalPair.getMethodBinding());
    }

    public int getModifiers() {
        return -1;
    }

    public String getName() {
        if (this.internalPair == null) {
            return null;
        }
        char[] membername = this.internalPair.getName();
        return membername == null ? null : new String(membername);
    }

    public Object getValue() {
        if (this.value == null) {
            this.init();
        }
        return this.value == NoValue ? null : this.value;
    }

    private void init() {
        this.value = MemberValuePairBinding.buildDOMValue(this.internalPair.getValue(), this.bindingResolver);
        if (this.value == null) {
            this.value = NoValue;
        }
    }

    char[] internalName() {
        return this.internalPair == null ? null : this.internalPair.getName();
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isEqualTo(IBinding binding) {
        if (this == binding) {
            return true;
        }
        if (binding.getKind() != 6) {
            return false;
        }
        IMemberValuePairBinding other = (IMemberValuePairBinding)binding;
        if (!this.getMethodBinding().isEqualTo(other.getMethodBinding())) {
            return false;
        }
        if (this.value == null) {
            return other.getValue() == null;
        }
        return this.value.equals(other.getValue());
    }

    public boolean isSynthetic() {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuffer buffer) {
        buffer.append(this.getName());
        buffer.append(" = ");
        DefaultValuePairBinding.appendValue(this.getValue(), buffer);
    }
}

