/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.formatter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterApplication
implements IPlatformRunnable {
    private final String ARG_CONFIG = "-config";
    private final String ARG_HELP = "-help";
    private final String ARG_QUIET = "-quiet";
    private final String ARG_VERBOSE = "-verbose";
    private String configName;
    private Properties options = null;
    private final String PDE_LAUNCH = "-pdelaunch";
    private boolean quiet = false;
    private boolean verbose = false;

    private void displayHelp() {
        System.out.println(Messages.bind(Messages.CommandLineUsage));
    }

    private void displayHelp(String message) {
        System.err.println(message);
        System.out.println();
        this.displayHelp();
    }

    private void formatDirTree(File dir, CodeFormatter codeFormatter) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                this.formatDirTree(file, codeFormatter);
            } else if (org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(file.getPath())) {
                this.formatFile(file, codeFormatter);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatFile(File file, CodeFormatter codeFormatter) {
        Document doc = new Document();
        try {
            if (this.verbose) {
                System.out.println(Messages.bind(Messages.CommandLineFormatting, file.getAbsolutePath()));
            }
            String contents = new String(Util.getFileCharContent(file, null));
            doc.set(contents);
            TextEdit edit = codeFormatter.format(8, contents, 0, contents.length(), 0, null);
            if (edit == null) {
                System.err.println(Messages.bind(Messages.FormatProblem, file.getAbsolutePath()));
                return;
            }
            edit.apply((IDocument)doc);
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            try {
                out.write(doc.get());
                out.flush();
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var7_13 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                out.close();
                return;
            }
        }
        catch (IOException e) {
            String errorMessage = Messages.bind(Messages.CaughtException, "IOException", e.getLocalizedMessage());
            org.eclipse.jdt.internal.core.util.Util.log(e, errorMessage);
            System.err.println(Messages.bind(Messages.ExceptionSkip, errorMessage));
            return;
        }
        catch (BadLocationException e) {
            String errorMessage = Messages.bind(Messages.CaughtException, "BadLocationException", e.getLocalizedMessage());
            org.eclipse.jdt.internal.core.util.Util.log(e, errorMessage);
            System.err.println(Messages.bind(Messages.ExceptionSkip, errorMessage));
        }
    }

    private File[] processCommandLine(String[] argsArray) {
        ArrayList<String> args = new ArrayList<String>();
        int i = 0;
        while (i < argsArray.length) {
            args.add(argsArray[i]);
            ++i;
        }
        int index = 0;
        int argCount = argsArray.length;
        int mode = 0;
        int fileCounter = 0;
        File[] filesToFormat = new File[1];
        block5: while (index < argCount) {
            String currentArg = argsArray[index++];
            switch (mode) {
                case 0: {
                    if ("-pdelaunch".equals(currentArg)) continue block5;
                    if ("-help".equals(currentArg)) {
                        this.displayHelp();
                        return null;
                    }
                    if ("-verbose".equals(currentArg)) {
                        this.verbose = true;
                        break;
                    }
                    if ("-quiet".equals(currentArg)) {
                        this.quiet = true;
                        break;
                    }
                    if ("-config".equals(currentArg)) {
                        mode = 1;
                        break;
                    }
                    File file = new File(currentArg);
                    if (file.exists()) {
                        if (filesToFormat.length == fileCounter) {
                            File[] fileArray = filesToFormat;
                            filesToFormat = new File[fileCounter * 2];
                            System.arraycopy(fileArray, 0, filesToFormat, 0, fileCounter);
                        }
                        filesToFormat[fileCounter++] = file;
                        break;
                    }
                    this.displayHelp(Messages.bind(Messages.CommandLineErrorFile, currentArg));
                    return null;
                }
                case 1: {
                    this.configName = currentArg;
                    this.options = this.readConfig(currentArg);
                    if (this.options == null) {
                        this.displayHelp(Messages.bind(Messages.CommandLineErrorConfig, currentArg));
                        return null;
                    }
                    mode = 0;
                }
            }
        }
        if (mode == 1 || this.options == null) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorNoConfigFile));
            return null;
        }
        if (this.quiet && this.verbose) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorQuietVerbose, new String[]{"-quiet", "-verbose"}));
            return null;
        }
        if (fileCounter == 0) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorFileDir));
            return null;
        }
        if (filesToFormat.length != fileCounter) {
            File[] fileArray = filesToFormat;
            filesToFormat = new File[fileCounter];
            System.arraycopy(fileArray, 0, filesToFormat, 0, fileCounter);
        }
        return filesToFormat;
    }

    /*
     * Exception decompiling
     */
    private Properties readConfig(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 85->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object run(Object args) throws Exception {
        File[] filesToFormat = this.processCommandLine((String[])args);
        if (filesToFormat == null) {
            return EXIT_OK;
        }
        if (!this.quiet) {
            if (this.configName != null) {
                System.out.println(Messages.bind(Messages.CommandLineConfigFile, this.configName));
            }
            System.out.println(Messages.bind(Messages.CommandLineStart));
        }
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(this.options);
        int i = 0;
        int max = filesToFormat.length;
        while (i < max) {
            File file = filesToFormat[i];
            if (file.isDirectory()) {
                this.formatDirTree(file, codeFormatter);
            } else if (org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(file.getPath())) {
                this.formatFile(file, codeFormatter);
            }
            ++i;
        }
        if (!this.quiet) {
            System.out.println(Messages.bind(Messages.CommandLineDone));
        }
        return EXIT_OK;
    }

    private static final class Messages
    extends NLS {
        private static final String BUNDLE_NAME = "org.eclipse.jdt.core.formatter.messages";
        public static String CommandLineConfigFile;
        public static String CommandLineDone;
        public static String CommandLineErrorConfig;
        public static String CommandLineErrorFile;
        public static String CommandLineErrorFileDir;
        public static String CommandLineErrorQuietVerbose;
        public static String CommandLineErrorNoConfigFile;
        public static String CommandLineFormatting;
        public static String CommandLineStart;
        public static String CommandLineUsage;
        public static String ConfigFileReadingError;
        public static String FormatProblem;
        public static String CaughtException;
        public static String ExceptionSkip;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.formatter.CodeFormatterApplication$Messages");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            NLS.initializeMessages((String)BUNDLE_NAME, (Class)clazz);
        }

        Messages() {
        }

        public static String bind(String message) {
            return Messages.bind(message, null);
        }

        public static String bind(String message, Object binding) {
            return Messages.bind(message, new Object[]{binding});
        }

        public static String bind(String message, Object binding1, Object binding2) {
            return Messages.bind(message, new Object[]{binding1, binding2});
        }

        public static String bind(String message, Object[] bindings) {
            return MessageFormat.format(message, bindings);
        }
    }
}

