/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.search;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.InternalSearchPattern;
import org.eclipse.jdt.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageReferencePattern;
import org.eclipse.jdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeParameterPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;

public abstract class SearchPattern
extends InternalSearchPattern {
    public static final int R_EXACT_MATCH = 0;
    public static final int R_PREFIX_MATCH = 1;
    public static final int R_PATTERN_MATCH = 2;
    public static final int R_REGEXP_MATCH = 4;
    public static final int R_CASE_SENSITIVE = 8;
    public static final int R_ERASURE_MATCH = 16;
    public static final int R_EQUIVALENT_MATCH = 32;
    public static final int R_FULL_MATCH = 64;
    public static final int R_CAMELCASE_MATCH = 128;
    private static final int MODE_MASK = 7;
    private int matchRule;

    public SearchPattern(int matchRule) {
        this.matchRule = matchRule;
        if ((matchRule & 0x30) == 0) {
            this.matchRule |= 0x40;
        }
    }

    public static final boolean camelCaseMatch(String pattern, String name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return SearchPattern.camelCaseMatch(pattern, 0, pattern.length(), name, 0, name.length());
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean camelCaseMatch(String pattern, int patternStart, int patternEnd, String name, int nameStart, int nameEnd) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        if (patternEnd < 0) {
            patternEnd = pattern.length();
        }
        if (nameEnd < 0) {
            nameEnd = name.length();
        }
        if (patternEnd <= patternStart) {
            return nameEnd <= nameStart;
        }
        if (nameEnd <= nameStart) {
            return false;
        }
        if (name.charAt(nameStart) != pattern.charAt(patternStart)) {
            return false;
        }
        iPattern = patternStart + 1;
        iName = nameStart + 1;
        block0: while (iPattern < patternEnd) {
            patternChar = pattern.charAt(iPattern);
            if (!(patternChar < '\u0080' ? ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[patternChar] != 32 : Character.isJavaIdentifierPart(patternChar) != false && Character.isUpperCase(patternChar) == false)) ** GOTO lbl35
            break;
lbl-1000:
            // 1 sources

            {
                nameChar = name.charAt(iName);
                if (nameChar != patternChar) {
                    if (nameChar < '\u0080') {
                        if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[nameChar] & 28) != 0) {
                            ++iName;
                            continue;
                        }
                    } else if (Character.isJavaIdentifierPart(nameChar) && !Character.isUpperCase(nameChar)) {
                        ++iName;
                        continue;
                    }
                    return false;
                }
                ++iName;
                ++iPattern;
                continue block0;
lbl35:
                // 3 sources

                ** while (iName < nameEnd)
            }
lbl36:
            // 1 sources

            if (iPattern == patternEnd) {
                return true;
            }
            if (iName != nameEnd) continue;
            return false;
        }
        while (iPattern < patternEnd && iName < nameEnd) {
            if (pattern.charAt(iPattern) != name.charAt(iName)) {
                return false;
            }
            ++iPattern;
            ++iName;
        }
        return iPattern == patternEnd;
    }

    public static SearchPattern createAndPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        return MatchLocator.createAndPattern(leftPattern, rightPattern);
    }

    /*
     * Unable to fully structure code
     */
    private static SearchPattern createFieldPattern(String patternString, int limitTo, int matchRule) {
        scanner = new Scanner(false, true, false, 0x2F0000L, null, null, true);
        scanner.setSource(patternString.toCharArray());
        lastToken = -1;
        declaringType = null;
        fieldName = null;
        type = null;
        mode = 1;
        try {
            token = scanner.getNextToken();
            if (true) ** GOTO lbl47
        }
        catch (InvalidInputException v0) {
            return null;
        }
        do {
            block2 : switch (mode) {
                case 1: {
                    switch (token) {
                        case 3: {
                            if (declaringType == null) {
                                if (fieldName == null) {
                                    return null;
                                }
                                declaringType = fieldName;
                            } else {
                                tokenSource = scanner.getCurrentTokenString();
                                declaringType = String.valueOf(declaringType) + tokenSource + fieldName;
                            }
                            fieldName = null;
                            break block2;
                        }
                        case 1000: {
                            if (1000 == lastToken || 3 == lastToken) break block2;
                            mode = 2;
                            break block2;
                        }
                    }
                    if (fieldName == null) {
                        fieldName = scanner.getCurrentTokenString();
                        break;
                    }
                    fieldName = String.valueOf(fieldName) + scanner.getCurrentTokenString();
                    break;
                }
                case 2: {
                    switch (token) {
                        case 1000: {
                            break block2;
                        }
                    }
                    type = type == null ? scanner.getCurrentTokenString() : String.valueOf(type) + scanner.getCurrentTokenString();
                }
            }
            lastToken = token;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException v1) {
                return null;
            }
lbl47:
            // 2 sources

        } while (token != 69);
        if (fieldName == null) {
            return null;
        }
        fieldNameChars = fieldName.toCharArray();
        if (fieldNameChars.length == 1 && fieldNameChars[0] == '*') {
            fieldNameChars = null;
        }
        declaringTypeQualification = null;
        declaringTypeSimpleName = null;
        typeQualification = null;
        typeSimpleName = null;
        if (declaringType != null) {
            declaringTypePart = declaringType.toCharArray();
            lastDotPosition = CharOperation.lastIndexOf('.', declaringTypePart);
            if (lastDotPosition >= 0) {
                declaringTypeQualification = CharOperation.subarray(declaringTypePart, 0, lastDotPosition);
                if (declaringTypeQualification.length == 1 && declaringTypeQualification[0] == '*') {
                    declaringTypeQualification = null;
                }
                declaringTypeSimpleName = CharOperation.subarray(declaringTypePart, lastDotPosition + 1, declaringTypePart.length);
            } else {
                declaringTypeSimpleName = declaringTypePart;
            }
            if (declaringTypeSimpleName.length == 1 && declaringTypeSimpleName[0] == '*') {
                declaringTypeSimpleName = null;
            }
        }
        if (type != null) {
            typePart = type.toCharArray();
            lastDotPosition = CharOperation.lastIndexOf('.', typePart);
            if (lastDotPosition >= 0) {
                typeQualification = CharOperation.subarray(typePart, 0, lastDotPosition);
                typeQualification = typeQualification.length == 1 && typeQualification[0] == '*' ? (char[])null : CharOperation.concat(IIndexConstants.ONE_STAR, typeQualification);
                typeSimpleName = CharOperation.subarray(typePart, lastDotPosition + 1, typePart.length);
            } else {
                typeSimpleName = typePart;
            }
            if (typeSimpleName.length == 1 && typeSimpleName[0] == '*') {
                typeSimpleName = null;
            }
        }
        findDeclarations = false;
        readAccess = false;
        writeAccess = false;
        switch (limitTo) {
            case 0: {
                findDeclarations = true;
                break;
            }
            case 2: {
                readAccess = true;
                writeAccess = true;
                break;
            }
            case 4: {
                readAccess = true;
                break;
            }
            case 5: {
                writeAccess = true;
                break;
            }
            case 3: {
                findDeclarations = true;
                readAccess = true;
                writeAccess = true;
            }
        }
        return new FieldPattern(findDeclarations, readAccess, writeAccess, fieldNameChars, declaringTypeQualification, declaringTypeSimpleName, typeQualification, typeSimpleName, matchRule);
    }

    /*
     * Unable to fully structure code
     */
    private static SearchPattern createMethodOrConstructorPattern(String patternString, int limitTo, int matchRule, boolean isConstructor) {
        scanner = new Scanner(false, true, false, 0x2F0000L, null, null, true);
        scanner.setSource(patternString.toCharArray());
        lastToken = -1;
        declaringType = null;
        selector = null;
        parameterType = null;
        parameterTypes = null;
        typeArguments = null;
        typeArgumentsString = null;
        parameterCount = -1;
        returnType = null;
        foundClosingParenthesis = false;
        mode = 1;
        argCount = 0;
        try {
            token = scanner.getNextToken();
            if (true) ** GOTO lbl169
        }
        catch (InvalidInputException v0) {
            return null;
        }
        do {
            block5 : switch (mode) {
                case 1: {
                    if (argCount == 0) {
                        switch (token) {
                            case 7: {
                                ++argCount;
                                if (selector == null || lastToken == 3) {
                                    if (typeArgumentsString != null) {
                                        return null;
                                    }
                                    typeArgumentsString = scanner.getCurrentTokenString();
                                    mode = 2;
                                    break block5;
                                }
                                declaringType = declaringType == null ? selector : String.valueOf(declaringType) + '.' + selector;
                                declaringType = String.valueOf(declaringType) + scanner.getCurrentTokenString();
                                selector = null;
                                break block5;
                            }
                            case 3: {
                                if (typeArgumentsString != null) {
                                    return null;
                                }
                                if (declaringType == null) {
                                    if (selector == null) {
                                        return null;
                                    }
                                    declaringType = selector;
                                } else if (selector != null) {
                                    declaringType = String.valueOf(declaringType) + scanner.getCurrentTokenString() + selector;
                                }
                                selector = null;
                                break block5;
                            }
                            case 28: {
                                parameterTypes = new String[5];
                                parameterCount = 0;
                                mode = 3;
                                break block5;
                            }
                            case 1000: {
                                switch (lastToken) {
                                    case 3: 
                                    case 8: 
                                    case 11: 
                                    case 12: 
                                    case 1000: {
                                        break block5;
                                    }
                                }
                                mode = 4;
                                break block5;
                            }
                        }
                        if (selector == null) {
                            selector = scanner.getCurrentTokenString();
                            break;
                        }
                        selector = String.valueOf(selector) + scanner.getCurrentTokenString();
                        break;
                    }
                    if (declaringType == null) {
                        return null;
                    }
                    switch (token) {
                        case 8: 
                        case 11: 
                        case 12: {
                            --argCount;
                            break;
                        }
                        case 7: {
                            ++argCount;
                        }
                    }
                    declaringType = String.valueOf(declaringType) + scanner.getCurrentTokenString();
                    break;
                }
                case 2: {
                    if (typeArgumentsString == null) {
                        return null;
                    }
                    typeArgumentsString = String.valueOf(typeArgumentsString) + scanner.getCurrentTokenString();
                    switch (token) {
                        case 8: 
                        case 11: 
                        case 12: {
                            if (--argCount != 0) break;
                            pseudoType = "Type" + typeArgumentsString;
                            typeArguments = Signature.getTypeArguments(Signature.createTypeSignature(pseudoType, false).toCharArray());
                            mode = 1;
                            break;
                        }
                        case 7: {
                            ++argCount;
                        }
                    }
                    break;
                }
                case 3: {
                    if (argCount == 0) {
                        switch (token) {
                            case 1000: {
                                break block5;
                            }
                            case 30: {
                                if (parameterType == null) {
                                    return null;
                                }
                                if (parameterTypes != null) {
                                    if (parameterTypes.length == parameterCount) {
                                        v1 = parameterTypes;
                                        parameterTypes = new String[parameterCount * 2];
                                        System.arraycopy(v1, 0, parameterTypes, 0, parameterCount);
                                    }
                                    parameterTypes[parameterCount++] = parameterType;
                                }
                                parameterType = null;
                                break block5;
                            }
                            case 29: {
                                foundClosingParenthesis = true;
                                if (parameterType != null && parameterTypes != null) {
                                    if (parameterTypes.length == parameterCount) {
                                        v2 = parameterTypes;
                                        parameterTypes = new String[parameterCount * 2];
                                        System.arraycopy(v2, 0, parameterTypes, 0, parameterCount);
                                    }
                                    parameterTypes[parameterCount++] = parameterType;
                                }
                                mode = isConstructor != false ? 2 : 4;
                                break block5;
                            }
                            case 7: {
                                ++argCount;
                                if (parameterType != null) break;
                                return null;
                            }
                        }
                        if (parameterType == null) {
                            parameterType = scanner.getCurrentTokenString();
                            break;
                        }
                        parameterType = String.valueOf(parameterType) + scanner.getCurrentTokenString();
                        break;
                    }
                    if (parameterType == null) {
                        return null;
                    }
                    switch (token) {
                        case 8: 
                        case 11: 
                        case 12: {
                            --argCount;
                            break;
                        }
                        case 7: {
                            ++argCount;
                        }
                    }
                    parameterType = String.valueOf(parameterType) + scanner.getCurrentTokenString();
                    break;
                }
                case 4: {
                    if (argCount == 0) {
                        switch (token) {
                            case 1000: {
                                break block5;
                            }
                            case 28: {
                                parameterTypes = new String[5];
                                parameterCount = 0;
                                mode = 3;
                                break block5;
                            }
                            case 7: {
                                ++argCount;
                                if (returnType != null) break;
                                return null;
                            }
                        }
                        if (returnType == null) {
                            returnType = scanner.getCurrentTokenString();
                            break;
                        }
                        returnType = String.valueOf(returnType) + scanner.getCurrentTokenString();
                        break;
                    }
                    if (returnType == null) {
                        return null;
                    }
                    switch (token) {
                        case 8: 
                        case 11: 
                        case 12: {
                            --argCount;
                            break;
                        }
                        case 7: {
                            ++argCount;
                        }
                    }
                    returnType = String.valueOf(returnType) + scanner.getCurrentTokenString();
                }
            }
            lastToken = token;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException v3) {
                return null;
            }
lbl169:
            // 2 sources

        } while (token != 69);
        if (parameterCount > 0 && !foundClosingParenthesis) {
            return null;
        }
        if (argCount > 0) {
            return null;
        }
        selectorChars = null;
        if (isConstructor) {
            if (declaringType == null) {
                declaringType = selector;
            } else if (selector != null) {
                declaringType = String.valueOf(declaringType) + '.' + selector;
            }
        } else {
            if (selector == null) {
                return null;
            }
            selectorChars = selector.toCharArray();
            if (selectorChars.length == 1 && selectorChars[0] == '*') {
                selectorChars = null;
            }
        }
        declaringTypeQualification = null;
        declaringTypeSimpleName = null;
        returnTypeQualification = null;
        returnTypeSimpleName = null;
        parameterTypeQualifications = null;
        parameterTypeSimpleNames = null;
        declaringTypeSignature = null;
        returnTypeSignature = null;
        parameterTypeSignatures = null;
        if (declaringType != null) {
            declaringTypePart = null;
            try {
                declaringTypeSignature = Signature.createTypeSignature(declaringType, false);
                declaringTypePart = declaringTypeSignature.indexOf(60) < 0 ? declaringType.toCharArray() : Signature.toCharArray(Signature.getTypeErasure(declaringTypeSignature.toCharArray()));
            }
            catch (IllegalArgumentException v4) {
                return null;
            }
            lastDotPosition = CharOperation.lastIndexOf('.', declaringTypePart);
            if (lastDotPosition >= 0) {
                declaringTypeQualification = CharOperation.subarray(declaringTypePart, 0, lastDotPosition);
                if (declaringTypeQualification.length == 1 && declaringTypeQualification[0] == '*') {
                    declaringTypeQualification = null;
                }
                declaringTypeSimpleName = CharOperation.subarray(declaringTypePart, lastDotPosition + 1, declaringTypePart.length);
            } else {
                declaringTypeSimpleName = declaringTypePart;
            }
            if (declaringTypeSimpleName.length == 1 && declaringTypeSimpleName[0] == '*') {
                declaringTypeSimpleName = null;
            }
        }
        if (parameterCount >= 0) {
            parameterTypeQualifications = new char[parameterCount][];
            parameterTypeSimpleNames = new char[parameterCount][];
            parameterTypeSignatures = new String[parameterCount];
            i = 0;
            while (i < parameterCount) {
                parameterTypePart = null;
                try {
                    if (parameterTypes != null) {
                        parameterTypeSignatures[i] = Signature.createTypeSignature(parameterTypes[i], false);
                        parameterTypePart = parameterTypeSignatures[i].indexOf(60) < 0 ? parameterTypes[i].toCharArray() : Signature.toCharArray(Signature.getTypeErasure(parameterTypeSignatures[i].toCharArray()));
                    }
                }
                catch (IllegalArgumentException v5) {
                    return null;
                }
                v6 = lastDotPosition = parameterTypePart == null ? -1 : CharOperation.lastIndexOf('.', parameterTypePart);
                if (parameterTypePart != null && lastDotPosition >= 0) {
                    parameterTypeQualifications[i] = CharOperation.subarray(parameterTypePart, 0, lastDotPosition);
                    parameterTypeQualifications[i] = (char[])(parameterTypeQualifications[i].length == 1 && parameterTypeQualifications[i][0] == '*' ? null : CharOperation.concat(IIndexConstants.ONE_STAR, parameterTypeQualifications[i]));
                    parameterTypeSimpleNames[i] = CharOperation.subarray(parameterTypePart, lastDotPosition + 1, parameterTypePart.length);
                } else {
                    parameterTypeQualifications[i] = null;
                    parameterTypeSimpleNames[i] = parameterTypePart;
                }
                if (parameterTypeSimpleNames[i].length == 1 && parameterTypeSimpleNames[i][0] == '*') {
                    parameterTypeSimpleNames[i] = null;
                }
                ++i;
            }
        }
        if (returnType != null) {
            returnTypePart = null;
            try {
                returnTypeSignature = Signature.createTypeSignature(returnType, false);
                returnTypePart = returnTypeSignature.indexOf(60) < 0 ? returnType.toCharArray() : Signature.toCharArray(Signature.getTypeErasure(returnTypeSignature.toCharArray()));
            }
            catch (IllegalArgumentException v7) {
                return null;
            }
            lastDotPosition = CharOperation.lastIndexOf('.', returnTypePart);
            if (lastDotPosition >= 0) {
                returnTypeQualification = CharOperation.subarray(returnTypePart, 0, lastDotPosition);
                returnTypeQualification = returnTypeQualification.length == 1 && returnTypeQualification[0] == '*' ? (char[])null : CharOperation.concat(IIndexConstants.ONE_STAR, returnTypeQualification);
                returnTypeSimpleName = CharOperation.subarray(returnTypePart, lastDotPosition + 1, returnTypePart.length);
            } else {
                returnTypeSimpleName = returnTypePart;
            }
            if (returnTypeSimpleName.length == 1 && returnTypeSimpleName[0] == '*') {
                returnTypeSimpleName = null;
            }
        }
        findDeclarations = true;
        findReferences = true;
        switch (limitTo) {
            case 0: {
                findReferences = false;
                break;
            }
            case 2: {
                findDeclarations = false;
                break;
            }
        }
        if (isConstructor) {
            return new ConstructorPattern(findDeclarations, findReferences, declaringTypeSimpleName, declaringTypeQualification, declaringTypeSignature, parameterTypeQualifications, parameterTypeSimpleNames, parameterTypeSignatures, typeArguments, matchRule);
        }
        return new MethodPattern(findDeclarations, findReferences, selectorChars, declaringTypeQualification, declaringTypeSimpleName, declaringTypeSignature, returnTypeQualification, returnTypeSimpleName, returnTypeSignature, parameterTypeQualifications, parameterTypeSimpleNames, parameterTypeSignatures, typeArguments, matchRule);
    }

    public static SearchPattern createOrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        return new OrPattern(leftPattern, rightPattern);
    }

    private static SearchPattern createPackagePattern(String patternString, int limitTo, int matchRule) {
        switch (limitTo) {
            case 0: {
                return new PackageDeclarationPattern(patternString.toCharArray(), matchRule);
            }
            case 2: {
                return new PackageReferencePattern(patternString.toCharArray(), matchRule);
            }
            case 3: {
                return new OrPattern(new PackageDeclarationPattern(patternString.toCharArray(), matchRule), new PackageReferencePattern(patternString.toCharArray(), matchRule));
            }
        }
        return null;
    }

    public static SearchPattern createPattern(String stringPattern, int searchFor, int limitTo, int matchRule) {
        if (stringPattern == null || stringPattern.length() == 0) {
            return null;
        }
        if ((matchRule = SearchPattern.validateMatchRule(stringPattern, matchRule)) == -1) {
            return null;
        }
        limitTo &= 0xFFFFFFCF;
        switch (searchFor) {
            case 5: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'C');
            }
            case 10: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\n');
            }
            case 9: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\t');
            }
            case 6: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'I');
            }
            case 7: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'E');
            }
            case 8: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'A');
            }
            case 0: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\u0000');
            }
            case 1: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, false);
            }
            case 3: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, true);
            }
            case 4: {
                return SearchPattern.createFieldPattern(stringPattern, limitTo, matchRule);
            }
            case 2: {
                return SearchPattern.createPackagePattern(stringPattern, limitTo, matchRule);
            }
        }
        return null;
    }

    public static SearchPattern createPattern(IJavaElement element, int limitTo) {
        return SearchPattern.createPattern(element, limitTo, 8);
    }

    public static SearchPattern createPattern(IJavaElement element, int limitTo, int matchRule) {
        SearchPattern searchPattern = null;
        boolean ignoreDeclaringType = false;
        boolean ignoreReturnType = false;
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        if (maskedLimitTo == 0 || maskedLimitTo == 3) {
            ignoreDeclaringType = (limitTo & 0x10) != 0;
            ignoreReturnType = (limitTo & 0x20) != 0;
        }
        char[] declaringSimpleName = null;
        char[] declaringQualification = null;
        switch (element.getElementType()) {
            case 8: {
                IField field = (IField)element;
                if (!ignoreDeclaringType) {
                    IType declaringClass = field.getDeclaringType();
                    declaringSimpleName = declaringClass.getElementName().toCharArray();
                    declaringQualification = declaringClass.getPackageFragment().getElementName().toCharArray();
                    char[][] enclosingNames = SearchPattern.enclosingTypeNames(declaringClass);
                    if (enclosingNames.length > 0) {
                        declaringQualification = CharOperation.concat(declaringQualification, CharOperation.concatWith(enclosingNames, '.'), '.');
                    }
                }
                char[] name = field.getElementName().toCharArray();
                char[] typeSimpleName = null;
                char[] typeQualification = null;
                String typeSignature = null;
                if (!ignoreReturnType) {
                    try {
                        typeSignature = field.getTypeSignature();
                        char[] signature = typeSignature.toCharArray();
                        char[] typeErasure = Signature.toCharArray(Signature.getTypeErasure(signature));
                        CharOperation.replace(typeErasure, '$', '.');
                        int lastDot = CharOperation.lastIndexOf('.', typeErasure);
                        if (lastDot == -1) {
                            typeSimpleName = typeErasure;
                        } else {
                            typeSimpleName = CharOperation.subarray(typeErasure, lastDot + 1, typeErasure.length);
                            typeQualification = CharOperation.subarray(typeErasure, 0, lastDot);
                            if (!field.isBinary()) {
                                CharOperation.concat(IIndexConstants.ONE_STAR, typeQualification);
                            }
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                }
                boolean findDeclarations = false;
                boolean readAccess = false;
                boolean writeAccess = false;
                switch (maskedLimitTo) {
                    case 0: {
                        findDeclarations = true;
                        break;
                    }
                    case 2: {
                        readAccess = true;
                        writeAccess = true;
                        break;
                    }
                    case 4: {
                        readAccess = true;
                        break;
                    }
                    case 5: {
                        writeAccess = true;
                        break;
                    }
                    case 3: {
                        findDeclarations = true;
                        readAccess = true;
                        writeAccess = true;
                    }
                }
                searchPattern = new FieldPattern(findDeclarations, readAccess, writeAccess, name, declaringQualification, declaringSimpleName, typeQualification, typeSimpleName, typeSignature, matchRule);
                break;
            }
            case 13: {
                String elementName = element.getElementName();
                int lastDot = elementName.lastIndexOf(46);
                if (lastDot == -1) {
                    return null;
                }
                IImportDeclaration importDecl = (IImportDeclaration)element;
                if (importDecl.isOnDemand()) {
                    searchPattern = SearchPattern.createPackagePattern(elementName.substring(0, lastDot), maskedLimitTo, matchRule);
                    break;
                }
                searchPattern = SearchPattern.createTypePattern(elementName.substring(lastDot + 1).toCharArray(), elementName.substring(0, lastDot).toCharArray(), null, null, null, maskedLimitTo, matchRule);
                break;
            }
            case 14: {
                LocalVariable localVar = (LocalVariable)element;
                boolean findVarDeclarations = false;
                boolean findVarReadAccess = false;
                boolean findVarWriteAccess = false;
                switch (maskedLimitTo) {
                    case 0: {
                        findVarDeclarations = true;
                        break;
                    }
                    case 2: {
                        findVarReadAccess = true;
                        findVarWriteAccess = true;
                        break;
                    }
                    case 4: {
                        findVarReadAccess = true;
                        break;
                    }
                    case 5: {
                        findVarWriteAccess = true;
                        break;
                    }
                    case 3: {
                        findVarDeclarations = true;
                        findVarReadAccess = true;
                        findVarWriteAccess = true;
                    }
                }
                searchPattern = new LocalVariablePattern(findVarDeclarations, findVarReadAccess, findVarWriteAccess, localVar, matchRule);
                break;
            }
            case 15: {
                ITypeParameter typeParam = (ITypeParameter)element;
                boolean findParamDeclarations = true;
                boolean findParamReferences = true;
                switch (maskedLimitTo) {
                    case 0: {
                        findParamReferences = false;
                        break;
                    }
                    case 2: {
                        findParamDeclarations = false;
                    }
                }
                searchPattern = new TypeParameterPattern(findParamDeclarations, findParamReferences, typeParam, matchRule);
                break;
            }
            case 9: {
                int lastDot;
                boolean isConstructor;
                IMethod method = (IMethod)element;
                try {
                    isConstructor = method.isConstructor();
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
                IType declaringClass = method.getDeclaringType();
                if (ignoreDeclaringType) {
                    if (isConstructor) {
                        declaringSimpleName = declaringClass.getElementName().toCharArray();
                    }
                } else {
                    declaringSimpleName = declaringClass.getElementName().toCharArray();
                    declaringQualification = declaringClass.getPackageFragment().getElementName().toCharArray();
                    char[][] enclosingNames = SearchPattern.enclosingTypeNames(declaringClass);
                    if (enclosingNames.length > 0) {
                        declaringQualification = CharOperation.concat(declaringQualification, CharOperation.concatWith(enclosingNames, '.'), '.');
                    }
                }
                char[] selector = method.getElementName().toCharArray();
                char[] returnSimpleName = null;
                char[] returnQualification = null;
                String returnSignature = null;
                if (!ignoreReturnType) {
                    try {
                        returnSignature = method.getReturnType();
                        char[] signature = returnSignature.toCharArray();
                        char[] returnErasure = Signature.toCharArray(Signature.getTypeErasure(signature));
                        CharOperation.replace(returnErasure, '$', '.');
                        lastDot = CharOperation.lastIndexOf('.', returnErasure);
                        if (lastDot == -1) {
                            returnSimpleName = returnErasure;
                        } else {
                            returnSimpleName = CharOperation.subarray(returnErasure, lastDot + 1, returnErasure.length);
                            returnQualification = CharOperation.subarray(returnErasure, 0, lastDot);
                            if (!method.isBinary()) {
                                CharOperation.concat(IIndexConstants.ONE_STAR, returnQualification);
                            }
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                }
                String[] parameterTypes = method.getParameterTypes();
                int paramCount = parameterTypes.length;
                char[][] parameterSimpleNames = new char[paramCount][];
                char[][] parameterQualifications = new char[paramCount][];
                String[] parameterSignatures = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    parameterSignatures[i] = parameterTypes[i];
                    char[] signature = parameterSignatures[i].toCharArray();
                    char[] paramErasure = Signature.toCharArray(Signature.getTypeErasure(signature));
                    CharOperation.replace(paramErasure, '$', '.');
                    lastDot = CharOperation.lastIndexOf('.', paramErasure);
                    if (lastDot == -1) {
                        parameterSimpleNames[i] = paramErasure;
                        parameterQualifications[i] = null;
                    } else {
                        parameterSimpleNames[i] = CharOperation.subarray(paramErasure, lastDot + 1, paramErasure.length);
                        parameterQualifications[i] = CharOperation.subarray(paramErasure, 0, lastDot);
                        if (!method.isBinary()) {
                            CharOperation.concat(IIndexConstants.ONE_STAR, parameterQualifications[i]);
                        }
                    }
                    ++i;
                }
                boolean findMethodDeclarations = true;
                boolean findMethodReferences = true;
                switch (maskedLimitTo) {
                    case 0: {
                        findMethodReferences = false;
                        break;
                    }
                    case 2: {
                        findMethodDeclarations = false;
                        break;
                    }
                }
                if (isConstructor) {
                    searchPattern = new ConstructorPattern(findMethodDeclarations, findMethodReferences, declaringSimpleName, declaringQualification, parameterQualifications, parameterSimpleNames, parameterSignatures, method, matchRule);
                    break;
                }
                searchPattern = new MethodPattern(findMethodDeclarations, findMethodReferences, selector, declaringQualification, declaringSimpleName, returnQualification, returnSimpleName, returnSignature, parameterQualifications, parameterSimpleNames, parameterSignatures, method, matchRule);
                break;
            }
            case 7: {
                IType type = (IType)element;
                searchPattern = SearchPattern.createTypePattern(type.getElementName().toCharArray(), type.getPackageFragment().getElementName().toCharArray(), ignoreDeclaringType ? null : SearchPattern.enclosingTypeNames(type), null, type, maskedLimitTo, matchRule);
                break;
            }
            case 4: 
            case 11: {
                searchPattern = SearchPattern.createPackagePattern(element.getElementName(), maskedLimitTo, matchRule);
            }
        }
        if (searchPattern != null) {
            MatchLocator.setFocus(searchPattern, element);
        }
        return searchPattern;
    }

    private static SearchPattern createTypePattern(char[] simpleName, char[] packageName, char[][] enclosingTypeNames, String typeSignature, IType type, int limitTo, int matchRule) {
        switch (limitTo) {
            case 0: {
                return new TypeDeclarationPattern(packageName, enclosingTypeNames, simpleName, '\u0000', matchRule);
            }
            case 2: {
                if (type != null) {
                    return new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '.'), simpleName, type, matchRule);
                }
                return new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '.'), simpleName, typeSignature, matchRule);
            }
            case 1: {
                return new SuperTypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '.'), simpleName, 1, matchRule);
            }
            case 3: {
                return new OrPattern(new TypeDeclarationPattern(packageName, enclosingTypeNames, simpleName, '\u0000', matchRule), type != null ? new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '.'), simpleName, type, matchRule) : new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '.'), simpleName, typeSignature, matchRule));
            }
        }
        return null;
    }

    private static SearchPattern createTypePattern(String patternString, int limitTo, int matchRule, char indexSuffix) {
        int token;
        Scanner scanner = new Scanner(false, true, false, 0x2F0000L, null, null, true);
        scanner.setSource(patternString.toCharArray());
        String type = null;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        int argCount = 0;
        while (token != 69) {
            if (argCount == 0) {
                switch (token) {
                    case 1000: {
                        break;
                    }
                    case 7: {
                        ++argCount;
                    }
                    default: {
                        if (type == null) {
                            type = scanner.getCurrentTokenString();
                            break;
                        }
                        type = String.valueOf(type) + scanner.getCurrentTokenString();
                        break;
                    }
                }
            } else {
                switch (token) {
                    case 8: 
                    case 11: 
                    case 12: {
                        --argCount;
                        break;
                    }
                    case 7: {
                        ++argCount;
                    }
                }
                if (type == null) {
                    return null;
                }
                type = String.valueOf(type) + scanner.getCurrentTokenString();
            }
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
        }
        if (type == null) {
            return null;
        }
        String typeSignature = null;
        char[] qualificationChars = null;
        char[] typeChars = null;
        char[] typePart = null;
        try {
            typeSignature = Signature.createTypeSignature(type, false);
            typePart = typeSignature.indexOf(60) < 0 ? type.toCharArray() : Signature.toCharArray(Signature.getTypeErasure(typeSignature.toCharArray()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        int lastDotPosition = CharOperation.lastIndexOf('.', typePart);
        if (lastDotPosition >= 0) {
            qualificationChars = CharOperation.subarray(typePart, 0, lastDotPosition);
            if (qualificationChars.length == 1 && qualificationChars[0] == '*') {
                qualificationChars = null;
            }
            typeChars = CharOperation.subarray(typePart, lastDotPosition + 1, typePart.length);
        } else {
            typeChars = typePart;
        }
        if (typeChars.length == 1 && typeChars[0] == '*') {
            typeChars = null;
        }
        switch (limitTo) {
            case 0: {
                return new QualifiedTypeDeclarationPattern(qualificationChars, typeChars, indexSuffix, matchRule);
            }
            case 2: {
                return new TypeReferencePattern(qualificationChars, typeChars, typeSignature, matchRule);
            }
            case 1: {
                return new SuperTypeReferencePattern(qualificationChars, typeChars, 1, indexSuffix, matchRule);
            }
            case 3: {
                return new OrPattern(new QualifiedTypeDeclarationPattern(qualificationChars, typeChars, indexSuffix, matchRule), new TypeReferencePattern(qualificationChars, typeChars, matchRule));
            }
        }
        return null;
    }

    private static char[][] enclosingTypeNames(IType type) {
        IJavaElement parent = type.getParent();
        switch (parent.getElementType()) {
            case 6: {
                IType declaringType = type.getDeclaringType();
                if (declaringType == null) {
                    return CharOperation.NO_CHAR_CHAR;
                }
                return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames(declaringType), declaringType.getElementName().toCharArray());
            }
            case 5: {
                return CharOperation.NO_CHAR_CHAR;
            }
            case 8: 
            case 9: 
            case 10: {
                IType declaringClass = ((IMember)parent).getDeclaringType();
                return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames(declaringClass), new char[][]{declaringClass.getElementName().toCharArray(), IIndexConstants.ONE_STAR});
            }
            case 7: {
                return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames((IType)parent), parent.getElementName().toCharArray());
            }
        }
        return null;
    }

    public void decodeIndexKey(char[] key) {
    }

    public abstract SearchPattern getBlankPattern();

    public char[] getIndexKey() {
        return null;
    }

    public char[][] getIndexCategories() {
        return CharOperation.NO_CHAR_CHAR;
    }

    public final int getMatchRule() {
        return this.matchRule;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    public boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            boolean matchFirstChar;
            boolean isCaseSensitive = (this.matchRule & 8) != 0;
            boolean isCamelCase = (this.matchRule & 0x80) != 0;
            int matchMode = this.matchRule & 7;
            boolean bl = matchFirstChar = !isCaseSensitive || pattern.length == 0 || name.length > 0 && pattern[0] == name[0];
            if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(pattern, name)) {
                return true;
            }
            switch (matchMode) {
                case 0: 
                case 64: {
                    if (isCamelCase) {
                        return false;
                    }
                    return matchFirstChar && CharOperation.equals(pattern, name, isCaseSensitive);
                }
                case 1: {
                    return matchFirstChar && CharOperation.prefixEquals(pattern, name, isCaseSensitive);
                }
                case 2: {
                    if (!isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, isCaseSensitive);
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    public static int validateMatchRule(String stringPattern, int matchRule) {
        if ((matchRule & 4) != 0 && ((matchRule & 2) != 0 || (matchRule & 1) != 0 || (matchRule & 0x80) != 0)) {
            return -1;
        }
        if ((matchRule & 2) != 0) {
            if ((matchRule & 1) != 0) {
                matchRule &= 0xFFFFFFFE;
            }
            int starIndex = stringPattern.indexOf(42);
            int questionIndex = stringPattern.indexOf(63);
            if (starIndex < 0 && questionIndex < 0) {
                matchRule &= 0xFFFFFFFD;
            } else if ((matchRule & 0x80) != 0) {
                matchRule &= 0xFFFFFF7F;
            }
        }
        if ((matchRule & 0x80) != 0) {
            int length = stringPattern.length();
            boolean validCamelCase = false;
            if (length > 1) {
                char ch;
                int idx = 0;
                if (Character.isJavaIdentifierStart(ch = stringPattern.charAt(idx++)) && Character.isUpperCase(ch = stringPattern.charAt(idx++))) {
                    while (idx < length && Character.isUpperCase(stringPattern.charAt(idx))) {
                        ++idx;
                    }
                    while (idx < length && !Character.isUpperCase(ch = stringPattern.charAt(idx)) && Character.isJavaIdentifierPart(ch)) {
                        ++idx;
                    }
                    boolean bl = validCamelCase = idx == length;
                }
            }
            if (validCamelCase) {
                if ((matchRule & 1) != 0 && (matchRule & 8) != 0) {
                    matchRule &= 0xFFFFFFFE;
                    matchRule &= 0xFFFFFFF7;
                }
            } else if (((matchRule &= 0xFFFFFF7F) & 1) == 0) {
                matchRule |= 1;
                matchRule |= 8;
            }
        }
        return matchRule;
    }

    public String toString() {
        return "SearchPattern";
    }
}

