/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveableModel;
import org.eclipse.ui.ISaveableModelSource;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class SaveableHelper {
    public static final int USER_RESPONSE = -1;
    private static int AutomatedResponse = -1;

    public static void testSetAutomatedResponse(int response) {
        AutomatedResponse = response;
    }

    public static int testGetAutomatedResponse() {
        return AutomatedResponse;
    }

    static boolean savePart(final ISaveablePart saveable, IWorkbenchPart part, IWorkbenchWindow window, boolean confirm) {
        if (!saveable.isDirty()) {
            return true;
        }
        if (confirm) {
            int choice = AutomatedResponse;
            if (choice == -1) {
                if (saveable instanceof ISaveablePart2) {
                    choice = ((ISaveablePart2)saveable).promptToSaveOnClose();
                }
                if (choice == -1 || choice == 3) {
                    String message = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)part.getTitle());
                    String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog d = new MessageDialog(window.getShell(), WorkbenchMessages.Save_Resource, null, message, 3, buttons, 0);
                    choice = d.open();
                }
            }
            switch (choice) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        if (saveable instanceof ISaveableModelSource) {
            return SaveableHelper.saveModels((ISaveableModelSource)((Object)saveable), window);
        }
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                saveable.doSave((IProgressMonitor)monitorWrap);
            }
        };
        return SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, progressOp, window);
    }

    private static boolean saveModels(ISaveableModelSource modelSource, final IWorkbenchWindow window) {
        ISaveableModel[] selectedModels = modelSource.getActiveModels();
        final ArrayList<ISaveableModel> dirtyModels = new ArrayList<ISaveableModel>();
        int i = 0;
        while (i < selectedModels.length) {
            ISaveableModel model = selectedModels[i];
            if (model.isDirty()) {
                dirtyModels.add(model);
            }
            ++i;
        }
        if (dirtyModels.isEmpty()) {
            return true;
        }
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                monitorWrap.beginTask("", dirtyModels.size());
                Iterator i = dirtyModels.iterator();
                while (i.hasNext()) {
                    ISaveableModel model = (ISaveableModel)i.next();
                    if (!model.isDirty()) {
                        monitor.worked(1);
                        continue;
                    }
                    try {
                        model.doSave((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorWrap, 1));
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)window.getShell(), (String)WorkbenchMessages.Error, (String)e.getMessage(), (IStatus)e.getStatus());
                    }
                    if (monitor.isCanceled()) break;
                }
                monitorWrap.done();
            }
        };
        return SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, progressOp, window);
    }

    static int savePart(final ISaveablePart2 saveable, IWorkbenchWindow window, boolean confirm) {
        IRunnableWithProgress progressOp;
        if (!saveable.isDirty()) {
            return 0;
        }
        if (confirm) {
            int choice = AutomatedResponse;
            if (choice == -1) {
                choice = saveable.promptToSaveOnClose();
            }
            if (choice != 0) {
                return choice == -1 ? 3 : choice;
            }
        }
        if (!SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                saveable.doSave((IProgressMonitor)monitorWrap);
            }
        }, window)) {
            return 2;
        }
        return 0;
    }

    static boolean runProgressMonitorOperation(String opName, final IRunnableWithProgress progressOp, IWorkbenchWindow window) {
        Object ctx = window instanceof ApplicationWindow ? window : new ProgressMonitorJobsDialog(window.getShell());
        final boolean[] wasCanceled = new boolean[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                progressOp.run(monitor);
                wasCanceled[0] = monitor.isCanceled();
            }
        };
        try {
            ctx.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            String title = NLS.bind((String)WorkbenchMessages.EditorManager_operationFailed, (Object)opName);
            Throwable targetExc = e.getTargetException();
            WorkbenchPlugin.log(title, (IStatus)new Status(2, "org.eclipse.ui", 0, title, targetExc));
            MessageDialog.openError((Shell)window.getShell(), (String)WorkbenchMessages.Error, (String)(String.valueOf(title) + ':' + targetExc.getMessage()));
        }
        catch (InterruptedException interruptedException) {
            wasCanceled[0] = true;
        }
        return !wasCanceled[0];
    }

    public static boolean needsSave(ISaveableModelSource modelSource) {
        ISaveableModel[] selectedModels = modelSource.getActiveModels();
        int i = 0;
        while (i < selectedModels.length) {
            ISaveableModel model = selectedModels[i];
            if (model.isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

