/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import java.util.Collection;
import org.eclipse.jface.internal.databinding.EventSource;
import org.eclipse.jface.internal.provisional.databinding.AbstractUpdatableSet;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IDataBindingContext;
import org.eclipse.jface.internal.provisional.databinding.IReadableSet;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableCellProvider;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableValue;
import org.eclipse.jface.internal.provisional.databinding.Property;
import org.eclipse.jface.internal.provisional.databinding.Updatable;
import org.eclipse.jface.internal.provisional.databinding.beans.TableModelDescription;

public class NestedUpdatableCellProvider
extends Updatable
implements IUpdatableCellProvider,
EventSource {
    private boolean updating = false;
    private ReadableSetWrapper readableSet = new ReadableSetWrapper();
    private IChangeListener innerSetChangeListener = new InnerChangeListener(this.readableSet);
    private IChangeListener innerCellChangeListener = new InnerChangeListener(this);
    private Object currentOuterValue;
    private IUpdatableCellProvider innerUpdatableCellProvider;
    private IDataBindingContext databindingContext;
    private TableModelDescription tableModelDescription;

    public NestedUpdatableCellProvider(IDataBindingContext databindingContext, final IUpdatableValue outerUpdatableValue, TableModelDescription tableModelDescription) {
        this.databindingContext = databindingContext;
        this.tableModelDescription = tableModelDescription;
        this.updateInnerUpdatable(outerUpdatableValue);
        IChangeListener outerChangeListener = new IChangeListener(){

            public void handleChange(ChangeEvent changeEvent) {
                if ((changeEvent.getChangeType() & 0x307) != 0) {
                    NestedUpdatableCellProvider.this.updateInnerUpdatable(outerUpdatableValue);
                    NestedUpdatableCellProvider.this.readableSet.fireEvent(1, null, null, null, -1);
                }
            }
        };
        outerUpdatableValue.addChangeListener(outerChangeListener);
    }

    private void updateInnerUpdatable(IUpdatableValue outerUpdatableValue) {
        this.currentOuterValue = outerUpdatableValue.getValue();
        if (this.innerUpdatableCellProvider != null) {
            this.innerUpdatableCellProvider.removeChangeListener(this.innerCellChangeListener);
            this.innerUpdatableCellProvider.getReadableSet().removeChangeListener(this.innerSetChangeListener);
            this.innerUpdatableCellProvider.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerUpdatableCellProvider = null;
        } else {
            this.innerUpdatableCellProvider = (IUpdatableCellProvider)this.databindingContext.createUpdatable(new TableModelDescription(new Property(this.currentOuterValue, this.tableModelDescription.getCollectionProperty().getPropertyID()), this.tableModelDescription.getColumnIDs()));
            this.innerUpdatableCellProvider.addChangeListener(this.innerCellChangeListener);
            this.innerUpdatableCellProvider.getReadableSet().addChangeListener(this.innerSetChangeListener);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.innerUpdatableCellProvider != null) {
            this.innerUpdatableCellProvider.dispose();
        }
        this.currentOuterValue = null;
        this.databindingContext = null;
        this.tableModelDescription = null;
        this.innerUpdatableCellProvider = null;
        this.innerCellChangeListener = null;
        this.innerSetChangeListener = null;
    }

    public IReadableSet getReadableSet() {
        return this.readableSet;
    }

    public Object getCellValue(Object element, int index) {
        return this.innerUpdatableCellProvider.getCellValue(element, index);
    }

    public void setCellValue(Object element, int index, Object value) {
        this.innerUpdatableCellProvider.setCellValue(element, index, value);
    }

    public ChangeEvent fireEvent(int changeType, Object oldValue, Object newValue, Object parent, int position) {
        return this.fireChangeEvent(changeType, oldValue, newValue, parent, position);
    }

    private final class ReadableSetWrapper
    extends AbstractUpdatableSet
    implements EventSource {
        ReadableSetWrapper() {
        }

        protected Collection computeElements() {
            return NestedUpdatableCellProvider.this.innerUpdatableCellProvider.getReadableSet().toCollection();
        }

        public ChangeEvent fireEvent(int changeType, Object oldValue, Object newValue, Object parent, int position) {
            return this.fireChangeEvent(changeType, oldValue, newValue, parent, position);
        }
    }

    private final class InnerChangeListener
    implements IChangeListener {
        private EventSource fireFrom;

        InnerChangeListener(EventSource fireFrom) {
            this.fireFrom = fireFrom;
        }

        public void handleChange(ChangeEvent changeEvent) {
            ChangeEvent nestedEvent;
            if (!NestedUpdatableCellProvider.this.updating && (nestedEvent = this.fireFrom.fireEvent(changeEvent.getChangeType(), changeEvent.getOldValue(), changeEvent.getNewValue(), changeEvent.getParent(), changeEvent.getPosition())).getVeto()) {
                changeEvent.setVeto(true);
            }
        }
    }
}

