/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import java.util.Collection;
import org.eclipse.jface.internal.databinding.Binding;
import org.eclipse.jface.internal.databinding.DataBindingContext;
import org.eclipse.jface.internal.provisional.databinding.BindingEvent;
import org.eclipse.jface.internal.provisional.databinding.BindingException;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableTree;

public class TreeBinding
extends Binding {
    private final IUpdatableTree target;
    private final IUpdatableTree model;
    private int updating = 0;
    private IChangeListener targetChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (TreeBinding.this.updating != 0 && changeEvent.getChangeType() != 32) {
                return;
            }
            if (changeEvent.getChangeType() != 8) {
                TreeBinding.this.update(TreeBinding.this.model, TreeBinding.this.target, changeEvent);
            }
        }
    };
    private IChangeListener modelChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (TreeBinding.this.updating != 0 && changeEvent.getChangeType() != 32) {
                return;
            }
            if ((changeEvent.getChangeType() & 0x31) != 0) {
                TreeBinding.this.update(TreeBinding.this.target, TreeBinding.this.model, changeEvent);
            }
        }
    };

    public TreeBinding(DataBindingContext context, IUpdatableTree target, IUpdatableTree model) {
        super(context);
        this.target = target;
        this.model = model;
        target.addChangeListener(this.targetChangeListener);
        model.addChangeListener(this.modelChangeListener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(IUpdatableTree needsUpdate, IUpdatableTree source, ChangeEvent event) {
        int index = event.getPosition();
        Object parent = event.getParent();
        try {
            ++this.updating;
            int copyType = 1;
            if (needsUpdate == this.target) {
                copyType = 0;
            }
            BindingEvent bindingEvent = new BindingEvent(event, copyType, 0);
            bindingEvent.originalValue = event.getNewValue();
            switch (event.getChangeType()) {
                case 32: {
                    bindingEvent.originalValue = needsUpdate.getElements(parent);
                    source.setElements(parent, (Object[])bindingEvent.originalValue);
                    break;
                }
                case 1: {
                    needsUpdate.setElement(parent, index, event.getNewValue());
                    break;
                }
                case 2: {
                    needsUpdate.addElement(parent, index, event.getNewValue());
                    break;
                }
                case 4: {
                    needsUpdate.removeElement(parent, index);
                    break;
                }
                case 16: {
                    Object val = event.getNewValue();
                    if (val.getClass().isArray()) {
                        needsUpdate.setElements(parent, (Object[])val);
                        break;
                    }
                    if (!(val instanceof Collection)) throw new BindingException("Invalid REPLACE event");
                    needsUpdate.setElements(parent, ((Collection)val).toArray());
                    break;
                }
            }
            if (this.failure(this.errMsg(this.fireBindingEvent(bindingEvent)))) {
                Object var9_9 = null;
                --this.updating;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            --this.updating;
            throw throwable;
        }
        {
            Object var9_11 = null;
            --this.updating;
            return;
        }
    }

    private String errMsg(String validationError) {
        this.context.updatePartialValidationError(this.targetChangeListener, null);
        this.context.updateValidationError(this.targetChangeListener, validationError);
        return validationError;
    }

    private boolean failure(String errorMessage) {
        return errorMessage != null;
    }

    public void updateTargetFromModel(ChangeEvent changeEvent) {
        this.copyRootContents(this.target, this.model);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyRootContents(IUpdatableTree destination, IUpdatableTree source) {
        try {
            ++this.updating;
            BindingEvent bindingEvent = new BindingEvent(null, 4, 0);
            bindingEvent.originalValue = source.getElements(null);
            destination.setElements(null, (Object[])bindingEvent.originalValue);
            this.fireBindingEvent(bindingEvent);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.updating;
            throw throwable;
        }
        {
            Object var4_6 = null;
            --this.updating;
            return;
        }
    }
}

