/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.beans;

import java.util.HashMap;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableCollection;

public class EditedCollectionRegistry {
    private static EditedCollectionRegistry instance = null;
    private HashMap editedCollections = new HashMap();

    public static EditedCollectionRegistry getDefault() {
        if (instance == null) {
            instance = new EditedCollectionRegistry();
        }
        return instance;
    }

    public static void setDefault(EditedCollectionRegistry instance) {
        EditedCollectionRegistry.instance = instance;
    }

    public synchronized void register(Object collection) {
        if (!this.editedCollections.containsKey(collection)) {
            EditedCollection editedCollection = new EditedCollection(collection);
            ++editedCollection.count;
            this.editedCollections.put(collection, editedCollection);
        }
    }

    public synchronized void unRegister(Object collection) {
        EditedCollection ec = (EditedCollection)this.editedCollections.get(collection);
        if (ec == null) {
            throw new IllegalArgumentException("Attept to unRegister an unregistered collection");
        }
        --ec.count;
        if (ec.count <= 0) {
            this.editedCollections.remove(collection);
        }
    }

    public IUpdatableCollection getUpdatable(Object collection) {
        EditedCollection ec = (EditedCollection)this.editedCollections.get(collection);
        if (ec == null) {
            throw new IllegalArgumentException("Attept to getUpdatable on an unregistered collection");
        }
        return ec.wrapper;
    }

    private static class EditedCollection {
        public int count = 0;
        public Object collection;
        public IUpdatableCollection wrapper;

        public boolean equals(Object arg0) {
            return this.collection.equals(arg0);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }

        public EditedCollection(Object collection) {
            this.collection = collection;
        }
    }
}

