/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.internal.databinding.beans.ListenerSupport;
import org.eclipse.jface.internal.provisional.databinding.UpdatableCollection;
import org.eclipse.jface.util.Assert;

public class JavaBeanUpdatableCollection
extends UpdatableCollection {
    private final Object object;
    private PropertyChangeListener collectionListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!event.getPropertyName().equals(JavaBeanUpdatableCollection.this.descriptor.getName())) {
                return;
            }
            if (!JavaBeanUpdatableCollection.this.updating && JavaBeanUpdatableCollection.this.descriptor.getName().equals(event.getPropertyName())) {
                Object[] values = JavaBeanUpdatableCollection.this.getValues();
                JavaBeanUpdatableCollection.this.elementListenerSupport.setHookTargets(values);
                JavaBeanUpdatableCollection.this.fireChangeEvent(1, null, null, -1);
            }
        }
    };
    private PropertyChangeListener elementListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Object[] values;
            int position;
            if (!JavaBeanUpdatableCollection.this.updating && (position = Arrays.asList(values = JavaBeanUpdatableCollection.this.getValues()).indexOf(event.getSource())) != -1) {
                JavaBeanUpdatableCollection.this.fireChangeEvent(1, event.getSource(), event.getSource(), position);
            }
        }
    };
    private boolean updating = false;
    private PropertyDescriptor descriptor;
    private Class elementType = null;
    private ListenerSupport collectionListenSupport = new ListenerSupport(this.collectionListener);
    private ListenerSupport elementListenerSupport = new ListenerSupport(this.elementListener);

    public JavaBeanUpdatableCollection(Object object, PropertyDescriptor descriptor, Class elementType) {
        this.object = object;
        this.descriptor = descriptor;
        this.elementType = elementType;
        this.collectionListenSupport.hookListener(this.object);
        this.elementListenerSupport.setHookTargets(this.getValues());
    }

    public void dispose() {
        super.dispose();
        this.elementListenerSupport.dispose();
        this.collectionListenSupport.dispose();
    }

    public int computeSize() {
        return this.getValues().length;
    }

    private Object primGetValues() {
        try {
            Method readMethod = this.descriptor.getReadMethod();
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(this.object, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        Assert.isTrue((boolean)false, (String)"Could not read collection values");
        return null;
    }

    private Object[] getValues() {
        Collection list;
        Object[] values = null;
        Object result = this.primGetValues();
        values = this.descriptor.getPropertyType().isArray() ? (Object[])result : ((list = (Collection)result) != null ? list.toArray() : new Object[]{});
        return values;
    }

    public int addElement(Object value, int index) {
        if (this.descriptor.getPropertyType().isArray()) {
            Assert.isTrue((boolean)false, (String)"cannot add elements");
        }
        Collection list = (Collection)this.primGetValues();
        if (index <= 0 || index > list.size()) {
            index = list.size();
        }
        list.add(value);
        this.fireChangeEvent(2, null, value, index);
        return index;
    }

    public void removeElement(int index) {
        if (this.descriptor.getPropertyType().isArray()) {
            Assert.isTrue((boolean)false, (String)"cannot remove elements");
        }
        Collection list = (Collection)this.primGetValues();
        Object o = null;
        int i = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (index == i) {
                o = iter.next();
                break;
            }
            iter.next();
            ++i;
        }
        if (o != null) {
            list.remove(o);
            this.fireChangeEvent(4, o, null, index);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setElement(int index, Object value) {
        this.updating = true;
        try {
            Object[] values = this.getValues();
            Object oldValue = values[index];
            values[index] = value;
            this.fireChangeEvent(1, oldValue, value, index);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.updating = false;
            return;
        }
    }

    public Object computeElement(int index) {
        return this.getValues()[index];
    }

    public Class getElementType() {
        return this.elementType;
    }

    public List getElements() {
        ArrayList<Object> elements = new ArrayList<Object>();
        int i = 0;
        while (i < this.getSize()) {
            elements.add(this.getElement(i));
            ++i;
        }
        return elements;
    }

    private static class IdentityWrapper {
        private final Object o;
        static /* synthetic */ Class class$0;

        IdentityWrapper(Object o) {
            this.o = o;
        }

        public boolean equals(Object obj) {
            Class<?> clazz = obj.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.jface.internal.databinding.beans.JavaBeanUpdatableCollection$IdentityWrapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                return false;
            }
            return this.o == ((IdentityWrapper)obj).o;
        }

        public int hashCode() {
            return System.identityHashCode(this.o);
        }
    }
}

