/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.databinding.beans.ListenerSupport;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IReadableSet;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableCellProvider;
import org.eclipse.jface.internal.provisional.databinding.Updatable;
import org.eclipse.jface.util.Policy;

public class JavaBeansUpdatableCellProvider
extends Updatable
implements IUpdatableCellProvider {
    private final IReadableSet readableSet;
    private final String[] propertyNames;
    private IChangeListener listener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            block3: {
                block2: {
                    if (changeEvent.getChangeType() != 256) break block2;
                    Collection added = (Collection)changeEvent.getNewValue();
                    Iterator iter = added.iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        JavaBeansUpdatableCellProvider.this.addBeansListenerTo(element);
                    }
                    break block3;
                }
                if (changeEvent.getChangeType() != 512) break block3;
                Collection removed = (Collection)changeEvent.getNewValue();
                Iterator iter = removed.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    JavaBeansUpdatableCellProvider.this.removeBeansListenerFrom(element);
                }
            }
        }
    };
    private boolean updating = false;
    private PropertyChangeListener elementListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!JavaBeansUpdatableCellProvider.this.updating && Arrays.asList(JavaBeansUpdatableCellProvider.this.propertyNames).indexOf(event.getPropertyName()) != -1) {
                JavaBeansUpdatableCellProvider.this.fireChangeEvent(1024, null, Collections.singletonList(event.getSource()));
            }
        }
    };
    private ListenerSupport listenerSupport = new ListenerSupport(this.elementListener);

    public JavaBeansUpdatableCellProvider(IReadableSet readableSet, String[] propertyNames) {
        this.readableSet = readableSet;
        this.propertyNames = propertyNames;
        readableSet.addChangeListener(this.listener);
        Iterator it = readableSet.toCollection().iterator();
        while (it.hasNext()) {
            this.addBeansListenerTo(it.next());
        }
    }

    protected void addBeansListenerTo(Object element) {
        this.listenerSupport.hookListener(element);
    }

    protected void removeBeansListenerFrom(Object element) {
        this.listenerSupport.unhookListener(element);
    }

    public IReadableSet getReadableSet() {
        return this.readableSet;
    }

    public Object getCellValue(Object element, int index) {
        if (index >= this.propertyNames.length) {
            return null;
        }
        String prop = this.propertyNames[index];
        try {
            Method getter = element.getClass().getMethod("get" + prop.substring(0, 1).toUpperCase(Locale.ENGLISH) + prop.substring(1), new Class[0]);
            return getter.invoke(element, new Object[0]);
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 4, "cannot get value", (Throwable)e));
            return null;
        }
    }

    public void setCellValue(Object element, int index, Object value) {
    }
}

