/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.jface.internal.databinding.swt.SyncRunnable;
import org.eclipse.jface.internal.provisional.databinding.BindingException;
import org.eclipse.jface.internal.provisional.databinding.SelectionAwareUpdatableCollection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class CComboUpdatableCollection
extends SelectionAwareUpdatableCollection {
    private final CCombo ccombo;
    private final String attribute;
    private boolean updating = false;
    static /* synthetic */ Class class$0;

    public CComboUpdatableCollection(CCombo ccombo, String attribute) {
        this.ccombo = ccombo;
        this.attribute = attribute.equals("content") ? "items" : attribute;
        if (!this.attribute.equals("items")) {
            throw new IllegalArgumentException();
        }
        ccombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!CComboUpdatableCollection.this.updating) {
                    CComboUpdatableCollection.this.fireChangeEvent(1, null, null);
                }
            }
        });
    }

    public int computeSize() {
        return this.ccombo.getItemCount();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addElement(Object value, int index) {
        this.updating = true;
        try {
            if (index < 0 || index > this.computeSize()) {
                index = this.computeSize();
            }
            String[] newItems = new String[this.computeSize() + 1];
            System.arraycopy(this.ccombo.getItems(), 0, newItems, 0, index);
            newItems[index] = (String)value;
            System.arraycopy(this.ccombo.getItems(), index, newItems, index + 1, this.computeSize() - index);
            this.ccombo.setItems(newItems);
            this.fireChangeEvent(2, null, value, index);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.updating = false;
            return index;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeElement(int index) {
        this.updating = true;
        try {
            if (index < 0) throw new BindingException("Request to remove an element out of the collection bounds");
            if (index > this.computeSize() - 1) {
                throw new BindingException("Request to remove an element out of the collection bounds");
            }
            String[] newItems = new String[this.computeSize() - 1];
            String old = this.ccombo.getItem(index);
            if (newItems.length > 0) {
                System.arraycopy(this.ccombo.getItems(), 0, newItems, 0, index);
                if (this.computeSize() - 1 > index) {
                    System.arraycopy(this.ccombo.getItems(), index + 1, newItems, index, this.computeSize() - index - 1);
                }
            }
            this.ccombo.setItems(newItems);
            this.fireChangeEvent(4, old, null, index);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.updating = false;
            return;
        }
    }

    public void setElement(int index, Object value) {
        String old = this.ccombo.getItem(index);
        this.ccombo.setItem(index, (String)value);
        this.fireChangeEvent(1, old, value, index);
    }

    public Object computeElement(int index) {
        return this.ccombo.getItem(index);
    }

    public Class getElementType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object getSelectedObject() {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                int index = CComboUpdatableCollection.this.ccombo.getSelectionIndex();
                if (index > -1) {
                    return CComboUpdatableCollection.this.ccombo.getItem(index);
                }
                return null;
            }
        };
        return runnable.runOn(this.ccombo.getDisplay());
    }

    public void setSelectedObject(final Object object) {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                if (object == null) {
                    CComboUpdatableCollection.this.ccombo.clearSelection();
                } else {
                    int index = CComboUpdatableCollection.this.ccombo.indexOf((String)object);
                    if (index != -1) {
                        CComboUpdatableCollection.this.ccombo.select(index);
                    }
                }
                return null;
            }
        };
        runnable.runOn(this.ccombo.getDisplay());
    }
}

